/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.assembler.PropertyInspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSLUtils {
    protected DSLUtils() {
    }

    protected Map<String, String> scanFieldNamesOnClass(Class clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        Class clazzMap = clazz;
        while (clazzMap != null) {
            for (Field field : clazzMap.getDeclaredFields()) {
                Class fieldType = PropertyInspector.getClassForType(field.getGenericType());
                map.put(field.getName(), fieldType.getCanonicalName());
            }
            Type type = clazzMap.getGenericSuperclass();
            if (type != null) {
                clazzMap = PropertyInspector.getClassForType(type);
                continue;
            }
            clazzMap = null;
        }
        return map;
    }

    protected Map<String, String> scanGetterNamesOnClass(Class clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (method.getTypeParameters().length != 0 || methodName.length() <= 3 || !methodName.startsWith("get")) continue;
            String fieldName = methodName.length() > 4 ? Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) : Character.toLowerCase(methodName.charAt(3)) + "";
            Class fieldType = PropertyInspector.getClassForType(method.getGenericReturnType());
            map.put(fieldName, fieldType.getCanonicalName());
        }
        return map;
    }
}

