/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.assembler.Assembler;
import com.inspiresoftware.lib.dto.geda.assembler.DTOtoEntitiesAssemblerDecoratorImpl;
import com.inspiresoftware.lib.dto.geda.assembler.DTOtoEntityAssemblerImpl;
import com.inspiresoftware.lib.dto.geda.assembler.MethodSynthesizerProxy;
import com.inspiresoftware.lib.dto.geda.assembler.annotations.AnnotationProxy;
import com.inspiresoftware.lib.dto.geda.assembler.annotations.impl.AnnotationProxies;
import com.inspiresoftware.lib.dto.geda.assembler.extension.Cache;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.IntHashTable;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.SoftReferenceCache;
import com.inspiresoftware.lib.dto.geda.dsl.Registry;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationDuplicateBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingAutobindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationValidatingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AutobindingClassNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.GeDAException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidDtoInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidEntityInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionScanningException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTOAssembler {
    public static final String SETTING_SYNTHESIZER_IMPL = "com.inspiresoftware.lib.dto.geda.assembler.DTOAssembler.SETTING_SYNTHESIZER_IMPL";
    public static final String SETTING_ENTITY_CLASS_NAME_BLACKLIST_PATTERN = "com.inspiresoftware.lib.dto.geda.assembler.DTOAssembler.SETTING_ENTITY_CLASS_NAME_BLACKLIST_PATTERN";
    private static final String SETTING_ENTITY_CLASS_NAME_BLACKLIST_PATTERN_DEFAULT = "_\\$\\$_";
    private static Pattern entityClassNameBlacklistPatternValue = Pattern.compile("_\\$\\$_");
    private static final WeakHashMap<ClassLoader, Cache<Assembler>> CL_CACHE = new WeakHashMap();
    private static final WeakHashMap<ClassLoader, MethodSynthesizer> CL_SYNTHESIZER = new WeakHashMap();
    private static final IntHashTable<Boolean> WHITELIST_ENTITIES = new IntHashTable();
    private static final IntHashTable<Class[]> AUTOBINDING = new IntHashTable();

    public static void setup(Properties props) throws NumberFormatException, GeDAException {
        String synthesizerImpl = props.getProperty(SETTING_SYNTHESIZER_IMPL);
        String classNameBlacklistPattern = props.getProperty(SETTING_ENTITY_CLASS_NAME_BLACKLIST_PATTERN);
        if (synthesizerImpl != null) {
            for (MethodSynthesizer synthesizer : CL_SYNTHESIZER.values()) {
                synthesizer.configure("synthesizerImpl", synthesizerImpl);
            }
        }
        if (classNameBlacklistPattern != null) {
            entityClassNameBlacklistPatternValue = Pattern.compile(classNameBlacklistPattern);
        }
    }

    private static Class filterBlacklisted(Class className) {
        int hash = className.hashCode();
        if (!WHITELIST_ENTITIES.containsKey(hash)) {
            if (DTOAssembler.matches(className.getSimpleName())) {
                if (!className.getSuperclass().equals(Object.class)) {
                    return DTOAssembler.filterBlacklisted(className.getSuperclass());
                }
            } else {
                WHITELIST_ENTITIES.put(hash, Boolean.TRUE);
            }
        }
        return className;
    }

    static boolean matches(String className) {
        Matcher match = entityClassNameBlacklistPatternValue.matcher(className);
        return match.find();
    }

    private static Assembler getAssemblerFromCache(ClassLoader cl, int cacheKey) {
        if (CL_CACHE.containsKey(cl)) {
            return CL_CACHE.get(cl).get(cacheKey);
        }
        return null;
    }

    private static Assembler putAssemblerToCache(ClassLoader cl, int cacheKey, Assembler asm) {
        Cache<Assembler> cache = CL_CACHE.get(cl);
        if (cache == null) {
            cache = new SoftReferenceCache<Assembler>();
            CL_CACHE.put(cl, cache);
        }
        cache.put(cacheKey, asm);
        return asm;
    }

    private static Assembler createNewAssembler(Class<?> dto, Class<?> entity, ClassLoader classLoader, Object synthesizer, Registry registry) throws InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        if (synthesizer instanceof MethodSynthesizerProxy) {
            return new DTOtoEntityAssemblerImpl(dto, entity, classLoader, (MethodSynthesizer)synthesizer, registry);
        }
        return new DTOtoEntityAssemblerImpl(dto, entity, classLoader, new MethodSynthesizerProxy(classLoader, synthesizer), registry);
    }

    private static Assembler createNewAssembler(Class<?> dto, Class<?>[] entities, ClassLoader classLoader, Object synthesizer, Registry registry) throws InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        if (synthesizer instanceof MethodSynthesizerProxy) {
            return new DTOtoEntitiesAssemblerDecoratorImpl(dto, entities, classLoader, (MethodSynthesizer)synthesizer, registry);
        }
        return new DTOtoEntitiesAssemblerDecoratorImpl(dto, entities, classLoader, new MethodSynthesizerProxy(classLoader, synthesizer), registry);
    }

    private static AnnotationProxy getDtoAnnotation(Class<?> dto) {
        AnnotationProxy ann = AnnotationProxies.getClassAnnotationProxy(dto);
        if (ann.annotationExists()) {
            return ann;
        }
        throw new AnnotationMissingException(dto.getCanonicalName());
    }

    private static AnnotationProxy getDtoAnnotationAuto(Class<?> dto) throws AnnotationMissingException, AnnotationMissingAutobindingException {
        AnnotationProxy ann = AnnotationProxies.getClassAnnotationProxy(dto);
        if (!ann.annotationExists()) {
            throw new AnnotationMissingException(dto.getCanonicalName());
        }
        String[] auto = (String[])ann.getValue("value");
        if (auto == null || auto.length == 0) {
            throw new AnnotationMissingAutobindingException(dto.getCanonicalName());
        }
        return ann;
    }

    private static Class[] detectAutobinding(Class<?> dto) throws AutobindingClassNotFoundException {
        int cacheKey = dto.hashCode();
        if (AUTOBINDING.containsKey(cacheKey)) {
            return AUTOBINDING.get(cacheKey);
        }
        AnnotationProxy ann = DTOAssembler.getDtoAnnotationAuto(dto);
        String[] auto = (String[])ann.getValue("value");
        Class[] classes = new Class[auto.length];
        for (int i = 0; i < auto.length; ++i) {
            String clazz = auto[i];
            try {
                if (clazz == null || clazz.length() == 0) {
                    throw new AnnotationMissingAutobindingException(dto.getCanonicalName());
                }
                classes[i] = Class.forName(clazz, true, dto.getClassLoader());
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                throw new AutobindingClassNotFoundException(dto.getCanonicalName(), clazz);
            }
        }
        AUTOBINDING.put(cacheKey, classes);
        return classes;
    }

    private static MethodSynthesizer getDefaultSynthesizer(ClassLoader classLoader) {
        MethodSynthesizer syn = CL_SYNTHESIZER.get(classLoader);
        if (syn == null) {
            syn = new MethodSynthesizerProxy(classLoader);
            CL_SYNTHESIZER.put(classLoader, syn);
        }
        return syn;
    }

    private static <DTO, Entity> int createAssemblerKey(Class<DTO> dto, Class<Entity> entity, Object synthesizer, Registry registry) {
        int result = dto.hashCode();
        result = 31 * result + entity.hashCode();
        result = 31 * result + synthesizer.hashCode();
        if (registry != null) {
            result = 31 * result + registry.hashCode();
        }
        return result;
    }

    private static <DTO, Entity> int createAssemblerKey(Class<DTO> dto, Class<Entity>[] entities, Object synthesizer, Registry registry) {
        int result = dto.hashCode();
        for (Class<Entity> entity : entities) {
            result = 31 * result + entity.hashCode();
        }
        result = 31 * result + synthesizer.hashCode();
        if (registry != null) {
            result = 31 * result + registry.hashCode();
        }
        return result;
    }

    public static Assembler newCustomAssembler(Class<?> dto, Class<?> entity, Object synthesizer) throws AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        return DTOAssembler.newCustomAssembler(dto, entity, DTOAssembler.class.getClassLoader(), synthesizer);
    }

    public static Assembler newCustomAssembler(Class<?> dto, Class<?> entity, ClassLoader classLoader, Object synthesizer) throws AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        Class realEntity = DTOAssembler.filterBlacklisted(entity);
        int key = DTOAssembler.createAssemblerKey(dto, realEntity, synthesizer, null);
        Assembler asm = DTOAssembler.getAssemblerFromCache(classLoader, key);
        if (asm != null) {
            return asm;
        }
        DTOAssembler.getDtoAnnotation(dto);
        return DTOAssembler.putAssemblerToCache(classLoader, key, DTOAssembler.createNewAssembler(dto, realEntity, classLoader, synthesizer, null));
    }

    public static Assembler newCustomAssembler(Class<?> dto, Class<?> entity, Registry registry, Object synthesizer) throws AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        return DTOAssembler.newCustomAssembler(dto, entity, DTOAssembler.class.getClassLoader(), registry, synthesizer);
    }

    public static Assembler newCustomAssembler(Class<?> dto, Class<?> entity, ClassLoader classLoader, Registry registry, Object synthesizer) throws AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        Class realEntity = DTOAssembler.filterBlacklisted(entity);
        int key = DTOAssembler.createAssemblerKey(dto, realEntity, synthesizer, registry);
        Assembler asm = DTOAssembler.getAssemblerFromCache(classLoader, key);
        if (asm != null) {
            return asm;
        }
        if (registry == null) {
            throw new GeDARuntimeException("Registry cannot be null");
        }
        return DTOAssembler.putAssemblerToCache(classLoader, key, DTOAssembler.createNewAssembler(dto, realEntity, classLoader, synthesizer, registry));
    }

    public static Assembler newCustomCompositeAssembler(Class<?> dto, Class<?>[] entities, Object synthesizer) throws AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        return DTOAssembler.newCustomCompositeAssembler(dto, entities, DTOAssembler.class.getClassLoader(), synthesizer);
    }

    public static Assembler newCustomCompositeAssembler(Class<?> dto, Class<?>[] entities, ClassLoader classLoader, Object synthesizer) throws AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        DTOAssembler.getDtoAnnotation(dto);
        return DTOAssembler.createNewAssembler(dto, entities, classLoader, synthesizer, null);
    }

    public static Assembler newAssembler(Class<?> dto, Class<?> entity) throws AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        return DTOAssembler.newAssembler(dto, entity, DTOAssembler.class.getClassLoader());
    }

    public static Assembler newAssembler(Class<?> dto, Class<?> entity, ClassLoader classLoader) throws AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        MethodSynthesizer synthesizer;
        Class realEntity = DTOAssembler.filterBlacklisted(entity);
        int key = DTOAssembler.createAssemblerKey(dto, realEntity, (Object)(synthesizer = DTOAssembler.getDefaultSynthesizer(classLoader)), null);
        Assembler asm = DTOAssembler.getAssemblerFromCache(classLoader, key);
        if (asm != null) {
            return asm;
        }
        DTOAssembler.getDtoAnnotation(dto);
        return DTOAssembler.putAssemblerToCache(classLoader, key, DTOAssembler.createNewAssembler(dto, realEntity, classLoader, (Object)synthesizer, null));
    }

    public static Assembler newAssembler(Class<?> dto, Class<?> entity, Registry registry) throws InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        return DTOAssembler.newAssembler(dto, entity, DTOAssembler.class.getClassLoader(), registry);
    }

    public static Assembler newAssembler(Class<?> dto, Class<?> entity, ClassLoader classLoader, Registry registry) throws InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        MethodSynthesizer synthesizer;
        Class realEntity = DTOAssembler.filterBlacklisted(entity);
        int key = DTOAssembler.createAssemblerKey(dto, realEntity, (Object)(synthesizer = DTOAssembler.getDefaultSynthesizer(classLoader)), registry);
        Assembler asm = DTOAssembler.getAssemblerFromCache(classLoader, key);
        if (asm != null) {
            return asm;
        }
        if (registry == null) {
            throw new GeDARuntimeException("Registry cannot be null");
        }
        return DTOAssembler.putAssemblerToCache(classLoader, key, DTOAssembler.createNewAssembler(dto, realEntity, classLoader, (Object)synthesizer, registry));
    }

    public static Assembler newCompositeAssembler(Class<?> dto, Class<?>[] entities) throws AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        return DTOAssembler.newCompositeAssembler(dto, entities, DTOAssembler.class.getClassLoader());
    }

    public static Assembler newCompositeAssembler(Class<?> dto, Class<?>[] entities, ClassLoader classLoader) throws AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        MethodSynthesizer synthesizer = DTOAssembler.getDefaultSynthesizer(classLoader);
        int key = DTOAssembler.createAssemblerKey(dto, entities, (Object)synthesizer, null);
        Assembler asm = DTOAssembler.getAssemblerFromCache(classLoader, key);
        if (asm != null) {
            return asm;
        }
        DTOAssembler.getDtoAnnotation(dto);
        return DTOAssembler.putAssemblerToCache(classLoader, key, DTOAssembler.createNewAssembler(dto, entities, classLoader, (Object)synthesizer, null));
    }

    public static Assembler newCustomAssembler(Class<?> dto, Object synthesizer) throws AnnotationMissingAutobindingException, AutobindingClassNotFoundException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        return DTOAssembler.newCustomAssembler(dto, DTOAssembler.class.getClassLoader(), synthesizer);
    }

    public static Assembler newCustomAssembler(Class<?> dto, ClassLoader classLoader, Object synthesizer) throws AnnotationMissingAutobindingException, AutobindingClassNotFoundException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        Class[] classes = DTOAssembler.detectAutobinding(dto);
        int key = DTOAssembler.createAssemblerKey(dto, classes, synthesizer, null);
        Assembler asm = DTOAssembler.getAssemblerFromCache(classLoader, key);
        if (asm != null) {
            return asm;
        }
        if (classes.length == 1) {
            return DTOAssembler.putAssemblerToCache(classLoader, key, DTOAssembler.createNewAssembler(dto, classes[0], classLoader, synthesizer, null));
        }
        return DTOAssembler.putAssemblerToCache(classLoader, key, DTOAssembler.createNewAssembler(dto, classes, classLoader, synthesizer, null));
    }

    public static Assembler newAssembler(Class<?> dto) throws AnnotationMissingAutobindingException, AutobindingClassNotFoundException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        return DTOAssembler.newAssembler(dto, DTOAssembler.class.getClassLoader());
    }

    public static Assembler newAssembler(Class<?> dto, ClassLoader classLoader) throws AnnotationMissingAutobindingException, AutobindingClassNotFoundException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        MethodSynthesizer synthesizer;
        Class[] classes = DTOAssembler.detectAutobinding(dto);
        int key = DTOAssembler.createAssemblerKey(dto, classes, (Object)(synthesizer = DTOAssembler.getDefaultSynthesizer(classLoader)), null);
        Assembler asm = DTOAssembler.getAssemblerFromCache(classLoader, key);
        if (asm != null) {
            return asm;
        }
        if (classes.length == 1) {
            return DTOAssembler.putAssemblerToCache(classLoader, key, DTOAssembler.createNewAssembler(dto, classes[0], classLoader, (Object)synthesizer, null));
        }
        return DTOAssembler.putAssemblerToCache(classLoader, key, DTOAssembler.createNewAssembler(dto, classes, classLoader, (Object)synthesizer, null));
    }

    public static void disposeOfDtoAssemblersBy(ClassLoader classLoader) {
        Cache<Assembler> cache;
        if (classLoader != null && (cache = CL_CACHE.get(classLoader)) != null) {
            cache.releaseResources();
            CL_CACHE.remove(classLoader);
        }
    }
}

