/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.assembler.Assembler;
import com.inspiresoftware.lib.dto.geda.assembler.AssemblerContext;
import com.inspiresoftware.lib.dto.geda.assembler.CollectionPipeBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.DTOAssembler;
import com.inspiresoftware.lib.dto.geda.assembler.DataPipeBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.DataPipeChainBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.DataVirtualPipeBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.MapPipeBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.MetadataChainAnnotationBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.MetadataChainBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.MetadataChainDSLBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.Pipe;
import com.inspiresoftware.lib.dto.geda.assembler.PipeBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.PropertyInspector;
import com.inspiresoftware.lib.dto.geda.assembler.extension.Configurable;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.meta.CollectionPipeMetadata;
import com.inspiresoftware.lib.dto.geda.assembler.meta.FieldPipeMetadata;
import com.inspiresoftware.lib.dto.geda.assembler.meta.MapPipeMetadata;
import com.inspiresoftware.lib.dto.geda.assembler.meta.PipeMetadata;
import com.inspiresoftware.lib.dto.geda.dsl.Registries;
import com.inspiresoftware.lib.dto.geda.dsl.Registry;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationDuplicateBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBeanKeyException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationValidatingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.CollectionEntityGenericReturnTypeException;
import com.inspiresoftware.lib.dto.geda.exception.DtoToEntityMatcherNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.EntityRetrieverNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.GeDAException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidDtoInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidEntityInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionScanningException;
import com.inspiresoftware.lib.dto.geda.exception.InvalidDtoCollectionException;
import com.inspiresoftware.lib.dto.geda.exception.InvalidEntityCollectionException;
import com.inspiresoftware.lib.dto.geda.exception.NotDtoToEntityMatcherException;
import com.inspiresoftware.lib.dto.geda.exception.NotEntityRetrieverException;
import com.inspiresoftware.lib.dto.geda.exception.NotValueConverterException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.ValueConverterNotFoundException;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTOtoEntityAssemblerImpl
implements Assembler,
AssemblerContext,
Configurable {
    private static final MetadataChainBuilder ANNOTATIONS = new MetadataChainAnnotationBuilder();
    private static final PipeBuilder<FieldPipeMetadata> FIELD = new DataPipeBuilder();
    private static final PipeBuilder<FieldPipeMetadata> VIRTUAL = new DataVirtualPipeBuilder();
    private static final PipeBuilder<CollectionPipeMetadata> COLLECTION = new CollectionPipeBuilder();
    private static final PipeBuilder<MapPipeMetadata> MAP = new MapPipeBuilder();
    private static final PipeBuilder<PipeMetadata> CHAIN = new DataPipeChainBuilder();
    private final Class dtoClass;
    private final Class entityClass;
    private final MethodSynthesizer synthesizer;
    private final Registry dslRegistry;
    private final Reference<ClassLoader> classLoader;
    private Pipe[] pipes;

    DTOtoEntityAssemblerImpl(Class dto, Class entity, ClassLoader classLoader, MethodSynthesizer synthesizer, Registry registry) throws InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        this(dto, entity, classLoader, synthesizer, registry, true);
    }

    DTOtoEntityAssemblerImpl(Class dto, Class entity, ClassLoader classLoader, MethodSynthesizer synthesizer, Registry registry, boolean strict) throws InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        this.dtoClass = dto;
        this.entityClass = entity;
        this.synthesizer = synthesizer;
        this.classLoader = new SoftReference<ClassLoader>(classLoader);
        this.dslRegistry = registry;
        MetadataChainBuilder metaBuilder = registry == null ? ANNOTATIONS : new MetadataChainDSLBuilder(registry, this.dtoClass, this.entityClass);
        Class dtoMap = dto;
        LinkedList<Pipe> pipes = new LinkedList<Pipe>();
        while (dtoMap != null) {
            this.mapRelationMapping(dtoMap, entity, strict, pipes, metaBuilder);
            Type type = dtoMap.getGenericSuperclass();
            if (type != null) {
                dtoMap = PropertyInspector.getClassForType(type);
                continue;
            }
            dtoMap = null;
        }
        this.pipes = pipes.toArray(new Pipe[pipes.size()]);
    }

    private void mapRelationMapping(Class dto, Class entity, boolean strict, List<Pipe> pipes, MetadataChainBuilder metaBuilder) throws InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        Field[] dtoFields;
        boolean isMapOrListEntity = Map.class.isAssignableFrom(entity) || List.class.isAssignableFrom(entity);
        PropertyDescriptor[] dtoPropertyDescriptors = PropertyInspector.getPropertyDescriptorsForClass(dto);
        PropertyDescriptor[] entityPropertyDescriptors = isMapOrListEntity ? null : PropertyInspector.getPropertyDescriptorsForClass(entity);
        TreeSet<String> bindings = new TreeSet<String>();
        for (Field dtoField : dtoFields = dto.getDeclaredFields()) {
            List<PipeMetadata> metas = metaBuilder.build(dtoField);
            if (metas == null || metas.isEmpty()) continue;
            try {
                Pipe pipe = this.createPipeChain(this.dtoClass, dtoPropertyDescriptors, this.entityClass, entityPropertyDescriptors, dtoField, metas, 0, isMapOrListEntity);
                String binding = pipe.getBinding();
                if (bindings.contains(binding)) {
                    throw new AnnotationDuplicateBindingException(this.dtoClass.getCanonicalName(), binding);
                }
                bindings.add(binding);
                pipes.add(pipe);
            }
            catch (InspectionBindingNotFoundException noField) {
                if (!strict) continue;
                throw noField;
            }
        }
    }

    private Pipe createPipeChain(Class dto, PropertyDescriptor[] dtoPropertyDescriptors, Class entity, PropertyDescriptor[] entityPropertyDescriptors, Field dtoField, List<PipeMetadata> metas, int index, boolean isMapOrListEntity) throws InspectionPropertyNotFoundException, InspectionBindingNotFoundException, InspectionScanningException, UnableToCreateInstanceException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException {
        PipeMetadata meta = metas.get(index);
        if (index + 1 == metas.size() || isMapOrListEntity) {
            if (meta instanceof FieldPipeMetadata) {
                if (meta.getEntityFieldName().startsWith("#this#")) {
                    return VIRTUAL.build(this, dto, entity, dtoPropertyDescriptors, entityPropertyDescriptors, (FieldPipeMetadata)meta, null);
                }
                return FIELD.build(this, dto, entity, dtoPropertyDescriptors, entityPropertyDescriptors, (FieldPipeMetadata)meta, null);
            }
            if (meta instanceof CollectionPipeMetadata) {
                return COLLECTION.build(this, dto, entity, dtoPropertyDescriptors, entityPropertyDescriptors, (CollectionPipeMetadata)meta, null);
            }
            if (meta instanceof MapPipeMetadata) {
                return MAP.build(this, dto, entity, dtoPropertyDescriptors, entityPropertyDescriptors, (MapPipeMetadata)meta, null);
            }
            throw new GeDARuntimeException("Unknown pipe meta: " + meta.getClass());
        }
        PropertyDescriptor nested = PropertyInspector.getEntityPropertyDescriptorForField(dto, entity, meta.getDtoFieldName(), meta.getEntityFieldName(), entityPropertyDescriptors);
        PropertyDescriptor[] nestedEntityPropertyDescriptors = PropertyInspector.getPropertyDescriptorsForClassReturnedByGet(nested);
        return CHAIN.build(this, dto, entity, dtoPropertyDescriptors, entityPropertyDescriptors, meta, this.createPipeChain(dto, dtoPropertyDescriptors, entity, nestedEntityPropertyDescriptors, dtoField, metas, index + 1, isMapOrListEntity));
    }

    @Override
    public boolean configure(String configuration, Object value) throws GeDAException {
        return this.synthesizer.configure(configuration, value);
    }

    private BeanFactory resolveBeanFactory(BeanFactory beanFactory) {
        if (beanFactory == null && this.dslRegistry != null) {
            return Registries.beanFactory(this.dslRegistry);
        }
        return beanFactory;
    }

    @Override
    public void assembleDto(Object dto, Object entity, Map<String, Object> converters, BeanFactory dtoBeanFactory) throws InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, AnnotationMissingException, NotValueConverterException, ValueConverterNotFoundException, UnableToCreateInstanceException, CollectionEntityGenericReturnTypeException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        this.validateDtoAndEntity(dto, entity);
        for (Pipe pipe : this.pipes) {
            pipe.writeFromEntityToDto(entity, dto, converters, this.resolveBeanFactory(dtoBeanFactory));
        }
    }

    @Override
    public void assembleDtos(Collection dtos, Collection entities, Map<String, Object> converters, BeanFactory dtoBeanFactory) throws InvalidDtoCollectionException, UnableToCreateInstanceException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, AnnotationMissingException, NotValueConverterException, ValueConverterNotFoundException, CollectionEntityGenericReturnTypeException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        if (dtos instanceof Collection && dtos.isEmpty() && entities instanceof Collection) {
            BeanFactory beanFactory = this.resolveBeanFactory(dtoBeanFactory);
            for (Object entity : entities) {
                try {
                    Object dto = this.dtoClass.newInstance();
                    this.assembleDto(dto, entity, converters, beanFactory);
                    dtos.add(dto);
                }
                catch (InstantiationException exp) {
                    throw new UnableToCreateInstanceException(this.dtoClass.getCanonicalName(), "Unable to create dto instance for: " + this.dtoClass.getName(), exp);
                }
                catch (IllegalAccessException exp) {
                    throw new UnableToCreateInstanceException(this.dtoClass.getCanonicalName(), "Unable to create dto instance for: " + this.dtoClass.getName(), exp);
                }
            }
        } else {
            throw new InvalidDtoCollectionException();
        }
    }

    @Override
    public void assembleEntity(Object dto, Object entity, Map<String, Object> converters, BeanFactory entityBeanFactory) throws InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, AnnotationMissingBeanKeyException, AnnotationMissingException, UnableToCreateInstanceException, CollectionEntityGenericReturnTypeException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        this.validateDtoAndEntity(dto, entity);
        for (Pipe pipe : this.pipes) {
            pipe.writeFromDtoToEntity(entity, dto, converters, this.resolveBeanFactory(entityBeanFactory));
        }
    }

    @Override
    public void assembleEntities(Collection dtos, Collection entities, Map<String, Object> converters, BeanFactory entityBeanFactory) throws UnableToCreateInstanceException, InvalidEntityCollectionException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, AnnotationMissingBeanKeyException, AnnotationMissingException, CollectionEntityGenericReturnTypeException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        if (dtos instanceof Collection && entities instanceof Collection && entities.isEmpty()) {
            BeanFactory beanFactory = this.resolveBeanFactory(entityBeanFactory);
            for (Object dto : dtos) {
                try {
                    Object entity = this.entityClass.newInstance();
                    this.assembleEntity(dto, entity, converters, beanFactory);
                    entities.add(entity);
                }
                catch (InstantiationException exp) {
                    throw new UnableToCreateInstanceException(this.dtoClass.getCanonicalName(), "Unable to create entity instance for: " + this.dtoClass.getName(), exp);
                }
                catch (IllegalAccessException exp) {
                    throw new UnableToCreateInstanceException(this.dtoClass.getCanonicalName(), "Unable to create entity instance for: " + this.dtoClass.getName(), exp);
                }
            }
        } else {
            throw new InvalidEntityCollectionException();
        }
    }

    private void validateDtoAndEntity(Object dto, Object entity) throws InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException {
        if (!this.dtoClass.isInstance(dto)) {
            throw new InspectionInvalidDtoInstanceException(this.dtoClass.getCanonicalName(), dto);
        }
        if (!this.entityClass.isInstance(entity)) {
            throw new InspectionInvalidEntityInstanceException(this.entityClass.getCanonicalName(), entity);
        }
    }

    @Override
    public Assembler newAssembler(Class<?> dto, Class<?> entity) {
        if (this.dslRegistry == null) {
            return DTOAssembler.newCustomAssembler(dto, entity, this.getClassLoader(), (Object)this.synthesizer);
        }
        return DTOAssembler.newCustomAssembler(dto, entity, this.getClassLoader(), this.dslRegistry, this.synthesizer);
    }

    @Override
    public MethodSynthesizer getMethodSynthesizer() {
        return this.synthesizer;
    }

    @Override
    public Registry getDslRegistry() {
        return this.dslRegistry;
    }

    @Override
    public ClassLoader getClassLoader() throws GeDARuntimeException {
        ClassLoader cl = this.classLoader.get();
        if (cl == null) {
            throw new GeDARuntimeException("Class loader has been gc'ed");
        }
        return cl;
    }

    @Override
    public void releaseResources() {
        this.synthesizer.releaseResources();
        if (this.dslRegistry != null) {
            this.dslRegistry.releaseResources();
        }
    }
}

