/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.adapter.EntityRetriever;
import com.inspiresoftware.lib.dto.geda.adapter.ValueConverter;
import com.inspiresoftware.lib.dto.geda.assembler.Assembler;
import com.inspiresoftware.lib.dto.geda.assembler.AssemblerContext;
import com.inspiresoftware.lib.dto.geda.assembler.Pipe;
import com.inspiresoftware.lib.dto.geda.assembler.PipeValidator;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.meta.FieldPipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationDuplicateBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBeanKeyException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationValidatingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.CollectionEntityGenericReturnTypeException;
import com.inspiresoftware.lib.dto.geda.exception.DtoToEntityMatcherNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.EntityRetrieverNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidDtoInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidEntityInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionScanningException;
import com.inspiresoftware.lib.dto.geda.exception.NotDtoToEntityMatcherException;
import com.inspiresoftware.lib.dto.geda.exception.NotEntityRetrieverException;
import com.inspiresoftware.lib.dto.geda.exception.NotValueConverterException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.ValueConverterNotFoundException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataPipe
implements Pipe {
    private final FieldPipeMetadata meta;
    private final DataReader dtoParentKeyRead;
    private final AssemblerContext context;
    private final DataReader dtoRead;
    private final DataWriter dtoWrite;
    private final DataReader entityRead;
    private final DataWriter entityWrite;
    private final boolean readOnly;
    private final boolean usesConverter;
    private final boolean hasSubEntity;
    private static final Object NULL = null;

    public DataPipe(AssemblerContext context, DataReader dtoRead, DataWriter dtoWrite, DataReader dtoParentKeyRead, DataReader entityRead, DataWriter entityWrite, FieldPipeMetadata meta) throws AnnotationMissingBindingException, AnnotationValidatingBindingException {
        this.meta = meta;
        this.usesConverter = meta.getConverterKey() != null && meta.getConverterKey().length() > 0;
        this.hasSubEntity = meta.getDtoBeanKey() != null && meta.getDtoBeanKey().length() > 0;
        this.context = context;
        this.dtoWrite = dtoWrite;
        this.entityRead = entityRead;
        this.readOnly = meta.isReadOnly();
        if (this.readOnly) {
            PipeValidator.validateReadPipeNonNull(this.dtoWrite, this.meta.getDtoFieldName(), this.entityRead, this.meta.getEntityFieldName());
            this.dtoRead = null;
            this.entityWrite = null;
            if (!this.usesConverter) {
                PipeValidator.validateReadPipeTypes(context.getDslRegistry(), this.dtoWrite, this.meta.getDtoFieldName(), this.entityRead, this.meta.getEntityFieldName());
            }
        } else {
            this.dtoRead = dtoRead;
            this.entityWrite = entityWrite;
            PipeValidator.validatePipeNonNull(this.dtoRead, this.dtoWrite, this.meta.getDtoFieldName(), this.entityRead, this.entityWrite, this.meta.getEntityFieldName());
            if (!this.usesConverter) {
                PipeValidator.validatePipeTypes(context.getDslRegistry(), this.dtoRead, this.dtoWrite, this.meta.getDtoFieldName(), this.entityRead, this.entityWrite, this.meta.getEntityFieldName());
            }
        }
        if (this.meta.isChild()) {
            this.dtoParentKeyRead = dtoParentKeyRead;
            PipeValidator.validatePipeNonNull(this.dtoParentKeyRead, AnnotationMissingBindingException.MissingBindingType.PARENT_READ, this.meta.getDtoFieldName());
        } else {
            this.dtoParentKeyRead = null;
        }
    }

    @Override
    public String getBinding() {
        return this.meta.getEntityFieldName();
    }

    @Override
    public void writeFromEntityToDto(Object entity, Object dto, Map<String, Object> converters, BeanFactory dtoBeanFactory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, AnnotationMissingException, NotValueConverterException, ValueConverterNotFoundException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, CollectionEntityGenericReturnTypeException {
        if (entity == null) {
            return;
        }
        Object entityData = this.entityRead.read(entity);
        if (entityData != null) {
            if (this.hasSubEntity) {
                this.createDtoAndWriteFromEntityToDto(dto, converters, dtoBeanFactory, entityData);
            } else if (this.usesConverter) {
                this.dtoWrite.write(dto, this.getConverter(converters).convertToDto(entityData, dtoBeanFactory));
            } else {
                this.dtoWrite.write(dto, entityData);
            }
        } else {
            this.dtoWrite.write(dto, NULL);
        }
    }

    private void createDtoAndWriteFromEntityToDto(Object dto, Map<String, Object> converters, BeanFactory dtoBeanFactory, Object entityData) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, NotValueConverterException, ValueConverterNotFoundException, CollectionEntityGenericReturnTypeException {
        if (dtoBeanFactory == null) {
            throw new BeanFactoryNotFoundException(this.meta.getDtoFieldName(), this.meta.getDtoBeanKey(), true);
        }
        Object newDtoObject = this.meta.newDtoBean(dtoBeanFactory);
        Assembler assembler = this.context.newAssembler(newDtoObject.getClass(), entityData.getClass());
        assembler.assembleDto(newDtoObject, entityData, converters, dtoBeanFactory);
        this.dtoWrite.write(dto, newDtoObject);
    }

    @Override
    public void writeFromDtoToEntity(Object entity, Object dto, Map<String, Object> converters, BeanFactory entityBeanFactory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, AnnotationMissingBeanKeyException, AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, CollectionEntityGenericReturnTypeException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        if (this.readOnly) {
            return;
        }
        Object dtoData = this.dtoRead.read(dto);
        if (this.meta.isChild()) {
            this.writeParentObject(dtoData, entity, converters, entityBeanFactory);
            return;
        }
        Object dtoValue = this.getDtoValue(dtoData, entity, converters, entityBeanFactory);
        if (dtoValue != null) {
            if (this.hasSubEntity) {
                this.assembleSubEntity(dtoValue, entity, converters, entityBeanFactory);
            } else {
                this.entityWrite.write(entity, dtoValue);
            }
        } else if (entity != null) {
            this.entityWrite.write(entity, NULL);
        }
    }

    private Object getDtoValue(Object dtoData, Object entity, Map<String, Object> converters, BeanFactory entityBeanFactory) throws NotValueConverterException, ValueConverterNotFoundException {
        if (this.usesConverter) {
            return this.getConverter(converters).convertToEntity(dtoData, entity, entityBeanFactory);
        }
        return dtoData;
    }

    private void assembleSubEntity(Object dtoValue, Object parentEntity, Map<String, Object> converters, BeanFactory entityBeanFactory) throws BeanFactoryNotFoundException, AnnotationMissingBeanKeyException, BeanFactoryUnableToCreateInstanceException, AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, CollectionEntityGenericReturnTypeException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        Object dataEntity = this.entityRead.read(parentEntity);
        if (dataEntity == null) {
            if (entityBeanFactory == null) {
                throw new BeanFactoryNotFoundException(this.meta.getDtoFieldName() + ":" + dtoValue.getClass(), this.meta.getEntityBeanKey(), false);
            }
            if (this.meta.getEntityBeanKey() == null) {
                throw new AnnotationMissingBeanKeyException(this.meta.getDtoFieldName() + ":" + dtoValue.getClass(), false);
            }
            dataEntity = this.meta.newEntityBean(entityBeanFactory);
            this.entityWrite.write(parentEntity, dataEntity);
        }
        Assembler assembler = this.context.newAssembler(dtoValue.getClass(), dataEntity.getClass());
        assembler.assembleEntity(dtoValue, dataEntity, converters, entityBeanFactory);
    }

    private void writeParentObject(Object dtoData, Object entity, Map<String, Object> converters, BeanFactory entityBeanFactory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException {
        if (dtoData == null) {
            if (entity != null) {
                this.entityWrite.write(entity, NULL);
            }
        } else {
            Object primaryKey = this.dtoParentKeyRead.read(dtoData);
            Class<?> returnType = this.entityRead.getReturnType();
            if (entityBeanFactory == null || this.meta.getEntityBeanKey() == null) {
                throw new BeanFactoryNotFoundException(dtoData.getClass() + ":" + this.meta.getParentEntityPrimaryKeyField(), this.meta.getEntityBeanKey(), false);
            }
            Class<?> beanClass = this.meta.newEntityBean(entityBeanFactory).getClass();
            Object entityForPk = this.getRetriever(converters).retrieveByPrimaryKey(returnType, beanClass, primaryKey);
            this.entityWrite.write(entity, entityForPk);
        }
    }

    private ValueConverter getConverter(Map<String, Object> converters) throws NotValueConverterException, ValueConverterNotFoundException {
        if (converters != null && !converters.isEmpty() && converters.containsKey(this.meta.getConverterKey())) {
            Object conv = converters.get(this.meta.getConverterKey());
            if (conv instanceof ValueConverter) {
                return (ValueConverter)conv;
            }
            throw new NotValueConverterException(this.meta.getDtoFieldName(), this.meta.getEntityFieldName(), this.meta.getConverterKey());
        }
        throw new ValueConverterNotFoundException(this.meta.getDtoFieldName(), this.meta.getEntityFieldName(), this.meta.getConverterKey());
    }

    private EntityRetriever getRetriever(Map<String, Object> converters) throws NotEntityRetrieverException, EntityRetrieverNotFoundException {
        if (converters != null && !converters.isEmpty() && converters.containsKey(this.meta.getEntityRetrieverKey())) {
            Object conv = converters.get(this.meta.getEntityRetrieverKey());
            if (conv instanceof EntityRetriever) {
                return (EntityRetriever)conv;
            }
            throw new NotEntityRetrieverException(this.meta.getEntityFieldName(), this.meta.getDtoFieldName(), this.meta.getConverterKey());
        }
        throw new EntityRetrieverNotFoundException(this.meta.getEntityFieldName(), this.meta.getDtoFieldName(), this.meta.getEntityRetrieverKey());
    }
}

