/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.assembler.AssemblerContext;
import com.inspiresoftware.lib.dto.geda.assembler.BasePipeBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.DataPipe;
import com.inspiresoftware.lib.dto.geda.assembler.Pipe;
import com.inspiresoftware.lib.dto.geda.assembler.PropertyInspector;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.meta.FieldPipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationValidatingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionScanningException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataPipeBuilder
extends BasePipeBuilder<FieldPipeMetadata> {
    DataPipeBuilder() {
    }

    @Override
    public Pipe build(AssemblerContext context, Class dtoClass, Class entityClass, PropertyDescriptor[] dtoPropertyDescriptors, PropertyDescriptor[] entityPropertyDescriptors, FieldPipeMetadata meta, Pipe pipe) throws InspectionPropertyNotFoundException, InspectionBindingNotFoundException, InspectionScanningException, UnableToCreateInstanceException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException {
        DataReader dtoParentReadMethod;
        PropertyDescriptor entityFieldDesc;
        MethodSynthesizer entitySynthesizer;
        boolean isMapEntity = Map.class.isAssignableFrom(entityClass);
        boolean isListEntity = !isMapEntity && List.class.isAssignableFrom(entityClass);
        PropertyDescriptor dtoFieldDesc = PropertyInspector.getDtoPropertyDescriptorForField(dtoClass, meta.getDtoFieldName(), dtoPropertyDescriptors);
        MethodSynthesizer synthesizer = context.getMethodSynthesizer();
        if (isMapEntity || isListEntity) {
            entitySynthesizer = isMapEntity ? mapSynthesizer : listSynthesizer;
            entityFieldDesc = dtoFieldDesc;
        } else {
            entitySynthesizer = synthesizer;
            entityFieldDesc = PropertyInspector.getEntityPropertyDescriptorForField(dtoClass, entityClass, meta.getDtoFieldName(), meta.getEntityFieldName(), entityPropertyDescriptors);
        }
        if (meta.isChild()) {
            Class returnTypeClass;
            Method parentGet = dtoFieldDesc.getReadMethod();
            try {
                returnTypeClass = PropertyInspector.getClassForType(parentGet.getGenericReturnType());
            }
            catch (GeDARuntimeException gre) {
                throw new GeDARuntimeException("Generics tree is too complex only rawTypes are supported class: " + dtoClass.getSimpleName() + ", method: " + parentGet.getName(), gre);
            }
            PropertyDescriptor[] dtoSubPropertyDescriptors = PropertyInspector.getPropertyDescriptorsForClass(returnTypeClass);
            PropertyDescriptor dtoParentDesc = PropertyInspector.getDtoPropertyDescriptorForField(dtoClass, meta.getParentEntityPrimaryKeyField(), dtoSubPropertyDescriptors);
            dtoParentReadMethod = context.getMethodSynthesizer().synthesizeReader(dtoParentDesc);
        } else {
            dtoParentReadMethod = null;
        }
        return new DataPipe(context, meta.isReadOnly() ? null : synthesizer.synthesizeReader(dtoFieldDesc), synthesizer.synthesizeWriter(dtoFieldDesc), dtoParentReadMethod, entitySynthesizer.synthesizeReader(entityFieldDesc), meta.isReadOnly() ? null : entitySynthesizer.synthesizeWriter(entityFieldDesc), meta);
    }
}

