/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.assembler.Pipe;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.meta.PipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationDuplicateBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBeanKeyException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationValidatingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.CollectionEntityGenericReturnTypeException;
import com.inspiresoftware.lib.dto.geda.exception.DtoToEntityMatcherNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.EntityRetrieverNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidDtoInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidEntityInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionScanningException;
import com.inspiresoftware.lib.dto.geda.exception.NotDtoToEntityMatcherException;
import com.inspiresoftware.lib.dto.geda.exception.NotEntityRetrieverException;
import com.inspiresoftware.lib.dto.geda.exception.NotValueConverterException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.ValueConverterNotFoundException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataPipeChain
implements Pipe {
    private final PipeMetadata meta;
    private final DataReader entityRead;
    private final DataWriter entityWrite;
    private final DataReader dtoRead;
    private final Pipe pipe;

    public DataPipeChain(DataReader dtoRead, DataReader entityRead, DataWriter entityWrite, Pipe pipe, PipeMetadata meta) {
        this.dtoRead = meta.isReadOnly() ? null : dtoRead;
        this.entityRead = entityRead;
        this.entityWrite = entityWrite;
        this.pipe = pipe;
        this.meta = meta;
    }

    @Override
    public String getBinding() {
        return this.meta.getEntityFieldName() + "." + this.pipe.getBinding();
    }

    @Override
    public void writeFromDtoToEntity(Object entity, Object dto, Map<String, Object> converters, BeanFactory entityBeanFactory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, AnnotationMissingBeanKeyException, AnnotationMissingException, UnableToCreateInstanceException, CollectionEntityGenericReturnTypeException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        if (this.meta.isReadOnly()) {
            return;
        }
        Object dtoData = this.dtoRead.read(dto);
        Object entityData = this.entityRead.read(entity);
        if (entityData == null) {
            if (dtoData == null) {
                return;
            }
            if (entityBeanFactory == null) {
                throw new BeanFactoryNotFoundException(this.meta.getEntityFieldName(), this.meta.getEntityBeanKey(), false);
            }
            entityData = this.meta.newEntityBean(entityBeanFactory);
            this.entityWrite.write(entity, entityData);
        }
        this.pipe.writeFromDtoToEntity(entityData, dto, converters, entityBeanFactory);
    }

    @Override
    public void writeFromEntityToDto(Object entity, Object dto, Map<String, Object> converters, BeanFactory dtoBeanFactory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, AnnotationMissingException, NotValueConverterException, ValueConverterNotFoundException, UnableToCreateInstanceException, CollectionEntityGenericReturnTypeException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        if (entity == null) {
            return;
        }
        Object entityDataDelegate = this.entityRead.read(entity);
        this.pipe.writeFromEntityToDto(entityDataDelegate, dto, converters, dtoBeanFactory);
    }
}

