/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.assembler.AssemblerContext;
import com.inspiresoftware.lib.dto.geda.assembler.BasePipeBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.DataPipeChain;
import com.inspiresoftware.lib.dto.geda.assembler.Pipe;
import com.inspiresoftware.lib.dto.geda.assembler.PropertyInspector;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.meta.PipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataPipeChainBuilder
extends BasePipeBuilder<PipeMetadata> {
    DataPipeChainBuilder() {
    }

    @Override
    public Pipe build(AssemblerContext context, Class dtoClass, Class entityClass, PropertyDescriptor[] dtoPropertyDescriptors, PropertyDescriptor[] entityPropertyDescriptors, PipeMetadata meta, Pipe pipe) throws InspectionBindingNotFoundException, InspectionPropertyNotFoundException, UnableToCreateInstanceException, GeDARuntimeException {
        PropertyDescriptor entityFieldDesc;
        MethodSynthesizer entitySynthesizer;
        boolean isMapEntity = Map.class.isAssignableFrom(entityClass);
        boolean isListEntity = !isMapEntity && List.class.isAssignableFrom(entityClass);
        PropertyDescriptor dtoFieldDesc = PropertyInspector.getDtoPropertyDescriptorForField(dtoClass, meta.getDtoFieldName(), dtoPropertyDescriptors);
        MethodSynthesizer synthesizer = context.getMethodSynthesizer();
        if (isMapEntity || isListEntity) {
            entitySynthesizer = isMapEntity ? mapSynthesizer : listSynthesizer;
            entityFieldDesc = PropertyInspector.getDtoPropertyDescriptorForField(dtoClass, meta.getDtoFieldName(), dtoPropertyDescriptors);
        } else {
            entitySynthesizer = synthesizer;
            entityFieldDesc = PropertyInspector.getEntityPropertyDescriptorForField(dtoClass, entityClass, meta.getDtoFieldName(), meta.getEntityFieldName(), entityPropertyDescriptors);
        }
        DataReader entityFieldRead = entitySynthesizer.synthesizeReader(entityFieldDesc);
        DataWriter entityFieldWrite = meta.isReadOnly() ? null : entitySynthesizer.synthesizeWriter(entityFieldDesc);
        return new DataPipeChain(meta.isReadOnly() ? null : synthesizer.synthesizeReader(dtoFieldDesc), entityFieldRead, entityFieldWrite, pipe, meta);
    }
}

