/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.adapter.ValueConverter;
import com.inspiresoftware.lib.dto.geda.assembler.Pipe;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.meta.FieldPipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationDuplicateBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBeanKeyException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationValidatingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.CollectionEntityGenericReturnTypeException;
import com.inspiresoftware.lib.dto.geda.exception.DtoToEntityMatcherNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.EntityRetrieverNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidDtoInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidEntityInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionScanningException;
import com.inspiresoftware.lib.dto.geda.exception.NotDtoToEntityMatcherException;
import com.inspiresoftware.lib.dto.geda.exception.NotEntityRetrieverException;
import com.inspiresoftware.lib.dto.geda.exception.NotValueConverterException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.ValueConverterNotFoundException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataVirtualPipe
implements Pipe {
    private final FieldPipeMetadata meta;
    private final DataReader dtoRead;
    private final DataWriter dtoWrite;
    private static final Object NULL = null;

    public DataVirtualPipe(DataReader dtoRead, DataWriter dtoWrite, FieldPipeMetadata meta) throws AnnotationMissingBindingException, AnnotationValidatingBindingException {
        this.meta = meta;
        this.dtoWrite = dtoWrite;
        this.dtoRead = meta.isReadOnly() ? null : dtoRead;
        if (meta.getConverterKey() == null || meta.getConverterKey().length() == 0) {
            throw new AnnotationMissingBindingException(AnnotationMissingBindingException.MissingBindingType.VIRTUAL_CONVERTER, meta.getDtoFieldName());
        }
    }

    @Override
    public String getBinding() {
        return this.meta.getEntityFieldName();
    }

    @Override
    public void writeFromEntityToDto(Object entity, Object dto, Map<String, Object> converters, BeanFactory dtoBeanFactory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, AnnotationMissingException, NotValueConverterException, ValueConverterNotFoundException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, CollectionEntityGenericReturnTypeException {
        if (entity == null) {
            return;
        }
        Object entityData = entity;
        if (entityData != null) {
            this.dtoWrite.write(dto, this.getConverter(converters).convertToDto(entityData, dtoBeanFactory));
        } else {
            this.dtoWrite.write(dto, NULL);
        }
    }

    @Override
    public void writeFromDtoToEntity(Object entity, Object dto, Map<String, Object> converters, BeanFactory entityBeanFactory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, AnnotationMissingBeanKeyException, AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, CollectionEntityGenericReturnTypeException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        if (this.meta.isReadOnly()) {
            return;
        }
        Object dtoData = this.dtoRead.read(dto);
        this.getConverter(converters).convertToEntity(dtoData, entity, entityBeanFactory);
    }

    private ValueConverter getConverter(Map<String, Object> converters) throws NotValueConverterException, ValueConverterNotFoundException {
        if (converters != null && !converters.isEmpty() && converters.containsKey(this.meta.getConverterKey())) {
            Object conv = converters.get(this.meta.getConverterKey());
            if (conv instanceof ValueConverter) {
                return (ValueConverter)conv;
            }
            throw new NotValueConverterException(this.meta.getDtoFieldName(), this.meta.getEntityFieldName(), this.meta.getConverterKey());
        }
        throw new ValueConverterNotFoundException(this.meta.getDtoFieldName(), this.meta.getEntityFieldName(), this.meta.getConverterKey());
    }
}

