/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.adapter.DtoToEntityMatcher;
import com.inspiresoftware.lib.dto.geda.assembler.Assembler;
import com.inspiresoftware.lib.dto.geda.assembler.AssemblerContext;
import com.inspiresoftware.lib.dto.geda.assembler.Pipe;
import com.inspiresoftware.lib.dto.geda.assembler.PipeValidator;
import com.inspiresoftware.lib.dto.geda.assembler.PropertyInspector;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.meta.MapPipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationDuplicateBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBeanKeyException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationValidatingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.CollectionEntityGenericReturnTypeException;
import com.inspiresoftware.lib.dto.geda.exception.DtoToEntityMatcherNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.EntityRetrieverNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidDtoInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidEntityInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionScanningException;
import com.inspiresoftware.lib.dto.geda.exception.NotDtoToEntityMatcherException;
import com.inspiresoftware.lib.dto.geda.exception.NotEntityRetrieverException;
import com.inspiresoftware.lib.dto.geda.exception.NotValueConverterException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.ValueConverterNotFoundException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapPipe
implements Pipe {
    private final MapPipeMetadata meta;
    private final AssemblerContext context;
    private final DataReader dtoRead;
    private final DataWriter dtoWrite;
    private final DataReader entityRead;
    private final DataWriter entityWrite;

    MapPipe(AssemblerContext context, DataReader dtoRead, DataWriter dtoWrite, DataReader entityRead, DataWriter entityWrite, MapPipeMetadata meta) throws AnnotationValidatingBindingException {
        this.meta = meta;
        this.context = context;
        this.dtoWrite = dtoWrite;
        this.entityRead = entityRead;
        if (this.meta.isReadOnly()) {
            this.dtoRead = null;
            this.entityWrite = null;
            PipeValidator.validateReadPipeTypes(context.getDslRegistry(), this.dtoWrite, this.meta.getDtoFieldName(), this.entityRead, this.meta.getEntityFieldName());
        } else {
            this.dtoRead = dtoRead;
            this.entityWrite = entityWrite;
            PipeValidator.validatePipeTypes(context.getDslRegistry(), this.dtoRead, this.dtoWrite, this.meta.getDtoFieldName(), this.entityRead, this.entityWrite, this.meta.getEntityFieldName());
        }
    }

    @Override
    public String getBinding() {
        return this.meta.getEntityFieldName();
    }

    @Override
    public void writeFromEntityToDto(Object entity, Object dto, Map<String, Object> converters, BeanFactory dtoBeanFactory) throws UnableToCreateInstanceException, BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, CollectionEntityGenericReturnTypeException, AnnotationMissingException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, NotValueConverterException, ValueConverterNotFoundException {
        Object entityCollection = this.entityRead.read(entity);
        if (entityCollection instanceof Collection) {
            Collection entities = (Collection)entityCollection;
            Map dtos = this.meta.newDtoMap(dtoBeanFactory);
            Class<?> entityRepresentative = this.meta.getReturnType(dtoBeanFactory);
            Object newDto = this.meta.newDtoBean(dtoBeanFactory);
            try {
                Assembler assembler = null;
                DataReader keyRead = null;
                for (Object object : entities) {
                    assembler = this.lazyCreateAssembler(assembler, newDto, object, dtoBeanFactory);
                    keyRead = this.lazyCollectionKeyRead(keyRead, newDto, object, dtoBeanFactory);
                    Object key = keyRead.read(object);
                    assembler.assembleDto(newDto, object, converters, dtoBeanFactory);
                    dtos.put(key, newDto);
                    newDto = this.meta.newDtoBean(dtoBeanFactory);
                }
                this.dtoWrite.write(dto, dtos);
            }
            catch (InspectionInvalidDtoInstanceException invDto) {
                throw new CollectionEntityGenericReturnTypeException(newDto.getClass().getCanonicalName(), this.meta.getDtoFieldName(), entityRepresentative != null ? entityRepresentative.getCanonicalName() : "unspecified");
            }
            catch (InspectionInvalidEntityInstanceException invEntity) {
                throw new CollectionEntityGenericReturnTypeException(newDto.getClass().getCanonicalName(), this.meta.getDtoFieldName(), entityRepresentative != null ? entityRepresentative.getCanonicalName() : "unspecified");
            }
        }
        if (entityCollection instanceof Map) {
            Map entities = (Map)entityCollection;
            Map dtos = this.meta.newDtoMap(dtoBeanFactory);
            Class<?> entityRepresentative = this.meta.getReturnType(dtoBeanFactory);
            Object newDto = this.meta.newDtoBean(dtoBeanFactory);
            boolean useKey = this.meta.isEntityMapKey();
            try {
                Assembler assembler = null;
                for (Map.Entry entry : entities.entrySet()) {
                    if (useKey) {
                        Object value = entry.getValue();
                        assembler = this.lazyCreateAssembler(assembler, newDto, entry.getKey(), dtoBeanFactory);
                        assembler.assembleDto(newDto, entry.getKey(), converters, dtoBeanFactory);
                        dtos.put(newDto, value);
                    } else {
                        Object object = entry.getValue();
                        assembler = this.lazyCreateAssembler(assembler, newDto, object, dtoBeanFactory);
                        assembler.assembleDto(newDto, object, converters, dtoBeanFactory);
                        dtos.put(entry.getKey(), newDto);
                    }
                    newDto = this.meta.newDtoBean(dtoBeanFactory);
                }
                this.dtoWrite.write(dto, dtos);
            }
            catch (InspectionInvalidDtoInstanceException invDto) {
                throw new CollectionEntityGenericReturnTypeException(newDto.getClass().getCanonicalName(), this.meta.getDtoFieldName(), entityRepresentative != null ? entityRepresentative.getCanonicalName() : "unspecified");
            }
            catch (InspectionInvalidEntityInstanceException invEntity) {
                throw new CollectionEntityGenericReturnTypeException(newDto.getClass().getCanonicalName(), this.meta.getDtoFieldName(), entityRepresentative != null ? entityRepresentative.getCanonicalName() : "unspecified");
            }
        }
    }

    @Override
    public void writeFromDtoToEntity(Object entityObj, Object dto, Map<String, Object> converters, BeanFactory entityBeanFactory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, UnableToCreateInstanceException, CollectionEntityGenericReturnTypeException, AnnotationMissingException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, AnnotationMissingBeanKeyException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        if (this.meta.isReadOnly()) {
            return;
        }
        Object dtoColl = this.dtoRead.read(dto);
        if (dtoColl instanceof Map) {
            Object entity = entityObj;
            Object originalEntityColl = this.entityRead.read(entity);
            Object original = null;
            if (originalEntityColl instanceof Collection || originalEntityColl instanceof Map) {
                original = originalEntityColl;
            } else {
                original = this.meta.newEntityMapOrCollection(entityBeanFactory);
                this.entityWrite.write(entity, original);
            }
            Map dtos = (Map)dtoColl;
            if (original instanceof Collection) {
                this.removeDeletedItems(converters, entityBeanFactory, (Collection)original, dtos);
                this.addOrUpdateItems(dto, converters, entityBeanFactory, (Collection)original, dtos);
            } else if (original instanceof Map) {
                this.removeDeletedItems(converters, entityBeanFactory, (Map)original, dtos);
                this.addOrUpdateItems(dto, converters, entityBeanFactory, (Map)original, dtos);
            }
        } else if (entityObj != null) {
            Object originalEntityColl = this.entityRead.read(entityObj);
            if (originalEntityColl instanceof Collection) {
                ((Collection)originalEntityColl).clear();
            } else if (originalEntityColl instanceof Map) {
                ((Map)originalEntityColl).clear();
            }
        }
    }

    private DataReader lazyCollectionKeyRead(DataReader reader, Object dtoItem, Object entityItem, BeanFactory beanFactory) {
        if (reader == null) {
            if (this.meta.getMapKeyForCollection() != null && this.meta.getMapKeyForCollection().length() > 0) {
                Class<?> representative = this.meta.getReturnType(beanFactory);
                if (Object.class.equals(representative) && entityItem != null) {
                    representative = entityItem.getClass();
                }
                PropertyDescriptor[] itemDesc = PropertyInspector.getPropertyDescriptorsForClass(representative);
                PropertyDescriptor itemKeyDesc = PropertyInspector.getEntityPropertyDescriptorForField(dtoItem.getClass(), representative, this.meta.getDtoFieldName(), this.meta.getMapKeyForCollection(), itemDesc);
                reader = this.context.getMethodSynthesizer().synthesizeReader(itemKeyDesc);
            } else {
                throw new AnnotationValidatingBindingException(this.meta.getDtoFieldName(), this.dtoWrite.getClass().getCanonicalName(), this.dtoWrite.getParameterType().getSimpleName(), this.meta.getEntityFieldName(), "", "", false);
            }
        }
        return reader;
    }

    private Assembler lazyCreateAssembler(Assembler assembler, Object dtoItem, Object entityItem, BeanFactory beanFactory) throws CollectionEntityGenericReturnTypeException, AnnotationMissingException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        if (assembler == null) {
            Class<?> representative = this.meta.getReturnType(beanFactory);
            if (Object.class.equals(representative) && entityItem != null) {
                representative = entityItem.getClass();
            }
            try {
                if (Object.class.equals(representative)) {
                    throw new CollectionEntityGenericReturnTypeException(dtoItem.getClass().getCanonicalName(), this.meta.getDtoFieldName(), representative.getCanonicalName());
                }
                return this.context.newAssembler(dtoItem.getClass(), representative);
            }
            catch (InspectionInvalidDtoInstanceException invDto) {
                throw new CollectionEntityGenericReturnTypeException(dtoItem.getClass().getCanonicalName(), this.meta.getDtoFieldName(), representative != null ? representative.getCanonicalName() : "unspecified");
            }
            catch (InspectionInvalidEntityInstanceException invEntity) {
                throw new CollectionEntityGenericReturnTypeException(dtoItem.getClass().getCanonicalName(), this.meta.getDtoFieldName(), representative != null ? representative.getCanonicalName() : "unspecified");
            }
        }
        return assembler;
    }

    private void addOrUpdateItems(Object dto, Map<String, Object> converters, BeanFactory entityBeanFactory, Collection original, Map dtos) throws CollectionEntityGenericReturnTypeException, AnnotationMissingException, BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, AnnotationMissingBeanKeyException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        Assembler assembler = null;
        DtoToEntityMatcher matcher = this.meta.getDtoToEntityMatcher(converters);
        for (Object dtoKey : dtos.keySet()) {
            Object dtoItem = dtos.get(dtoKey);
            boolean toAdd = true;
            for (Object orItem : original) {
                if (!matcher.match(dtoKey, orItem)) continue;
                assembler = this.lazyCreateAssembler(assembler, dtoItem, orItem, entityBeanFactory);
                assembler.assembleEntity(dtoItem, orItem, converters, entityBeanFactory);
                toAdd = false;
                break;
            }
            if (!toAdd) continue;
            Object newItem = this.meta.newEntityBean(entityBeanFactory);
            assembler = this.lazyCreateAssembler(assembler, dtoItem, newItem, entityBeanFactory);
            assembler.assembleEntity(dtoItem, newItem, converters, entityBeanFactory);
            original.add(newItem);
        }
    }

    private void addOrUpdateItems(Object dto, Map<String, Object> converters, BeanFactory entityBeanFactory, Map original, Map dtos) throws CollectionEntityGenericReturnTypeException, AnnotationMissingException, BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, AnnotationMissingBeanKeyException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        Assembler assembler = null;
        DtoToEntityMatcher matcher = this.meta.getDtoToEntityMatcher(converters);
        boolean useKey = this.meta.isEntityMapKey();
        for (Object dtoKey : dtos.keySet()) {
            Object newItem;
            Object dtoItem = dtos.get(dtoKey);
            boolean toAdd = true;
            for (Map.Entry orEntry : original.entrySet()) {
                if (!matcher.match(dtoKey, orEntry.getKey())) continue;
                if (useKey) {
                    assembler = this.lazyCreateAssembler(assembler, dtoKey, orEntry.getKey(), entityBeanFactory);
                    assembler.assembleEntity(dtoKey, orEntry.getKey(), converters, entityBeanFactory);
                    original.put(orEntry.getKey(), dtoItem);
                } else {
                    Object orItem = orEntry.getValue();
                    assembler = this.lazyCreateAssembler(assembler, dtoItem, orItem, entityBeanFactory);
                    assembler.assembleEntity(dtoItem, orItem, converters, entityBeanFactory);
                }
                toAdd = false;
                break;
            }
            if (!toAdd) continue;
            if (useKey) {
                newItem = this.meta.newEntityBean(entityBeanFactory);
                assembler = this.lazyCreateAssembler(assembler, dtoKey, newItem, entityBeanFactory);
                assembler.assembleEntity(dtoKey, newItem, converters, entityBeanFactory);
                original.put(newItem, dtoItem);
                continue;
            }
            newItem = this.meta.newEntityBean(entityBeanFactory);
            assembler = this.lazyCreateAssembler(assembler, dtoItem, newItem, entityBeanFactory);
            assembler.assembleEntity(dtoItem, newItem, converters, entityBeanFactory);
            original.put(dtoKey, newItem);
        }
    }

    private void removeDeletedItems(Map<String, Object> converters, BeanFactory entityBeanFactory, Collection original, Map dtos) throws DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        DtoToEntityMatcher matcher = this.meta.getDtoToEntityMatcher(converters);
        Iterator orIt = original.iterator();
        while (orIt.hasNext()) {
            Object orItem = orIt.next();
            boolean isRemoved = true;
            for (Object dtoKey : dtos.keySet()) {
                if (!matcher.match(dtoKey, orItem)) continue;
                isRemoved = false;
                break;
            }
            if (!isRemoved) continue;
            orIt.remove();
        }
    }

    private void removeDeletedItems(Map<String, Object> converters, BeanFactory entityBeanFactory, Map original, Map dtos) throws DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        DtoToEntityMatcher matcher = this.meta.getDtoToEntityMatcher(converters);
        ArrayList keysToRemove = new ArrayList();
        for (Object orKey : original.keySet()) {
            boolean isRemoved = true;
            for (Object dtoKey : dtos.keySet()) {
                if (!matcher.match(dtoKey, orKey)) continue;
                isRemoved = false;
                break;
            }
            if (!isRemoved) continue;
            keysToRemove.add(orKey);
        }
        for (Object orKey : keysToRemove) {
            original.remove(orKey);
        }
    }
}

