/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.adapter.DtoToEntityMatcher;
import com.inspiresoftware.lib.dto.geda.assembler.BasePipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToLocateRepresentationException;
import com.inspiresoftware.lib.dto.geda.exception.DtoToEntityMatcherNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.NotDtoToEntityMatcherException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPipeMetadata
extends BasePipeMetadata
implements com.inspiresoftware.lib.dto.geda.assembler.meta.MapPipeMetadata {
    private static final Map<Class, DtoToEntityMatcher> CACHE = new HashMap<Class, DtoToEntityMatcher>();
    private final Class<? extends Collection> dtoMapClass;
    private final String dtoMapClassKey;
    private final Class<?> entityMapOrCollectionClass;
    private final String entityMapOrCollectionClassKey;
    private final Class<?> returnType;
    private final String returnTypeKey;
    private final String mapKeyForCollection;
    private final boolean entityMapKey;
    private final DtoToEntityMatcher dtoToEntityMatcher;
    private final String dtoToEntityMatcherKey;

    public MapPipeMetadata(String dtoFieldName, String entityFieldName, String dtoBeanKey, String entityBeanKey, boolean readOnly, Class<? extends Collection> dtoMapClass, String dtoMapClassKey, Class<?> entityMapOrCollectionClass, String entityMapOrCollectionClassKey, Class<?> returnType, String returnTypeKey, String mapKeyForCollection, boolean entityMapKey, Class<? extends DtoToEntityMatcher> dtoToEntityMatcherClass, String dtoToEntityMatcherKey) throws UnableToCreateInstanceException {
        super(dtoFieldName, entityFieldName, dtoBeanKey, entityBeanKey, readOnly);
        this.dtoMapClass = dtoMapClass;
        this.returnTypeKey = returnTypeKey != null && returnTypeKey.length() > 0 ? returnTypeKey : null;
        this.dtoMapClassKey = dtoMapClassKey != null && dtoMapClassKey.length() > 0 ? dtoMapClassKey : null;
        this.entityMapOrCollectionClass = entityMapOrCollectionClass;
        this.entityMapOrCollectionClassKey = entityMapOrCollectionClassKey != null && entityMapOrCollectionClassKey.length() > 0 ? entityMapOrCollectionClassKey : null;
        this.returnType = returnType;
        this.mapKeyForCollection = mapKeyForCollection;
        this.entityMapKey = entityMapKey;
        if (dtoToEntityMatcherKey == null || dtoToEntityMatcherKey.length() == 0) {
            if (CACHE.containsKey(dtoToEntityMatcherClass)) {
                this.dtoToEntityMatcher = CACHE.get(dtoToEntityMatcherClass);
            } else {
                this.dtoToEntityMatcher = this.newBeanForClass(dtoToEntityMatcherClass, "Unable to create matcher: {0} for: {1} - {2}", dtoToEntityMatcherClass, this.getDtoBeanKey(), this.getEntityBeanKey());
                CACHE.put(dtoToEntityMatcherClass, this.dtoToEntityMatcher);
            }
            this.dtoToEntityMatcherKey = null;
        } else {
            this.dtoToEntityMatcher = null;
            this.dtoToEntityMatcherKey = dtoToEntityMatcherKey;
        }
    }

    @Override
    public Map newDtoMap(BeanFactory beanFactory) throws UnableToCreateInstanceException, BeanFactoryNotFoundException {
        if (this.dtoMapClassKey != null) {
            return (Map)this.newCollection(this.dtoMapClassKey, beanFactory, true);
        }
        return (Map)this.newCollection(this.dtoMapClass, " Dto field: ", this.getDtoFieldName());
    }

    @Override
    public Object newEntityMapOrCollection(BeanFactory beanFactory) throws UnableToCreateInstanceException, BeanFactoryNotFoundException {
        if (this.entityMapOrCollectionClassKey != null) {
            return this.newCollection(this.entityMapOrCollectionClassKey, beanFactory, false);
        }
        return this.newCollection(this.entityMapOrCollectionClass, " Entity field: ", this.getEntityFieldName());
    }

    @Override
    public Class<?> getReturnType(BeanFactory beanFactory) throws BeanFactoryUnableToLocateRepresentationException, BeanFactoryNotFoundException {
        if (this.returnTypeKey == null) {
            return this.returnType;
        }
        return this.getRepresentation(this.returnTypeKey, beanFactory, false);
    }

    @Override
    public String getMapKeyForCollection() {
        return this.mapKeyForCollection;
    }

    @Override
    public boolean isEntityMapKey() {
        return this.entityMapKey;
    }

    @Override
    public DtoToEntityMatcher getDtoToEntityMatcher(Map<String, Object> converters) throws DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        if (this.dtoToEntityMatcherKey == null) {
            return this.dtoToEntityMatcher;
        }
        if (converters == null) {
            throw new DtoToEntityMatcherNotFoundException(this.getDtoFieldName(), this.getEntityFieldName(), this.dtoToEntityMatcherKey);
        }
        Object matcher = converters.get(this.dtoToEntityMatcherKey);
        if (matcher == null) {
            throw new DtoToEntityMatcherNotFoundException(this.getDtoFieldName(), this.getEntityFieldName(), this.dtoToEntityMatcherKey);
        }
        if (matcher instanceof DtoToEntityMatcher) {
            return (DtoToEntityMatcher)matcher;
        }
        throw new NotDtoToEntityMatcherException(this.getDtoFieldName(), this.getEntityFieldName(), this.dtoToEntityMatcherKey);
    }

    private <T> T newCollection(String clazzKey, BeanFactory beanFactory, boolean isDto) throws UnableToCreateInstanceException, BeanFactoryNotFoundException {
        if (beanFactory == null) {
            throw new BeanFactoryNotFoundException(this.getDtoFieldName(), clazzKey, isDto);
        }
        Object coll = beanFactory.get(clazzKey);
        if (coll instanceof Collection || coll instanceof Map) {
            return (T)coll;
        }
        throw new UnableToCreateInstanceException(clazzKey, (isDto ? " Map Dto" : " Collection/Map Entity") + " field: " + this.getDtoFieldName() + "@key:" + clazzKey + " (Check if beanFactory [" + beanFactory + "] returns a correct instance)", null);
    }

    private <T> T newCollection(Class<?> clazz, String type, String field) throws UnableToCreateInstanceException {
        return (T)this.newBeanForClass(clazz, "Unable to create collection: {0} for {1} {2}", clazz, type, field);
    }

    private <T> T newBeanForClass(Class<T> clazz, String errMsg, Object ... msgParams) throws UnableToCreateInstanceException {
        try {
            return clazz.newInstance();
        }
        catch (Exception iex) {
            throw new UnableToCreateInstanceException(clazz.getCanonicalName(), String.format(errMsg, msgParams), iex);
        }
    }
}

