/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.assembler.CollectionPipeMetadata;
import com.inspiresoftware.lib.dto.geda.assembler.FieldPipeMetadata;
import com.inspiresoftware.lib.dto.geda.assembler.MapPipeMetadata;
import com.inspiresoftware.lib.dto.geda.assembler.MetadataChainBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.annotations.AnnotationProxy;
import com.inspiresoftware.lib.dto.geda.assembler.annotations.impl.AnnotationProxies;
import com.inspiresoftware.lib.dto.geda.assembler.meta.PipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataChainAnnotationBuilder
implements MetadataChainBuilder {
    MetadataChainAnnotationBuilder() {
    }

    @Override
    public List<PipeMetadata> build(Field dtoField) throws UnableToCreateInstanceException {
        Map<String, AnnotationProxy> dtoFieldAnn = AnnotationProxies.getFieldAnnotationProxy(dtoField);
        if (dtoFieldAnn.isEmpty()) {
            return null;
        }
        if (dtoFieldAnn.containsKey("DtoField")) {
            return this.buildFieldChain(dtoField, dtoFieldAnn.get("DtoField"), dtoFieldAnn.get("DtoParent"));
        }
        if (dtoFieldAnn.containsKey("DtoVirtualField")) {
            return this.buildVirtualFieldChain(dtoField, dtoFieldAnn.get("DtoVirtualField"));
        }
        if (dtoFieldAnn.containsKey("DtoCollection")) {
            return this.buildCollectionChain(dtoField, dtoFieldAnn.get("DtoCollection"));
        }
        if (dtoFieldAnn.containsKey("DtoMap")) {
            return this.buildMapChain(dtoField, dtoFieldAnn.get("DtoMap"));
        }
        return null;
    }

    private List<PipeMetadata> buildVirtualFieldChain(Field dtoField, AnnotationProxy dtoFieldAnn) {
        String[] bindings = new String[]{"#this#" + dtoField.getName()};
        ArrayList<PipeMetadata> metas = new ArrayList<PipeMetadata>(bindings.length);
        for (int index = 0; index < bindings.length; ++index) {
            metas.add(new FieldPipeMetadata(dtoField.getName(), bindings[index], (String)dtoFieldAnn.getValue("dtoBeanKey"), this.getStringFromArray((String[])dtoFieldAnn.getValue("entityBeanKeys"), index), (Boolean)dtoFieldAnn.getValue("readOnly"), (String)dtoFieldAnn.getValue("converter"), false, null, null));
        }
        return metas;
    }

    private List<PipeMetadata> buildFieldChain(Field dtoField, AnnotationProxy dtoFieldAnn, AnnotationProxy dtoParentAnn) {
        String[] bindings = this.createFieldBindingChain(this.getBindingFromAnnotationOrFieldName((String)dtoFieldAnn.getValue("value"), dtoField.getName()));
        ArrayList<PipeMetadata> metas = new ArrayList<PipeMetadata>(bindings.length);
        for (int index = 0; index < bindings.length; ++index) {
            metas.add(new FieldPipeMetadata(dtoField.getName(), bindings[index], (String)dtoFieldAnn.getValue("dtoBeanKey"), this.getStringFromArray((String[])dtoFieldAnn.getValue("entityBeanKeys"), index), (Boolean)dtoFieldAnn.getValue("readOnly"), (String)dtoFieldAnn.getValue("converter"), dtoParentAnn != null, dtoParentAnn != null ? (String)dtoParentAnn.getValue("value") : null, dtoParentAnn != null ? (String)dtoParentAnn.getValue("retriever") : null));
        }
        return metas;
    }

    private List<PipeMetadata> buildCollectionChain(Field dtoField, AnnotationProxy dtoCollAnn) throws UnableToCreateInstanceException {
        String[] bindings = this.createFieldBindingChain(this.getBindingFromAnnotationOrFieldName((String)dtoCollAnn.getValue("value"), dtoField.getName()));
        ArrayList<PipeMetadata> metas = new ArrayList<PipeMetadata>(bindings.length);
        for (int index = 0; index < bindings.length; ++index) {
            metas.add(new CollectionPipeMetadata(dtoField.getName(), bindings[index], (String)dtoCollAnn.getValue("dtoBeanKey"), this.getStringFromArray((String[])dtoCollAnn.getValue("entityBeanKeys"), index), (Boolean)dtoCollAnn.getValue("readOnly"), (Class)dtoCollAnn.getValue("dtoCollectionClass"), (String)dtoCollAnn.getValue("dtoCollectionClassKey"), (Class)dtoCollAnn.getValue("entityCollectionClass"), (String)dtoCollAnn.getValue("entityCollectionClassKey"), (Class)dtoCollAnn.getValue("entityGenericType"), (String)dtoCollAnn.getValue("entityGenericTypeKey"), (Class)dtoCollAnn.getValue("dtoToEntityMatcher"), (String)dtoCollAnn.getValue("dtoToEntityMatcherKey")));
        }
        return metas;
    }

    private List<PipeMetadata> buildMapChain(Field dtoField, AnnotationProxy dtoMapAnn) throws UnableToCreateInstanceException {
        String[] bindings = this.createFieldBindingChain(this.getBindingFromAnnotationOrFieldName((String)dtoMapAnn.getValue("value"), dtoField.getName()));
        ArrayList<PipeMetadata> metas = new ArrayList<PipeMetadata>(bindings.length);
        for (int index = 0; index < bindings.length; ++index) {
            metas.add(new MapPipeMetadata(dtoField.getName(), bindings[index], (String)dtoMapAnn.getValue("dtoBeanKey"), this.getStringFromArray((String[])dtoMapAnn.getValue("entityBeanKeys"), index), (Boolean)dtoMapAnn.getValue("readOnly"), (Class)dtoMapAnn.getValue("dtoMapClass"), (String)dtoMapAnn.getValue("dtoMapClassKey"), (Class)dtoMapAnn.getValue("entityMapOrCollectionClass"), (String)dtoMapAnn.getValue("entityMapOrCollectionClassKey"), (Class)dtoMapAnn.getValue("entityGenericType"), (String)dtoMapAnn.getValue("entityGenericTypeKey"), (String)dtoMapAnn.getValue("entityCollectionMapKey"), (Boolean)dtoMapAnn.getValue("useEntityMapKey"), (Class)dtoMapAnn.getValue("dtoToEntityMatcher"), (String)dtoMapAnn.getValue("dtoToEntityMatcherKey")));
        }
        return metas;
    }

    private String getBindingFromAnnotationOrFieldName(String annotation, String fieldName) {
        if (annotation == null || annotation.length() == 0) {
            return fieldName;
        }
        return annotation;
    }

    private String[] createFieldBindingChain(String binding) {
        if (binding.indexOf(46) == -1) {
            return new String[]{binding};
        }
        return binding.split("\\.");
    }

    private String getStringFromArray(String[] array, int index) {
        if (array != null && index < array.length) {
            return array[index];
        }
        return "";
    }
}

