/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.assembler.CollectionPipeMetadata;
import com.inspiresoftware.lib.dto.geda.assembler.FieldPipeMetadata;
import com.inspiresoftware.lib.dto.geda.assembler.MapPipeMetadata;
import com.inspiresoftware.lib.dto.geda.assembler.MetadataChainBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.meta.PipeMetadata;
import com.inspiresoftware.lib.dto.geda.dsl.DtoCollectionContext;
import com.inspiresoftware.lib.dto.geda.dsl.DtoContext;
import com.inspiresoftware.lib.dto.geda.dsl.DtoEntityContext;
import com.inspiresoftware.lib.dto.geda.dsl.DtoFieldContext;
import com.inspiresoftware.lib.dto.geda.dsl.DtoMapContext;
import com.inspiresoftware.lib.dto.geda.dsl.Registry;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataChainDSLBuilder
implements MetadataChainBuilder {
    private final DtoEntityContext context;

    MetadataChainDSLBuilder(Registry registry, Class dtoClass, Class entityClass) {
        DtoContext ctx = registry.has(dtoClass);
        this.context = ctx != null ? ctx.has(entityClass) : null;
    }

    @Override
    public List<PipeMetadata> build(Field dtoField) throws UnableToCreateInstanceException {
        if (this.context == null) {
            return null;
        }
        Object fieldContext = this.context.has(dtoField.getName());
        if (fieldContext == null) {
            return null;
        }
        if (fieldContext instanceof DtoFieldContext) {
            DtoFieldContext field = (DtoFieldContext)fieldContext;
            if (field.getValueOfVirtual()) {
                return this.buildVirtualFieldChain(dtoField, field);
            }
            return this.buildFieldChain(dtoField, field);
        }
        if (fieldContext instanceof DtoCollectionContext) {
            return MetadataChainDSLBuilder.buildCollectionChain(dtoField, (DtoCollectionContext)fieldContext);
        }
        if (fieldContext instanceof DtoMapContext) {
            return MetadataChainDSLBuilder.buildMapChain(dtoField, (DtoMapContext)fieldContext);
        }
        return null;
    }

    private List<PipeMetadata> buildVirtualFieldChain(Field dtoField, DtoFieldContext dtoFieldContext) {
        String[] bindings = new String[]{"#this#" + dtoField.getName()};
        ArrayList<PipeMetadata> metas = new ArrayList<PipeMetadata>(bindings.length);
        for (int index = 0; index < bindings.length; ++index) {
            metas.add(new FieldPipeMetadata(dtoField.getName(), bindings[index], dtoFieldContext.getValueOfDtoBeanKey(), MetadataChainDSLBuilder.getStringFromArray(dtoFieldContext.getValueOfEntityBeanKeys(), index), dtoFieldContext.getValueOfReadOnly(), dtoFieldContext.getValueOfConverter(), false, null, null));
        }
        return metas;
    }

    private List<PipeMetadata> buildFieldChain(Field dtoField, DtoFieldContext dtoFieldContext) {
        String[] bindings = MetadataChainDSLBuilder.createFieldBindingChain(MetadataChainDSLBuilder.getBindingFromAnnotationOrFieldName(dtoFieldContext.getValueOfEntityField(), dtoField.getName()));
        ArrayList<PipeMetadata> metas = new ArrayList<PipeMetadata>(bindings.length);
        for (int index = 0; index < bindings.length; ++index) {
            metas.add(new FieldPipeMetadata(dtoField.getName(), bindings[index], dtoFieldContext.getValueOfDtoBeanKey(), MetadataChainDSLBuilder.getStringFromArray(dtoFieldContext.getValueOfEntityBeanKeys(), index), dtoFieldContext.getValueOfReadOnly(), dtoFieldContext.getValueOfConverter(), dtoFieldContext.getValueOfDtoParent(), dtoFieldContext.getValueOfDtoParent() ? dtoFieldContext.getValueOfDtoParentPrimaryKey() : null, dtoFieldContext.getValueOfDtoParent() ? dtoFieldContext.getValueOfDtoParentRetriever() : null));
        }
        return metas;
    }

    private static List<PipeMetadata> buildCollectionChain(Field dtoField, DtoCollectionContext dtoCollContext) throws UnableToCreateInstanceException {
        String[] bindings = MetadataChainDSLBuilder.createFieldBindingChain(MetadataChainDSLBuilder.getBindingFromAnnotationOrFieldName(dtoCollContext.getValueOfEntityField(), dtoField.getName()));
        ArrayList<PipeMetadata> metas = new ArrayList<PipeMetadata>(bindings.length);
        for (int index = 0; index < bindings.length; ++index) {
            metas.add(new CollectionPipeMetadata(dtoField.getName(), bindings[index], dtoCollContext.getValueOfDtoBeanKey(), MetadataChainDSLBuilder.getStringFromArray(dtoCollContext.getValueOfEntityBeanKeys(), index), dtoCollContext.getValueOfReadOnly(), dtoCollContext.getValueOfDtoCollectionClass(), dtoCollContext.getValueOfDtoCollectionClassKey(), dtoCollContext.getValueOfEntityCollectionClass(), dtoCollContext.getValueOfEntityCollectionClassKey(), dtoCollContext.getValueOfEntityGenericType(), dtoCollContext.getValueOfEntityGenericTypeKey(), dtoCollContext.getValueOfDtoToEntityMatcher(), dtoCollContext.getValueOfDtoToEntityMatcherKey()));
        }
        return metas;
    }

    private static List<PipeMetadata> buildMapChain(Field dtoField, DtoMapContext dtoMapContext) throws UnableToCreateInstanceException {
        String[] bindings = MetadataChainDSLBuilder.createFieldBindingChain(MetadataChainDSLBuilder.getBindingFromAnnotationOrFieldName(dtoMapContext.getValueOfEntityField(), dtoField.getName()));
        ArrayList<PipeMetadata> metas = new ArrayList<PipeMetadata>(bindings.length);
        for (int index = 0; index < bindings.length; ++index) {
            metas.add(new MapPipeMetadata(dtoField.getName(), bindings[index], dtoMapContext.getValueOfDtoBeanKey(), MetadataChainDSLBuilder.getStringFromArray(dtoMapContext.getValueOfEntityBeanKeys(), index), dtoMapContext.getValueOfReadOnly(), dtoMapContext.getValueOfDtoMapClass(), dtoMapContext.getValueOfDtoMapClassKey(), dtoMapContext.getValueOfEntityMapOrCollectionClass(), dtoMapContext.getValueOfEntityMapOrCollectionClassKey(), dtoMapContext.getValueOfEntityGenericType(), dtoMapContext.getValueOfEntityGenericTypeKey(), dtoMapContext.getValueOfEntityCollectionMapKey(), dtoMapContext.getValueOfUseEntityMapKey(), dtoMapContext.getValueOfDtoToEntityMatcher(), dtoMapContext.getValueOfDtoToEntityMatcherKey()));
        }
        return metas;
    }

    private static String getBindingFromAnnotationOrFieldName(String annotation, String fieldName) {
        if (annotation == null || annotation.length() == 0) {
            return fieldName;
        }
        return annotation;
    }

    private static String[] createFieldBindingChain(String binding) {
        if (binding.indexOf(46) == -1) {
            return new String[]{binding};
        }
        return binding.split("\\.");
    }

    private static String getStringFromArray(String[] array, int index) {
        if (array != null && index < array.length) {
            return array[index];
        }
        return "";
    }
}

