/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.exception.GeDAException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodSynthesizerProxy
implements MethodSynthesizer {
    private static final String DEFAULT = "javassist";
    private static final Logger LOG = LoggerFactory.getLogger(MethodSynthesizerProxy.class);
    private static final Map<String, String> FACTORY = new HashMap<String, String>();
    private final Lock lock = new ReentrantLock();
    private String synthesizerImpl = FACTORY.get("javassist");
    private MethodSynthesizer synthesizer;
    private final Reference<ClassLoader> clRef;

    public MethodSynthesizerProxy(ClassLoader classLoader) {
        this.clRef = new SoftReference<ClassLoader>(classLoader);
    }

    public MethodSynthesizerProxy(ClassLoader classLoader, Object value) throws UnableToCreateInstanceException {
        this(classLoader);
        if (value instanceof String) {
            String[] configs = ((String)value).split(";");
            String syn = configs[0];
            MethodSynthesizer synth = this.lazyGet(classLoader, syn);
            for (int i = 1; i < configs.length; ++i) {
                String config = configs[i];
                String name = config.substring(0, config.indexOf(61));
                String val = config.substring(name.length() + 1);
                try {
                    synth.configure(name, val);
                    continue;
                }
                catch (GeDAException geda) {
                    throw new UnableToCreateInstanceException(synth.getClass().getCanonicalName(), "Unable to configure with: " + value, geda);
                }
            }
        } else {
            this.lazyGet(classLoader, value);
        }
    }

    static Collection<String> getAvailableSynthesizers() {
        return FACTORY.keySet();
    }

    static String getDefaultImpl() {
        return FACTORY.get(DEFAULT);
    }

    MethodSynthesizer getSynthesizer() {
        return this.synthesizer;
    }

    private MethodSynthesizer lazyGet(ClassLoader classLoader, Object value) throws UnableToCreateInstanceException {
        if (this.synthesizer == null) {
            block13: {
                try {
                    this.lock.lock();
                    if (this.synthesizer != null) break block13;
                    if (value == null) {
                        Class<?> clazz = Class.forName(this.synthesizerImpl);
                        this.synthesizer = (MethodSynthesizer)clazz.getConstructor(ClassLoader.class).newInstance(classLoader);
                        break block13;
                    }
                    if (value instanceof MethodSynthesizer) {
                        this.synthesizer = (MethodSynthesizer)value;
                        this.synthesizerImpl = value.getClass().getCanonicalName();
                        break block13;
                    }
                    if (value instanceof String) {
                        String newImpl = FACTORY.get(value);
                        this.synthesizerImpl = newImpl != null ? newImpl : value.toString();
                        Class<?> clazz = Class.forName(this.synthesizerImpl);
                        this.synthesizer = (MethodSynthesizer)clazz.getConstructor(ClassLoader.class).newInstance(classLoader);
                        break block13;
                    }
                    throw new UnableToCreateInstanceException("MethodSynthesizer", "Unable to create [" + value + "] implementation: " + "configuration not recognizer (Must be either: " + "MethodSynthesizer instance, or full class name as string, " + "or one of the following markers: " + new ArrayList<String>(FACTORY.keySet()).toString() + ")", null);
                }
                catch (UnableToCreateInstanceException rethrow) {
                    throw rethrow;
                }
                catch (Exception exp) {
                    throw new UnableToCreateInstanceException("MethodSynthesizer", "Unable to create [" + this.synthesizerImpl + "] implementation: " + exp.getMessage(), exp);
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.clRef != null) {
                this.clRef.clear();
            }
        } else if (value != null) {
            LOG.warn("Synthesizer is already set to: {}, configuration [{}] ignored", (Object)this.synthesizer.getClass().getCanonicalName(), value);
        }
        return this.synthesizer;
    }

    @Override
    public DataReader synthesizeReader(PropertyDescriptor descriptor) throws InspectionPropertyNotFoundException, UnableToCreateInstanceException, GeDARuntimeException {
        MethodSynthesizer syn = this.lazyGet(this.clRef.get(), null);
        return syn.synthesizeReader(descriptor);
    }

    @Override
    public DataWriter synthesizeWriter(PropertyDescriptor descriptor) throws InspectionPropertyNotFoundException, UnableToCreateInstanceException, GeDARuntimeException {
        MethodSynthesizer syn = this.lazyGet(this.clRef.get(), null);
        return syn.synthesizeWriter(descriptor);
    }

    @Override
    public boolean configure(String configuration, Object value) throws GeDAException {
        if ("synthesizerImpl".equals(configuration)) {
            MethodSynthesizer syn = this.lazyGet(this.clRef.get(), value);
            return true;
        }
        MethodSynthesizer syn = this.lazyGet(this.clRef.get(), null);
        return syn.configure(configuration, value);
    }

    public String toString() {
        return this.synthesizerImpl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.synthesizer == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return o instanceof MethodSynthesizer && this.synthesizer.equals(o);
        }
        return this.synthesizer.equals(((MethodSynthesizerProxy)o).synthesizer);
    }

    public int hashCode() {
        return this.synthesizer != null ? this.synthesizer.hashCode() : super.hashCode();
    }

    @Override
    public void releaseResources() {
        if (this.synthesizer != null) {
            this.synthesizer.releaseResources();
        }
        this.clRef.clear();
    }

    static {
        FACTORY.put(DEFAULT, "com.inspiresoftware.lib.dto.geda.assembler.extension.impl.JavassistMethodSynthesizer");
        FACTORY.put("suntools", "com.inspiresoftware.lib.dto.geda.assembler.extension.impl.SunJavaToolsMethodSynthesizer");
        FACTORY.put("reflection", "com.inspiresoftware.lib.dto.geda.assembler.extension.impl.ReflectionMethodSynthesizer");
        FACTORY.put("bcel", "com.inspiresoftware.lib.dto.geda.assembler.extension.impl.BCELMethodSynthesizer");
    }
}

