/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.annotations.Dto;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.dsl.Registry;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationValidatingBindingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PipeValidator {
    private PipeValidator() {
    }

    static void validatePipeNonNull(DataReader dtoRead, DataWriter dtoWrite, String dtoField, DataReader entityRead, DataWriter entityWrite, String entityField) throws AnnotationMissingBindingException {
        PipeValidator.validateReadPipeNonNull(dtoWrite, dtoField, entityRead, entityField);
        PipeValidator.validateWritePipeNonNull(dtoRead, dtoField, entityWrite, entityField);
    }

    static void validateReadPipeNonNull(DataWriter dtoWrite, String dtoWriteField, DataReader entityRead, String entityReadField) throws AnnotationMissingBindingException {
        PipeValidator.validatePipeNonNull(entityRead, AnnotationMissingBindingException.MissingBindingType.ENTITY_READ, entityReadField);
        PipeValidator.validatePipeNonNull(dtoWrite, AnnotationMissingBindingException.MissingBindingType.DTO_WRITE, dtoWriteField);
    }

    static void validateWritePipeNonNull(DataReader dtoRead, String dtoReadField, DataWriter entityWrite, String entityWriteField) throws AnnotationMissingBindingException {
        PipeValidator.validatePipeNonNull(dtoRead, AnnotationMissingBindingException.MissingBindingType.DTO_READ, dtoReadField);
        PipeValidator.validatePipeNonNull(entityWrite, AnnotationMissingBindingException.MissingBindingType.ENTITY_WRITE, entityWriteField);
    }

    static void validatePipeNonNull(Object meth, AnnotationMissingBindingException.MissingBindingType type, String fieldName) throws AnnotationMissingBindingException {
        if (meth == null) {
            throw new AnnotationMissingBindingException(type, fieldName);
        }
    }

    static void validatePipeTypes(Registry registry, DataReader dtoRead, DataWriter dtoWrite, String dtoField, DataReader entityRead, DataWriter entityWrite, String entityField) throws AnnotationValidatingBindingException {
        PipeValidator.validateReadPipeTypes(registry, dtoWrite, dtoField, entityRead, entityField);
        PipeValidator.validateWritePipeTypes(registry, dtoRead, dtoField, entityWrite, entityField);
    }

    private static boolean sameDataType(Class<?> data1, Class<?> data2) {
        return data1.equals(data2) || data1.isPrimitive() && !data2.isPrimitive() && PipeValidator.samePrimitiveDataType(data2, data1) || !data1.isPrimitive() && data2.isPrimitive() && PipeValidator.samePrimitiveDataType(data1, data2);
    }

    private static boolean samePrimitiveDataType(Class<?> wrapper, Class<?> primitive) {
        try {
            return wrapper.getDeclaredField("TYPE").get(null).equals(primitive);
        }
        catch (Throwable thr) {
            return false;
        }
    }

    static void validateReadPipeTypes(Registry registry, DataWriter dtoWrite, String dtoField, DataReader entityRead, String entityField) throws AnnotationValidatingBindingException {
        Class<?> dtoWriteClass = dtoWrite.getParameterType();
        Class<?> entityReadClass = entityRead.getReturnType();
        if (!(dtoWriteClass.isInterface() || dtoWriteClass.getAnnotation(Dto.class) != null || registry != null && registry.has(dtoWriteClass) != null || entityReadClass.equals(Object.class) || dtoWriteClass.equals(Object.class) || PipeValidator.sameDataType(dtoWriteClass, entityReadClass))) {
            throw new AnnotationValidatingBindingException(dtoField, dtoWrite.getClass().getCanonicalName(), dtoWriteClass.getSimpleName(), entityField, entityRead.getClass().getCanonicalName(), entityReadClass.getSimpleName(), false);
        }
    }

    static void validateWritePipeTypes(Registry registry, DataReader dtoRead, String dtoField, DataWriter entityWrite, String entityField) throws AnnotationValidatingBindingException {
        Class<?> dtoReadClass = dtoRead.getReturnType();
        Class<?> entityWriteClass = entityWrite.getParameterType();
        if (!(dtoReadClass.isInterface() || dtoReadClass.getAnnotation(Dto.class) != null || registry != null && registry.has(dtoReadClass) != null || entityWriteClass.equals(Object.class) || dtoReadClass.equals(Object.class) || PipeValidator.sameDataType(dtoReadClass, entityWriteClass))) {
            throw new AnnotationValidatingBindingException(dtoField, dtoRead.getClass().getCanonicalName(), dtoReadClass.getSimpleName(), entityField, entityWrite.getClass().getCanonicalName(), entityWriteClass.getSimpleName(), true);
        }
    }
}

