/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionScanningException;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyInspector {
    private PropertyInspector() {
    }

    public static PropertyDescriptor[] getPropertyDescriptorsForClassReturnedByGet(PropertyDescriptor descriptor) throws InspectionScanningException {
        Method entityFieldRead = descriptor.getReadMethod();
        Class returnType = PropertyInspector.getClassForType(entityFieldRead.getGenericReturnType());
        return PropertyInspector.getPropertyDescriptorsForClass(returnType);
    }

    public static PropertyDescriptor[] getPropertyDescriptorsForClass(Class clazz) throws InspectionScanningException {
        try {
            Type[] extendedInterfaces;
            PropertyDescriptor[] basic = Introspector.getBeanInfo(clazz, 1).getPropertyDescriptors();
            if (clazz.isInterface() && (extendedInterfaces = clazz.getGenericInterfaces()) != null && extendedInterfaces.length > 0) {
                ArrayList<PropertyDescriptor> descs = new ArrayList<PropertyDescriptor>();
                for (Type extendedInterface : extendedInterfaces) {
                    if (extendedInterface instanceof Class) {
                        PropertyInspector.addToList(descs, PropertyInspector.getPropertyDescriptorsForClass((Class)extendedInterface));
                        continue;
                    }
                    if (!(extendedInterface instanceof ParameterizedType)) continue;
                    PropertyInspector.addToList(descs, PropertyInspector.getPropertyDescriptorsForClass((Class)((ParameterizedType)extendedInterface).getRawType()));
                }
                PropertyInspector.addToList(descs, basic);
                return descs.toArray(new PropertyDescriptor[descs.size()]);
            }
            return basic;
        }
        catch (IntrospectionException itex) {
            throw new InspectionScanningException(clazz.getCanonicalName(), itex);
        }
    }

    private static void addToList(List<PropertyDescriptor> list, PropertyDescriptor[] descs) {
        if (descs == null || descs.length == 0) {
            return;
        }
        list.addAll(Arrays.asList(descs));
    }

    public static PropertyDescriptor getEntityPropertyDescriptorForField(Class dtoClass, Class entityClass, String dtoFieldName, String binding, PropertyDescriptor[] entityPropertyDescriptors) throws InspectionBindingNotFoundException {
        FeatureDescriptor candidateRead = null;
        PropertyDescriptor candidateWrite = null;
        for (PropertyDescriptor current : entityPropertyDescriptors) {
            if (!current.getName().equals(binding)) continue;
            if (current.getReadMethod() != null && current.getWriteMethod() != null) {
                return current;
            }
            if (current.getReadMethod() != null) {
                candidateRead = current;
                continue;
            }
            if (current.getWriteMethod() == null) continue;
            candidateWrite = current;
        }
        if (candidateRead != null) {
            if (candidateWrite != null) {
                try {
                    return new PropertyDescriptor(candidateRead.getName(), ((PropertyDescriptor)candidateRead).getReadMethod(), candidateWrite.getWriteMethod());
                }
                catch (IntrospectionException iexp) {
                    throw new GeDARuntimeException("Unable to combine get and set for [" + entityClass + "#" + binding + "] from different interfaces into single property descriptor");
                }
            }
            return candidateRead;
        }
        throw new InspectionBindingNotFoundException(dtoClass.getCanonicalName(), dtoFieldName, entityClass.getCanonicalName(), binding);
    }

    public static PropertyDescriptor getDtoPropertyDescriptorForField(Class dtoClass, String dtoFieldName, PropertyDescriptor[] dtoPropertyDescriptors) throws InspectionPropertyNotFoundException {
        for (PropertyDescriptor current : dtoPropertyDescriptors) {
            if (!current.getName().equals(dtoFieldName)) continue;
            return current;
        }
        throw new InspectionPropertyNotFoundException(dtoClass.getCanonicalName(), dtoFieldName);
    }

    public static Class getClassForType(Type type) throws GeDARuntimeException {
        Type[] bounds;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return (Class)rawType;
            }
        } else if (type instanceof TypeVariable && (bounds = ((TypeVariable)type).getBounds()) != null && bounds.length > 0 && bounds[0] instanceof Class) {
            return (Class)bounds[0];
        }
        throw new GeDARuntimeException("Unable to determine correct class for type: " + type);
    }
}

