/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.annotations.impl;

import com.inspiresoftware.lib.dto.geda.assembler.annotations.AnnotationProxy;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionAnnotationProxy
implements AnnotationProxy {
    private final String annotationClass;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public ReflectionAnnotationProxy(Object annotation, String ... availableProperties) {
        this.annotationClass = annotation.getClass().getSimpleName();
        for (String property : availableProperties) {
            try {
                this.properties.put(property, annotation.getClass().getDeclaredMethod(property, new Class[0]).invoke(annotation, new Object[0]));
            }
            catch (Exception exp) {
                throw new GeDARuntimeException("Invalid @" + this.annotationClass + " annotation proxy access via property: " + property);
            }
        }
    }

    @Override
    public boolean annotationExists() {
        return true;
    }

    @Override
    public <T> T getValue(String property) {
        if (this.properties.containsKey(property)) {
            return (T)this.properties.get(property);
        }
        throw new GeDARuntimeException("Invalid @" + this.annotationClass + " annotation proxy access via property: " + property);
    }
}

