/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.dsl.impl;

import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.adapter.BeanFactoryProvider;
import com.inspiresoftware.lib.dto.geda.adapter.ExtensibleBeanFactory;
import com.inspiresoftware.lib.dto.geda.assembler.dsl.impl.DtoContextByClass;
import com.inspiresoftware.lib.dto.geda.dsl.DtoContext;
import com.inspiresoftware.lib.dto.geda.dsl.Registry;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToLocateRepresentationException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultDSLRegistry
implements Registry,
BeanFactory,
BeanFactoryProvider {
    private final ExtensibleBeanFactory beanFactory;
    private final Map<Integer, DtoContext> contexts = new ConcurrentHashMap<Integer, DtoContext>();

    @Deprecated
    public DefaultDSLRegistry() {
        this(null);
    }

    public DefaultDSLRegistry(ExtensibleBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public DtoContext has(Class dtoClass) {
        if (dtoClass == null) {
            throw new GeDARuntimeException("dtoClass must not be null");
        }
        int hash = dtoClass.hashCode();
        if (this.contexts.containsKey(hash)) {
            return this.contexts.get(hash);
        }
        return null;
    }

    public DtoContext dto(Class dtoClass) {
        if (dtoClass == null) {
            throw new GeDARuntimeException("dtoClass must not be null");
        }
        int hash = dtoClass.hashCode();
        if (this.contexts.containsKey(hash)) {
            return this.contexts.get(hash);
        }
        DtoContextByClass ctx = new DtoContextByClass(dtoClass, this.beanFactory);
        this.contexts.put(hash, ctx);
        return ctx;
    }

    public DtoContext dto(Object dtoInstance) {
        if (dtoInstance == null) {
            throw new GeDARuntimeException("dtoInstance must not be null");
        }
        return this.dto(dtoInstance.getClass());
    }

    public DtoContext dto(String beanKey) {
        if (this.beanFactory == null) {
            throw new GeDARuntimeException("Bean factory must be specified. Use constructor DefaultDSLRegistry(BeanFactory)");
        }
        Class representative = this.beanFactory.getClazz(beanKey);
        if (representative == null) {
            throw new BeanFactoryUnableToLocateRepresentationException(this.beanFactory.toString(), "top level", beanKey, true);
        }
        return this.dto(representative);
    }

    public Class getClazz(String entityBeanKey) {
        if (this.beanFactory == null) {
            throw new GeDARuntimeException("Bean factory must be specified. Use constructor DefaultDSLRegistry(BeanFactory)");
        }
        return this.beanFactory.getClazz(entityBeanKey);
    }

    public Object get(String entityBeanKey) {
        if (this.beanFactory == null) {
            throw new GeDARuntimeException("Bean factory must be specified. Use constructor DefaultDSLRegistry(BeanFactory)");
        }
        return this.beanFactory.get(entityBeanKey);
    }

    public BeanFactory getBeanFactory() {
        if (this.beanFactory == null) {
            throw new GeDARuntimeException("Bean factory must be specified. Use constructor DefaultDSLRegistry(BeanFactory)");
        }
        return this.beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources() {
        DefaultDSLRegistry defaultDSLRegistry = this;
        synchronized (defaultDSLRegistry) {
            this.contexts.clear();
            if (this.beanFactory != null) {
                this.beanFactory.releaseResources();
            }
        }
    }
}

