/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.dsl.impl;

import com.inspiresoftware.lib.dto.geda.adapter.ExtensibleBeanFactory;
import com.inspiresoftware.lib.dto.geda.assembler.dsl.impl.DtoEntityContextByClass;
import com.inspiresoftware.lib.dto.geda.dsl.DtoContext;
import com.inspiresoftware.lib.dto.geda.dsl.DtoEntityContext;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToLocateRepresentationException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DtoContextByClass
implements DtoContext {
    private final Class dtoClass;
    private final ExtensibleBeanFactory beanFactory;
    private final Map<Integer, DtoEntityContext> contexts = new ConcurrentHashMap<Integer, DtoEntityContext>();

    public DtoContextByClass(Class dtoClass, ExtensibleBeanFactory beanFactory) {
        this.dtoClass = dtoClass;
        this.beanFactory = beanFactory;
    }

    public Class getDtoClass() {
        return this.dtoClass;
    }

    public DtoContext alias(String beanKey) {
        if (this.beanFactory == null) {
            throw new GeDARuntimeException("Alias for " + beanKey + " cannot be registered. Bean factory must be specified. Use constructor DefaultDSLRegistry(BeanFactory)");
        }
        this.beanFactory.registerDto(beanKey, this.dtoClass.getCanonicalName());
        return this;
    }

    public DtoEntityContext forEntity(Class entityClass) {
        if (entityClass == null) {
            throw new GeDARuntimeException("entityClass must not be null");
        }
        int hash = entityClass.hashCode();
        if (this.contexts.containsKey(hash)) {
            return this.contexts.get(hash);
        }
        DtoEntityContextByClass ctx = new DtoEntityContextByClass(this.dtoClass, entityClass, this.beanFactory);
        this.contexts.put(hash, ctx);
        return ctx;
    }

    public DtoEntityContext forEntity(Object entityInstance) {
        if (entityInstance == null) {
            throw new GeDARuntimeException("entityInstance must not be null");
        }
        return this.forEntity(entityInstance.getClass());
    }

    public DtoEntityContext forEntity(String beanKey) {
        if (this.beanFactory == null) {
            throw new GeDARuntimeException("Bean factory must be specified. Use constructor DefaultDSLRegistry(BeanFactory)");
        }
        Class representative = this.beanFactory.getClazz(beanKey);
        if (representative == null) {
            throw new BeanFactoryUnableToLocateRepresentationException(this.beanFactory.toString(), "top level", beanKey, false);
        }
        return this.forEntity(representative);
    }

    public DtoEntityContext forEntityGeneric() {
        return this.forEntity(Object.class);
    }

    public DtoEntityContext has(Class entityClass) {
        if (entityClass == null) {
            throw new GeDARuntimeException("entityClass must not be null");
        }
        int hash = entityClass.hashCode();
        if (this.contexts.containsKey(hash)) {
            return this.contexts.get(hash);
        }
        for (Class<?> iFace : entityClass.getInterfaces()) {
            hash = iFace.hashCode();
            if (!this.contexts.containsKey(hash)) continue;
            return this.contexts.get(hash);
        }
        if (entityClass.getSuperclass() != null && this.contexts.containsKey(hash = entityClass.getSuperclass().hashCode())) {
            return this.contexts.get(hash);
        }
        hash = Object.class.hashCode();
        if (this.contexts.containsKey(hash)) {
            return this.contexts.get(hash);
        }
        return null;
    }

    public DtoEntityContext useContextFor(DtoEntityContext ctx, Class entityClass) {
        if (!this.contexts.containsValue(ctx)) {
            throw new IllegalArgumentException("This dto does not have a mapping for context with entity: " + ctx.getEntityClass());
        }
        int hash = entityClass.hashCode();
        this.contexts.put(hash, ctx);
        return ctx;
    }

    public DtoEntityContext useContextFor(DtoEntityContext ctx, String beanKey) {
        if (!this.contexts.containsValue(ctx)) {
            throw new IllegalArgumentException("This dto does not have a mapping for context with entity: " + ctx.getEntityClass());
        }
        if (this.beanFactory == null) {
            throw new GeDARuntimeException("Bean factory must be specified. Use constructor DefaultDSLRegistry(BeanFactory)");
        }
        Class representative = this.beanFactory.getClazz(beanKey);
        if (representative == null) {
            throw new BeanFactoryUnableToLocateRepresentationException(this.beanFactory.toString(), "top level", beanKey, false);
        }
        return this.useContextFor(ctx, representative);
    }
}

