/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.dsl.impl;

import com.inspiresoftware.lib.dto.geda.adapter.ExtensibleBeanFactory;
import com.inspiresoftware.lib.dto.geda.assembler.DSLUtils;
import com.inspiresoftware.lib.dto.geda.assembler.dsl.impl.DtoCollectionContextImpl;
import com.inspiresoftware.lib.dto.geda.assembler.dsl.impl.DtoFieldContextImpl;
import com.inspiresoftware.lib.dto.geda.assembler.dsl.impl.DtoMapContextImpl;
import com.inspiresoftware.lib.dto.geda.dsl.DtoCollectionContext;
import com.inspiresoftware.lib.dto.geda.dsl.DtoEntityContext;
import com.inspiresoftware.lib.dto.geda.dsl.DtoEntityContextAppender;
import com.inspiresoftware.lib.dto.geda.dsl.DtoFieldContext;
import com.inspiresoftware.lib.dto.geda.dsl.DtoMapContext;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationDuplicateBindingException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DtoEntityContextByClass
extends DSLUtils
implements DtoEntityContext {
    private final Class dtoClass;
    private final Class entityClass;
    private final ExtensibleBeanFactory beanFactory;
    private final DtoEntityContextAppender self = new DtoEntityContextAppender(){

        public DtoEntityContext and() {
            return DtoEntityContextByClass.this;
        }
    };
    private final Map<Integer, Object> fields = new ConcurrentHashMap<Integer, Object>();

    public DtoEntityContextByClass(Class dtoClass, Class entityClass, ExtensibleBeanFactory beanFactory) {
        this.dtoClass = dtoClass;
        this.entityClass = entityClass;
        this.beanFactory = beanFactory;
    }

    public Class getDtoClass() {
        return this.dtoClass;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public DtoEntityContext alias(String beanKey, Class representative) {
        if (this.beanFactory == null) {
            throw new GeDARuntimeException("Alias for " + beanKey + " cannot be registered. Bean factory must be specified. Use constructor DefaultDSLRegistry(BeanFactory)");
        }
        if (this.entityClass.isInterface()) {
            throw new GeDARuntimeException("No alias for " + beanKey + " as it is mapped to entity interface");
        }
        if (representative == null) {
            this.beanFactory.registerEntity(beanKey, this.entityClass.getCanonicalName(), this.entityClass.getCanonicalName());
        } else if (representative.isInterface() && representative.isAssignableFrom(this.entityClass)) {
            this.beanFactory.registerEntity(beanKey, this.entityClass.getCanonicalName(), representative.getCanonicalName());
        } else {
            throw new GeDARuntimeException("Alias for " + beanKey + " has invalid interface for given entity class");
        }
        return this;
    }

    public DtoFieldContext withField(String fieldName) {
        int hash = fieldName.hashCode();
        if (this.fields.containsKey(hash)) {
            Object field = this.fields.get(hash);
            if (field instanceof DtoFieldContext) {
                return (DtoFieldContext)field;
            }
            throw new AnnotationDuplicateBindingException(this.dtoClass.getCanonicalName(), fieldName);
        }
        DtoFieldContextImpl field = new DtoFieldContextImpl(this, fieldName);
        this.fields.put(hash, field);
        return field;
    }

    public DtoEntityContextAppender withFieldsSameAsIn(String beanKey, String ... excluding) {
        if (this.beanFactory == null) {
            throw new GeDARuntimeException("Bean for key " + beanKey + " cannot be looked up. Bean factory must be specified. Use constructor DefaultDSLRegistry(BeanFactory)");
        }
        Class clazz = this.beanFactory.getClazz(beanKey);
        if (clazz == null) {
            throw new GeDARuntimeException("Bean for key " + beanKey + " is not in the bean factory");
        }
        return this.withFieldsSameAsIn(clazz, excluding);
    }

    public DtoEntityContextAppender withFieldsSameAsIn(Class clazz, String ... excluding) {
        Map<String, String> dtoFields = this.scanFieldNamesOnClass(this.getDtoClass());
        if (excluding != null && excluding.length > 0) {
            for (String exclude : excluding) {
                dtoFields.remove(exclude);
            }
        }
        Map<String, String> entityFields = clazz.isInterface() ? this.scanGetterNamesOnClass(clazz) : this.scanFieldNamesOnClass(clazz);
        for (Map.Entry<String, String> dtoField : dtoFields.entrySet()) {
            String entityFieldType = entityFields.get(dtoField.getKey());
            if (entityFieldType == null || !entityFieldType.equals(dtoField.getValue())) continue;
            this.withField(dtoField.getKey());
        }
        return this.self;
    }

    public DtoCollectionContext withCollection(String fieldName) {
        int hash = fieldName.hashCode();
        if (this.fields.containsKey(hash)) {
            Object field = this.fields.get(hash);
            if (field instanceof DtoCollectionContext) {
                return (DtoCollectionContext)field;
            }
            throw new AnnotationDuplicateBindingException(this.dtoClass.getCanonicalName(), fieldName);
        }
        DtoCollectionContextImpl field = new DtoCollectionContextImpl(this, fieldName);
        this.fields.put(hash, field);
        return field;
    }

    public DtoMapContext withMap(String fieldName) {
        int hash = fieldName.hashCode();
        if (this.fields.containsKey(hash)) {
            Object field = this.fields.get(hash);
            if (field instanceof DtoMapContext) {
                return (DtoMapContext)field;
            }
            throw new AnnotationDuplicateBindingException(this.dtoClass.getCanonicalName(), fieldName);
        }
        DtoMapContextImpl field = new DtoMapContextImpl(this, fieldName);
        this.fields.put(hash, field);
        return field;
    }

    public Object has(String fieldName) {
        int hash = fieldName.hashCode();
        if (this.fields.containsKey(hash)) {
            return this.fields.get(hash);
        }
        return null;
    }
}

