/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.extension.impl;

import com.inspiresoftware.lib.dto.geda.assembler.SynthesizerUtils;
import com.inspiresoftware.lib.dto.geda.assembler.extension.Cache;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.SoftReferenceCache;
import com.inspiresoftware.lib.dto.geda.exception.GeDAException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodSynthesizer
extends SynthesizerUtils
implements MethodSynthesizer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMethodSynthesizer.class);
    private final Lock readLock = new ReentrantLock();
    private final Lock writeLock = new ReentrantLock();
    private static final int MAX_COMPILE_TRIES = 3;
    private Reference<ClassLoader> loader;
    private static final int PUBLIC = 1;
    private static final Cache<Object> READER_CACHE = new SoftReferenceCache<Object>();
    private static final Cache<Object> WRITER_CACHE = new SoftReferenceCache<Object>();
    protected static final Map<String, String> PRIMITIVE_TO_WRAPPER = new HashMap<String, String>();
    protected static final Map<String, Class<?>> PRIMITIVE_TO_WRAPPER_CLASS;
    protected static final Map<String, String> WRAPPER_TO_PRIMITIVE;

    public static Class<?> getValidDeclaringClass(Method method) {
        Class<?> decl = method.getDeclaringClass();
        if (decl.isAnonymousClass() || decl.getName().indexOf(36) == -1) {
            return decl;
        }
        Class<?> declS = decl.getSuperclass();
        if (declS.equals(Object.class)) {
            Class<?>[] declIs = decl.getInterfaces();
            for (int i = 0; i < declIs.length; ++i) {
                if (!AbstractMethodSynthesizer.declaringClassIsValid(declIs[i], method)) continue;
                return declIs[i];
            }
            throw new GeDARuntimeException("Unable to identify interface for proxy object");
        }
        if (AbstractMethodSynthesizer.declaringClassIsValid(declS, method)) {
            return declS;
        }
        Class<?>[] declIs = decl.getInterfaces();
        for (int i = 0; i < declIs.length; ++i) {
            if (!AbstractMethodSynthesizer.declaringClassIsValid(declIs[i], method)) continue;
            return declIs[i];
        }
        throw new GeDARuntimeException("Unable to identify interface for proxy object");
    }

    private static boolean declaringClassIsValid(Class<?> clazz, Method method) {
        try {
            clazz.getMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (Exception all) {
            return false;
        }
    }

    public AbstractMethodSynthesizer(ClassLoader classLoader) {
        this.loader = this.initialiseClassLoaderWeakReference(classLoader);
    }

    protected Reference<ClassLoader> initialiseClassLoaderWeakReference(ClassLoader classLoader) {
        return new SoftReference<ClassLoader>(classLoader);
    }

    protected final void enhanceClassLoader() {
        this.loader = this.initialiseClassLoaderWeakReference(this.getClassLoader());
    }

    @Override
    public boolean configure(String configuration, Object value) throws GeDAException {
        return false;
    }

    private boolean setCleanUpReaderCycle(Object cleanUpReaderCycle) throws GeDAException {
        return READER_CACHE.configure("cleanUpCycle", cleanUpReaderCycle);
    }

    private boolean setCleanUpWriterCycle(Object cleanUpWriterCycle) throws GeDAException {
        return WRITER_CACHE.configure("cleanUpCycle", cleanUpWriterCycle);
    }

    protected void preMakeReaderValidation(PropertyDescriptor descriptor) throws InspectionPropertyNotFoundException, GeDARuntimeException {
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) {
            throw new InspectionPropertyNotFoundException("No read method for: ", descriptor.getName());
        }
        Class<?> target = AbstractMethodSynthesizer.getValidDeclaringClass(readMethod);
        if ((target.getModifiers() & 1) == 0) {
            throw new GeDARuntimeException(target.getCanonicalName() + " does not have [public] modifier. This will cause IllegalAccessError during runtime.");
        }
    }

    protected final ReturnTypeContext getReturnTypeContext(String readerClassName, Type sourceClassGetterMethodReturnType) throws GeDARuntimeException {
        try {
            Class rcl = this.getClassForType(sourceClassGetterMethodReturnType);
            if (rcl.isPrimitive()) {
                return new ReturnTypeContext(rcl, PRIMITIVE_TO_WRAPPER.get(rcl.getCanonicalName()), rcl.getCanonicalName());
            }
            return new ReturnTypeContext(rcl, rcl.getCanonicalName(), null);
        }
        catch (GeDARuntimeException gre) {
            throw new GeDARuntimeException("Unable to determine correct return type from getter method in class: " + readerClassName, gre);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DataReader synthesizeReader(PropertyDescriptor descriptor) throws InspectionPropertyNotFoundException, UnableToCreateInstanceException, GeDARuntimeException {
        this.preMakeReaderValidation(descriptor);
        Method readMethod = descriptor.getReadMethod();
        String sourceClassNameFull = AbstractMethodSynthesizer.getValidDeclaringClass(readMethod).getCanonicalName();
        String sourceClassGetterMethodName = readMethod.getName();
        String readerClassName = this.generateClassName("DataReader", sourceClassNameFull, sourceClassGetterMethodName);
        DataReader reader = (DataReader)this.getFromCacheOrCreateFromClassLoader(readerClassName, READER_CACHE, this.getClassLoader());
        if (reader == null) {
            this.readLock.lock();
            MakeContext ctx = new MakeContext(DataReader.class.getCanonicalName());
            try {
                do {
                    if ((reader = this.makeReaderClass(this.getClassLoader(), readMethod, readerClassName, sourceClassNameFull, sourceClassGetterMethodName, readMethod.getGenericReturnType(), ctx)) == null) {
                        reader = (DataReader)this.getFromCacheOrCreateFromClassLoader(readerClassName, READER_CACHE, this.getClassLoader());
                        continue;
                    }
                    READER_CACHE.put(readerClassName.hashCode(), reader);
                } while (reader == null);
            }
            finally {
                this.readLock.unlock();
            }
        }
        return reader;
    }

    private <T> T getFromCacheOrCreateFromClassLoader(String className, Cache<Object> cache, ClassLoader classLoader) throws UnableToCreateInstanceException {
        Object instance = cache.get(className.hashCode());
        if (instance != null) {
            return (T)instance;
        }
        instance = this.createInstanceFromClassLoader(classLoader, className);
        if (instance != null) {
            return (T)instance;
        }
        return null;
    }

    protected abstract DataReader makeReaderClass(ClassLoader var1, Method var2, String var3, String var4, String var5, Type var6, MakeContext var7) throws UnableToCreateInstanceException, GeDARuntimeException;

    protected void preMakeWriterValidation(PropertyDescriptor descriptor) throws InspectionPropertyNotFoundException, GeDARuntimeException {
        Method writeMethod = descriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new InspectionPropertyNotFoundException("No write method for: ", descriptor.getName());
        }
        Class<?> target = AbstractMethodSynthesizer.getValidDeclaringClass(writeMethod);
        if ((target.getModifiers() & 1) == 0) {
            throw new GeDARuntimeException(target.getCanonicalName() + " does not have [public] modifier. This will cause IllegalAccessError during runtime.");
        }
    }

    protected final ArgumentTypeContext getArgumentTypeContext(Class<?> sourceClassSetterMethodArgumentClass) {
        if (sourceClassSetterMethodArgumentClass.isPrimitive()) {
            return new ArgumentTypeContext(sourceClassSetterMethodArgumentClass, PRIMITIVE_TO_WRAPPER.get(sourceClassSetterMethodArgumentClass.getCanonicalName()), sourceClassSetterMethodArgumentClass.getCanonicalName());
        }
        return new ArgumentTypeContext(sourceClassSetterMethodArgumentClass, sourceClassSetterMethodArgumentClass.getCanonicalName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DataWriter synthesizeWriter(PropertyDescriptor descriptor) throws InspectionPropertyNotFoundException, UnableToCreateInstanceException, GeDARuntimeException {
        this.preMakeWriterValidation(descriptor);
        Method writeMethod = descriptor.getWriteMethod();
        String classNameFull = AbstractMethodSynthesizer.getValidDeclaringClass(writeMethod).getCanonicalName();
        String methodName = writeMethod.getName();
        String writerClassName = this.generateClassName("DataWriter", classNameFull, methodName);
        DataWriter writer = (DataWriter)this.getFromCacheOrCreateFromClassLoader(writerClassName, WRITER_CACHE, this.getClassLoader());
        if (writer == null) {
            this.writeLock.lock();
            MakeContext ctx = new MakeContext(DataWriter.class.getCanonicalName());
            try {
                do {
                    if ((writer = this.makeWriterClass(this.getClassLoader(), writeMethod, writerClassName, classNameFull, methodName, writeMethod.getParameterTypes()[0], ctx)) == null) {
                        writer = (DataWriter)this.getFromCacheOrCreateFromClassLoader(writerClassName, WRITER_CACHE, this.getClassLoader());
                        continue;
                    }
                    WRITER_CACHE.put(writerClassName.hashCode(), writer);
                } while (writer == null);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return writer;
    }

    protected abstract DataWriter makeWriterClass(ClassLoader var1, Method var2, String var3, String var4, String var5, Class<?> var6, MakeContext var7) throws UnableToCreateInstanceException;

    protected ClassLoader getClassLoader() {
        ClassLoader cl = this.loader.get();
        if (cl == null) {
            throw new GeDARuntimeException("Class loader has been gc'ed");
        }
        return cl;
    }

    private <T> T createInstanceFromClassLoader(ClassLoader cl, String clazzName) throws UnableToCreateInstanceException {
        try {
            Class<?> clazz = Class.forName(clazzName, true, cl);
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (Throwable exp) {
            throw new UnableToCreateInstanceException(clazzName, "Unable to create instance of: " + clazzName, exp);
        }
    }

    private String generateClassName(String prefix, String declaringClass, String methodName) {
        return declaringClass + prefix + "M" + methodName + "ID" + this.getSynthesizerId();
    }

    protected abstract String getSynthesizerId();

    @Override
    public void releaseResources() {
        this.loader.clear();
    }

    static {
        PRIMITIVE_TO_WRAPPER.put("byte", Byte.class.getCanonicalName());
        PRIMITIVE_TO_WRAPPER.put("short", Short.class.getCanonicalName());
        PRIMITIVE_TO_WRAPPER.put("int", Integer.class.getCanonicalName());
        PRIMITIVE_TO_WRAPPER.put("long", Long.class.getCanonicalName());
        PRIMITIVE_TO_WRAPPER.put("float", Float.class.getCanonicalName());
        PRIMITIVE_TO_WRAPPER.put("double", Double.class.getCanonicalName());
        PRIMITIVE_TO_WRAPPER.put("boolean", Boolean.class.getCanonicalName());
        PRIMITIVE_TO_WRAPPER.put("char", Character.class.getCanonicalName());
        PRIMITIVE_TO_WRAPPER_CLASS = new HashMap();
        PRIMITIVE_TO_WRAPPER_CLASS.put("byte", Byte.class);
        PRIMITIVE_TO_WRAPPER_CLASS.put("short", Short.class);
        PRIMITIVE_TO_WRAPPER_CLASS.put("int", Integer.class);
        PRIMITIVE_TO_WRAPPER_CLASS.put("long", Long.class);
        PRIMITIVE_TO_WRAPPER_CLASS.put("float", Float.class);
        PRIMITIVE_TO_WRAPPER_CLASS.put("double", Double.class);
        PRIMITIVE_TO_WRAPPER_CLASS.put("boolean", Boolean.class);
        PRIMITIVE_TO_WRAPPER_CLASS.put("char", Character.class);
        WRAPPER_TO_PRIMITIVE = new HashMap<String, String>();
        WRAPPER_TO_PRIMITIVE.put("byte", ".byteValue()");
        WRAPPER_TO_PRIMITIVE.put("short", ".shortValue()");
        WRAPPER_TO_PRIMITIVE.put("int", ".intValue()");
        WRAPPER_TO_PRIMITIVE.put("long", ".longValue()");
        WRAPPER_TO_PRIMITIVE.put("float", ".floatValue()");
        WRAPPER_TO_PRIMITIVE.put("double", ".doubleValue()");
        WRAPPER_TO_PRIMITIVE.put("boolean", ".booleanValue()");
        WRAPPER_TO_PRIMITIVE.put("char", ".charValue()");
    }

    public static final class MakeContext {
        private int tryNo;
        private final String classType;

        public MakeContext(String classType) {
            this.classType = classType;
            this.tryNo = 0;
        }

        public void next(Exception exp, String source) throws UnableToCreateInstanceException {
            ++this.tryNo;
            if (this.tryNo > 3) {
                throw new UnableToCreateInstanceException(this.classType, "Unable to create class type [" + this.classType + "]\n" + "with source:\n============>" + source + "\n<=============", exp);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArgumentTypeContext {
        private final Class<?> clazz;
        private final String methodArgType;
        private final String methodArgPrimitiveName;

        public ArgumentTypeContext(Class<?> clazz, String methodArgType, String methodArgPrimitiveName) {
            this.clazz = clazz;
            this.methodArgType = methodArgType;
            this.methodArgPrimitiveName = methodArgPrimitiveName;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getMethodArgType() {
            return this.methodArgType;
        }

        public String getMethodArgPrimitiveName() {
            return this.methodArgPrimitiveName;
        }

        public boolean isPrimitive() {
            return this.methodArgPrimitiveName != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ReturnTypeContext {
        private final Class<?> clazz;
        private final String methodReturnType;
        private final String methodReturnTypePrimitiveName;

        public ReturnTypeContext(Class<?> clazz, String methodReturnType, String methodReturnTypePrimitiveName) {
            this.clazz = clazz;
            this.methodReturnType = methodReturnType;
            this.methodReturnTypePrimitiveName = methodReturnTypePrimitiveName;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getMethodReturnType() {
            return this.methodReturnType;
        }

        public String getMethodReturnTypePrimitiveName() {
            return this.methodReturnTypePrimitiveName;
        }

        public boolean isPrimitive() {
            return this.methodReturnTypePrimitiveName != null;
        }
    }
}

