/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.extension.impl;

import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.AbstractMethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlainTextMethodSynthesizer
extends AbstractMethodSynthesizer
implements MethodSynthesizer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPlainTextMethodSynthesizer.class);

    protected AbstractPlainTextMethodSynthesizer(ClassLoader classLoader) {
        super(classLoader);
    }

    protected final void generateReaderMethods(StringBuilder readMethodCode, StringBuilder getReturnTypeMethodCode, String readerClassName, String sourceClassNameFull, String sourceClassGetterMethodName, Type sourceClassGetterMethodReturnType) throws GeDARuntimeException {
        AbstractMethodSynthesizer.ReturnTypeContext returnType = this.getReturnTypeContext(readerClassName, sourceClassGetterMethodReturnType);
        readMethodCode.append("public Object read(Object source) {\n").append("final ").append(sourceClassNameFull).append(" clazz = (").append(sourceClassNameFull).append(") source;\n");
        if (!returnType.isPrimitive()) {
            readMethodCode.append("return clazz.").append(sourceClassGetterMethodName).append("();\n").append("}");
        } else {
            readMethodCode.append("return ");
            this.appendValueOf(returnType.getMethodReturnTypePrimitiveName(), readMethodCode, "clazz." + sourceClassGetterMethodName + "()");
            readMethodCode.append(";\n}");
        }
        getReturnTypeMethodCode.append("public Class getReturnType() {\n").append("return ").append(returnType.getMethodReturnType()).append(".class;\n").append("}");
        LOG.debug("Creating DataReader Class: \n{}\n{}\n", (Object)readMethodCode, (Object)getReturnTypeMethodCode);
    }

    protected final void generateWriterMethods(StringBuilder writeMethodCode, StringBuilder getParameterTypeMethodCode, String writerClassName, String sourceClassNameFull, String sourceClassSetterMethodName, Class<?> sourceClassSetterMethodArgumentClass) {
        AbstractMethodSynthesizer.ArgumentTypeContext argType = this.getArgumentTypeContext(sourceClassSetterMethodArgumentClass);
        writeMethodCode.append("public void write(Object source, Object value) {\n").append("final ").append(sourceClassNameFull).append(" clazz = (").append(sourceClassNameFull).append(") source;\n").append("clazz.").append(sourceClassSetterMethodName).append("(");
        if (!argType.isPrimitive()) {
            writeMethodCode.append("(").append(argType.getMethodArgType()).append(") value");
        } else {
            this.appendPrimitiveValue(argType.getMethodArgPrimitiveName(), writeMethodCode, "value");
        }
        writeMethodCode.append(");\n}");
        getParameterTypeMethodCode.append("public Class getParameterType() {\n").append("return ").append(argType.getMethodArgType()).append(".class;\n").append("}");
        LOG.debug("Creating DataWriter Class: \n{}\n{}\n", (Object)writeMethodCode, (Object)getParameterTypeMethodCode);
    }

    private void appendValueOf(String primitiveTypeName, StringBuilder toAppendTo, String valueOf) {
        toAppendTo.append((String)PRIMITIVE_TO_WRAPPER.get(primitiveTypeName)).append(".valueOf(").append(valueOf).append(")");
    }

    private void appendPrimitiveValue(String primitiveTypeName, StringBuilder toAppendTo, String valueOf) {
        toAppendTo.append("((").append((String)PRIMITIVE_TO_WRAPPER.get(primitiveTypeName)).append(") ").append(valueOf).append(")").append((String)WRAPPER_TO_PRIMITIVE.get(primitiveTypeName));
    }
}

