/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.extension.impl;

import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.AbstractMethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.BaseDirectoryProvider;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.ByteClassLoader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.FileClassLoader;
import com.inspiresoftware.lib.dto.geda.exception.GeDAException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC_W;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BCELMethodSynthesizer
extends AbstractMethodSynthesizer
implements MethodSynthesizer,
BaseDirectoryProvider {
    private static final int MAJOR = 49;
    private static final int MINOR = 0;
    private static final Logger LOG = LoggerFactory.getLogger(BCELMethodSynthesizer.class);
    private String baseDir = null;
    protected static final Map<String, org.apache.bcel.generic.Type> PRIMITIVE_TO_TYPE = new HashMap<String, org.apache.bcel.generic.Type>();

    public BCELMethodSynthesizer(ClassLoader classLoader) {
        super(classLoader);
    }

    public BCELMethodSynthesizer(ClassLoader classLoader, String baseDir) {
        this(classLoader);
        this.configure("baseDir", baseDir);
    }

    protected SoftReference<ClassLoader> initialiseClassLoaderWeakReference(ClassLoader classLoader) {
        if (this.baseDir == null) {
            return new SoftReference<ClassLoader>(new ByteClassLoader(classLoader));
        }
        return new SoftReference<ClassLoader>(new FileClassLoader(classLoader, this));
    }

    @Override
    protected String getSynthesizerId() {
        return "bcel";
    }

    @Override
    public String getBaseDir(String name) {
        return this.baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T loadClass(ClassLoader loader, String className, ClassGen cg) throws IOException, InstantiationException, IllegalAccessException {
        if (this.baseDir == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            cg.getJavaClass().dump((OutputStream)out);
            Class<?> clazzB = ((ByteClassLoader)loader).loadClass(className, out.toByteArray());
            return (T)clazzB.newInstance();
        }
        String readerSimpleName = className.substring(className.lastIndexOf(46) + 1);
        File clazz = new File(this.baseDir + readerSimpleName + ".class");
        clazz.deleteOnExit();
        LOG.debug("Attempt to create source file: {}", (Object)clazz.getAbsolutePath());
        clazz.createNewFile();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(clazz);
            cg.getJavaClass().dump((OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        LOG.debug("Successfully created source file: {}", (Object)clazz.getAbsolutePath());
        try {
            Class<?> clazzF = loader.loadClass(className);
            return (T)clazzF.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
    }

    private String enhanceInnerClassName(String clazz, boolean inner) {
        if (inner) {
            int pos = clazz.lastIndexOf(46);
            return clazz.substring(0, pos) + '$' + clazz.substring(pos + 1);
        }
        return clazz;
    }

    @Override
    protected DataReader makeReaderClass(ClassLoader loader, Method readMethod, String readerClassName, String sourceClassNameFull, String sourceClassGetterMethodName, Type sourceClassGetterMethodReturnType, AbstractMethodSynthesizer.MakeContext ctx) throws UnableToCreateInstanceException, GeDARuntimeException {
        try {
            LOG.debug("Generating DataReader: {}", (Object)readerClassName);
            AbstractMethodSynthesizer.ReturnTypeContext rtc = this.getReturnTypeContext(readerClassName, sourceClassGetterMethodReturnType);
            ClassGen cg = new ClassGen(readerClassName, "java.lang.Object", "<generated>", 33, new String[]{DataReader.class.getCanonicalName()});
            ConstantPoolGen cp = cg.getConstantPool();
            cg.setMajor(49);
            cg.setMinor(0);
            cg.addEmptyConstructor(1);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<init> method:\n{}", (Object)cg.getMethods()[0].getCode().toString(true));
            }
            InstructionList il = new InstructionList();
            InstructionFactory factory = new InstructionFactory(cg);
            MethodGen read = new MethodGen(1, (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.OBJECT, new org.apache.bcel.generic.Type[]{org.apache.bcel.generic.Type.OBJECT}, new String[]{"source"}, "read", readerClassName, il, cp);
            ObjectType sourceClassType = new ObjectType(sourceClassNameFull);
            il.append((Instruction)new ALOAD(1));
            il.append(factory.createCast(read.getArgumentType(0), (org.apache.bcel.generic.Type)sourceClassType));
            LocalVariableGen clazz = read.addLocalVariable("clazz", (org.apache.bcel.generic.Type)sourceClassType, null, null);
            int clazzIndex = clazz.getIndex();
            clazz.setStart(il.append((Instruction)new ASTORE(clazzIndex)));
            il.append((Instruction)new ALOAD(clazzIndex));
            il.append((Instruction)factory.createInvoke(sourceClassNameFull, sourceClassGetterMethodName, (org.apache.bcel.generic.Type)(rtc.isPrimitive() ? PRIMITIVE_TO_TYPE.get(rtc.getMethodReturnTypePrimitiveName()) : new ObjectType(this.enhanceInnerClassName(rtc.getMethodReturnType(), rtc.getClazz().isMemberClass()))), org.apache.bcel.generic.Type.NO_ARGS, readMethod.getDeclaringClass().isInterface() ? (short)185 : 182));
            if (rtc.isPrimitive()) {
                il.append((Instruction)factory.createInvoke(rtc.getMethodReturnType(), "valueOf", (org.apache.bcel.generic.Type)new ObjectType(rtc.getMethodReturnType()), new org.apache.bcel.generic.Type[]{PRIMITIVE_TO_TYPE.get(rtc.getMethodReturnTypePrimitiveName())}, (short)184));
            }
            clazz.setEnd(il.append((Instruction)InstructionFactory.ARETURN));
            read.setMaxStack();
            cg.addMethod(read.getMethod());
            if (LOG.isDebugEnabled()) {
                LOG.debug("read method:\n{}", (Object)read.getMethod().getCode().toString(true));
            }
            il.dispose();
            MethodGen returnType = new MethodGen(1, (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.CLASS, org.apache.bcel.generic.Type.NO_ARGS, null, "getReturnType", readerClassName, il, cp);
            il.append((Instruction)new LDC_W(cp.addClass(this.enhanceInnerClassName(rtc.getMethodReturnType(), rtc.getClazz().isMemberClass()))));
            il.append((Instruction)InstructionFactory.ARETURN);
            returnType.setMaxStack();
            cg.addMethod(returnType.getMethod());
            if (LOG.isDebugEnabled()) {
                LOG.debug("return type method:\n{}", (Object)returnType.getMethod().getCode().toString(true));
            }
            il.dispose();
            return (DataReader)this.loadClass(loader, readerClassName, cg);
        }
        catch (Exception ite) {
            throw new UnableToCreateInstanceException(readerClassName, "Unable to instantiate class: " + readerClassName, ite);
        }
    }

    @Override
    protected DataWriter makeWriterClass(ClassLoader loader, Method writeMethod, String writerClassName, String sourceClassNameFull, String sourceClassSetterMethodName, Class<?> sourceClassSetterMethodArgumentClass, AbstractMethodSynthesizer.MakeContext ctx) throws UnableToCreateInstanceException {
        try {
            LOG.error("Generating WriterClass: {}", (Object)writerClassName);
            AbstractMethodSynthesizer.ArgumentTypeContext atc = this.getArgumentTypeContext(sourceClassSetterMethodArgumentClass);
            ClassGen cg = new ClassGen(writerClassName, "java.lang.Object", "<generated>", 33, new String[]{DataWriter.class.getCanonicalName()});
            ConstantPoolGen cp = cg.getConstantPool();
            cg.setMajor(49);
            cg.setMinor(0);
            cg.addEmptyConstructor(1);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<init> method:\n{}", (Object)cg.getMethods()[0].getCode().toString(true));
            }
            InstructionList il = new InstructionList();
            InstructionFactory factory = new InstructionFactory(cg);
            MethodGen write = new MethodGen(1, (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.VOID, new org.apache.bcel.generic.Type[]{org.apache.bcel.generic.Type.OBJECT, org.apache.bcel.generic.Type.OBJECT}, new String[]{"source", "value"}, "write", writerClassName, il, cp);
            ObjectType sourceClassType = new ObjectType(sourceClassNameFull);
            il.append((Instruction)new ALOAD(1));
            il.append(factory.createCast(write.getArgumentType(0), (org.apache.bcel.generic.Type)sourceClassType));
            LocalVariableGen clazz = write.addLocalVariable("clazz", (org.apache.bcel.generic.Type)sourceClassType, null, null);
            int clazzIndex = clazz.getIndex();
            clazz.setStart(il.append((Instruction)new ASTORE(clazzIndex)));
            il.append((Instruction)new ALOAD(clazzIndex));
            il.append((Instruction)new ALOAD(2));
            il.append(factory.createCast(write.getArgumentType(1), (org.apache.bcel.generic.Type)new ObjectType(this.enhanceInnerClassName(atc.getMethodArgType(), atc.getClazz().isMemberClass()))));
            if (atc.isPrimitive()) {
                String textMethCall = (String)WRAPPER_TO_PRIMITIVE.get(atc.getMethodArgPrimitiveName());
                il.append((Instruction)factory.createInvoke(atc.getMethodArgType(), textMethCall.substring(1, textMethCall.length() - 2), PRIMITIVE_TO_TYPE.get(atc.getMethodArgPrimitiveName()), org.apache.bcel.generic.Type.NO_ARGS, (short)182));
            }
            il.append((Instruction)factory.createInvoke(sourceClassNameFull, sourceClassSetterMethodName, (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.VOID, new org.apache.bcel.generic.Type[]{atc.isPrimitive() ? PRIMITIVE_TO_TYPE.get(atc.getMethodArgPrimitiveName()) : new ObjectType(this.enhanceInnerClassName(atc.getMethodArgType(), atc.getClazz().isMemberClass()))}, writeMethod.getDeclaringClass().isInterface() ? (short)185 : 182));
            clazz.setEnd(il.append((Instruction)InstructionFactory.RETURN));
            write.setMaxStack();
            cg.addMethod(write.getMethod());
            if (LOG.isDebugEnabled()) {
                LOG.debug("write method:\n{}", (Object)write.getMethod().getCode().toString(true));
            }
            il.dispose();
            MethodGen paramType = new MethodGen(1, (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.CLASS, org.apache.bcel.generic.Type.NO_ARGS, null, "getParameterType", writerClassName, il, cp);
            il.append((Instruction)new LDC_W(cp.addClass(this.enhanceInnerClassName(atc.getMethodArgType(), atc.getClazz().isMemberClass()))));
            il.append((Instruction)InstructionFactory.ARETURN);
            paramType.setMaxStack();
            cg.addMethod(paramType.getMethod());
            if (LOG.isDebugEnabled()) {
                LOG.debug("return type method:\n{}", (Object)paramType.getMethod().getCode().toString(true));
            }
            il.dispose();
            return (DataWriter)this.loadClass(loader, writerClassName, cg);
        }
        catch (Exception ite) {
            throw new UnableToCreateInstanceException(writerClassName, "Unable to instantiate class: " + writerClassName, ite);
        }
    }

    @Override
    public boolean configure(String configuration, Object value) throws GeDAException {
        if ("baseDir".equals(configuration) && value instanceof String) {
            String dir = (String)value;
            this.baseDir = dir.endsWith("/") ? dir : dir + "/";
            LOG.info("Setting class loader base dir to: {}", (Object)this.baseDir);
            this.enhanceClassLoader();
            return true;
        }
        return super.configure(configuration, value);
    }

    static {
        PRIMITIVE_TO_TYPE.put("byte", (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.BYTE);
        PRIMITIVE_TO_TYPE.put("short", (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.SHORT);
        PRIMITIVE_TO_TYPE.put("int", (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.INT);
        PRIMITIVE_TO_TYPE.put("long", (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.LONG);
        PRIMITIVE_TO_TYPE.put("float", (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.FLOAT);
        PRIMITIVE_TO_TYPE.put("double", (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.DOUBLE);
        PRIMITIVE_TO_TYPE.put("boolean", (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.BOOLEAN);
        PRIMITIVE_TO_TYPE.put("char", (org.apache.bcel.generic.Type)org.apache.bcel.generic.Type.CHAR);
    }
}

