/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.extension.impl;

import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.BaseDirectoryProvider;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.ByteClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileClassLoader
extends ByteClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FileClassLoader.class);
    private final BaseDirectoryProvider directoryProvider;

    public FileClassLoader(ClassLoader parent, BaseDirectoryProvider directoryProvider) {
        super(parent);
        this.directoryProvider = directoryProvider;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException exp) {
            String baseDir = this.directoryProvider.getBaseDir(name);
            String readerSimpleName = name.substring(name.lastIndexOf(46) + 1);
            String filename = baseDir + readerSimpleName + ".class";
            try {
                File file = new File(filename);
                file.deleteOnExit();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Trying to read class file: {}", (Object)file.getAbsolutePath());
                }
                FileInputStream fis = new FileInputStream(file);
                byte[] clazz = new byte[(int)file.length()];
                fis.read(clazz);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Successfully loaded class file: {}", (Object)file.getAbsolutePath());
                }
                return this.loadClass(name, clazz);
            }
            catch (FileNotFoundException e) {
                throw new ClassNotFoundException("No class: " + name + " located at " + filename, e);
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException("Unable to read: " + name + " located at " + filename, ioe);
            }
        }
    }
}

