/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.extension.impl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashTable<V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table = new Entry[16];
    transient int size;
    int threshold = 12;
    final float loadFactor;
    volatile transient int modCount;

    public IntHashTable() {
        this.loadFactor = 0.75f;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public V get(int key) {
        Entry<V> val = this.getEntry(key);
        if (val != null) {
            return val.value;
        }
        return null;
    }

    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    final Entry<V> getEntry(int key) {
        int hash = key;
        Entry e = this.table[IntHashTable.indexFor(hash, this.table.length)];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public V put(int key, V value) {
        int hash = key;
        int i = IntHashTable.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return null;
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = IntHashTable.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    public V remove(int key) {
        Entry<V> e = this.removeEntryForKey(key);
        return e == null ? null : (V)e.value;
    }

    final Entry<V> removeEntryForKey(int key) {
        Entry prev;
        int hash = key;
        int i = IntHashTable.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            int k;
            Entry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    void addEntry(int hash, int key, V value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<V>(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    public int[] keysArray() {
        int[] keys = new int[this.size];
        int keyIndex = 0;
        for (int bucketIndex = 0; bucketIndex < this.table.length && keyIndex < keys.length; ++bucketIndex) {
            Entry e = this.table[bucketIndex];
            do {
                int n = keys[keyIndex++] = e != null ? e.getKey() : 0;
            } while (keyIndex < keys.length && e != null && (e = e.next) != null);
        }
        return keys;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<V> {
        final int key;
        V value;
        Entry<V> next;
        final int hash;

        Entry(int h, int k, V v, Entry<V> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public final int getKey() {
            return this.key;
        }

        public final V getValue() {
            return this.value;
        }

        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public final boolean equals(Object o) {
            V v2;
            V v1;
            int k2;
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            int k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        public final int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

