/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.extension.impl;

import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.exception.GeDAException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.beans.PropertyDescriptor;
import java.util.Map;

public class JavaMapMethodSynthesizer
implements MethodSynthesizer {
    public DataReader synthesizeReader(PropertyDescriptor descriptor) throws InspectionPropertyNotFoundException, UnableToCreateInstanceException, GeDARuntimeException {
        final String propName = descriptor.getName();
        final Class<?> returnType = descriptor.getReadMethod().getReturnType();
        return new DataReader(){
            private String property;
            private Class type;
            {
                this.property = propName;
                this.type = returnType;
            }

            @Override
            public Object read(Object source) {
                Map mapSource = (Map)source;
                return mapSource.get(this.property);
            }

            @Override
            public Class<?> getReturnType() {
                return this.type;
            }
        };
    }

    public DataWriter synthesizeWriter(PropertyDescriptor descriptor) throws InspectionPropertyNotFoundException, UnableToCreateInstanceException, GeDARuntimeException {
        final String propName = descriptor.getName();
        final Class<?> paramType = descriptor.getWriteMethod().getParameterTypes()[0];
        return new DataWriter(){
            private String property;
            private Class type;
            {
                this.property = propName;
                this.type = paramType;
            }

            @Override
            public void write(Object source, Object value) {
                Map mapSource = (Map)source;
                mapSource.put(this.property, value);
            }

            @Override
            public Class<?> getParameterType() {
                return this.type;
            }
        };
    }

    public boolean configure(String configuration, Object value) throws GeDAException {
        return false;
    }

    public void releaseResources() {
    }
}

