/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.extension.impl;

import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.AbstractMethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.AbstractPlainTextMethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistMethodSynthesizer
extends AbstractPlainTextMethodSynthesizer
implements MethodSynthesizer {
    private static final Logger LOG = LoggerFactory.getLogger(JavassistMethodSynthesizer.class);
    private ClassPool pool = new ClassPool(true);

    public JavassistMethodSynthesizer(ClassLoader classLoader) {
        super(classLoader);
        this.appendClassPath(this.pool);
    }

    protected void appendClassPath(ClassPool pool) {
        pool.appendClassPath((ClassPath)new LoaderClassPath(this.getClassLoader()));
    }

    protected ClassPool getClassPool() {
        return this.pool;
    }

    @Override
    protected String getSynthesizerId() {
        return "javassist";
    }

    @Override
    protected DataReader makeReaderClass(ClassLoader loader, Method readMethod, String readerClassName, String sourceClassNameFull, String sourceClassGetterMethodName, Type sourceClassGetterMethodReturnType, AbstractMethodSynthesizer.MakeContext ctx) throws UnableToCreateInstanceException, GeDARuntimeException {
        CtClass ctClass = this.pool.makeClass(readerClassName);
        StringBuilder readMethodCode = new StringBuilder();
        StringBuilder getReturnTypeMethodCode = new StringBuilder();
        try {
            ctClass.setInterfaces(new CtClass[]{this.pool.get(DataReader.class.getCanonicalName())});
            this.generateReaderMethods(readMethodCode, getReturnTypeMethodCode, readerClassName, sourceClassNameFull, sourceClassGetterMethodName, sourceClassGetterMethodReturnType);
            CtMethod methodRead = CtMethod.make((String)readMethodCode.toString(), (CtClass)ctClass);
            ctClass.addMethod(methodRead);
            CtMethod methodGetReturnType = CtMethod.make((String)getReturnTypeMethodCode.toString(), (CtClass)ctClass);
            ctClass.addMethod(methodGetReturnType);
            ctClass.detach();
            DataReader reader = (DataReader)ctClass.toClass(loader, DataReader.class.getProtectionDomain()).newInstance();
            return reader;
        }
        catch (CannotCompileException cce) {
            ctx.next((Exception)((Object)cce), readMethodCode.toString() + "\n\n" + getReturnTypeMethodCode.toString());
            LOG.warn("Unable to create method in class: {}... possibly class already loaded", (Object)readerClassName);
            return null;
        }
        catch (Exception ite) {
            throw new UnableToCreateInstanceException(readerClassName, "Unable to instantiate class: " + readerClassName, ite);
        }
    }

    @Override
    protected DataWriter makeWriterClass(ClassLoader loader, Method writeMethod, String writerClassName, String sourceClassNameFull, String sourceClassSetterMethodName, Class<?> sourceClassSetterMethodArgumentClass, AbstractMethodSynthesizer.MakeContext ctx) throws UnableToCreateInstanceException {
        CtClass ctClass = this.pool.makeClass(writerClassName);
        StringBuilder writeMethodCode = new StringBuilder();
        StringBuilder getParameterTypeMethodCode = new StringBuilder();
        try {
            ctClass.setInterfaces(new CtClass[]{this.pool.get(DataWriter.class.getCanonicalName())});
            this.generateWriterMethods(writeMethodCode, getParameterTypeMethodCode, writerClassName, sourceClassNameFull, sourceClassSetterMethodName, sourceClassSetterMethodArgumentClass);
            CtMethod methodWrite = CtMethod.make((String)writeMethodCode.toString(), (CtClass)ctClass);
            ctClass.addMethod(methodWrite);
            CtMethod methodGetParameterType = CtMethod.make((String)getParameterTypeMethodCode.toString(), (CtClass)ctClass);
            ctClass.addMethod(methodGetParameterType);
            ctClass.detach();
            DataWriter writer = (DataWriter)ctClass.toClass(loader, DataWriter.class.getProtectionDomain()).newInstance();
            return writer;
        }
        catch (CannotCompileException cce) {
            ctx.next((Exception)((Object)cce), writeMethodCode.toString() + "\n\n" + getParameterTypeMethodCode.toString());
            LOG.warn("Unable to create method in class: {}... possibly class had been loaded", (Object)writerClassName);
            return null;
        }
        catch (Exception ite) {
            throw new UnableToCreateInstanceException(writerClassName, "Unable to instantiate class: " + writerClassName, ite);
        }
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        this.pool = null;
    }
}

