/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.extension.impl;

import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.AbstractMethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionMethodSynthesizer
extends AbstractMethodSynthesizer
implements MethodSynthesizer {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionMethodSynthesizer.class);

    public ReflectionMethodSynthesizer(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected String getSynthesizerId() {
        return "reflection";
    }

    @Override
    protected DataReader makeReaderClass(ClassLoader loader, final Method readMethod, String readerClassName, String sourceClassNameFull, String sourceClassGetterMethodName, Type sourceClassGetterMethodReturnType, AbstractMethodSynthesizer.MakeContext ctx) throws UnableToCreateInstanceException, GeDARuntimeException {
        Class rcl;
        final Class<Object> returnType = sourceClassGetterMethodReturnType instanceof Class ? ((rcl = (Class)sourceClassGetterMethodReturnType).isPrimitive() ? (Class)PRIMITIVE_TO_WRAPPER_CLASS.get(rcl.getCanonicalName()) : (Class<Object>)sourceClassGetterMethodReturnType) : (sourceClassGetterMethodReturnType instanceof ParameterizedType ? (Class<Object>)((ParameterizedType)sourceClassGetterMethodReturnType).getRawType() : (sourceClassGetterMethodReturnType instanceof TypeVariable ? Object.class : Object.class));
        return new DataReader(){
            private final Method method;
            private final Class<?> type;
            {
                this.method = readMethod;
                this.type = returnType;
            }

            @Override
            public Class<?> getReturnType() {
                return this.type;
            }

            @Override
            public Object read(Object source) {
                try {
                    return this.method.invoke(source, new Object[0]);
                }
                catch (Exception exp) {
                    LOG.error(exp.getMessage(), (Throwable)exp);
                    return null;
                }
            }
        };
    }

    @Override
    protected DataWriter makeWriterClass(ClassLoader loader, final Method writeMethod, String writerClassName, String sourceClassNameFull, String sourceClassSetterMethodName, Class<?> sourceClassSetterMethodArgumentClass, AbstractMethodSynthesizer.MakeContext ctx) throws UnableToCreateInstanceException {
        final Class argType = sourceClassSetterMethodArgumentClass.isPrimitive() ? (Class)PRIMITIVE_TO_WRAPPER_CLASS.get(sourceClassSetterMethodArgumentClass.getCanonicalName()) : sourceClassSetterMethodArgumentClass;
        return new DataWriter(){
            private final Method method;
            private final Class<?> type;
            {
                this.method = writeMethod;
                this.type = argType;
            }

            @Override
            public Class<?> getParameterType() {
                return this.type;
            }

            @Override
            public void write(Object source, Object value) {
                Object args = value;
                try {
                    this.method.invoke(source, args);
                }
                catch (Exception exp) {
                    LOG.error(exp.getMessage(), (Throwable)exp);
                }
            }
        };
    }
}

