/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.extension.impl;

import com.inspiresoftware.lib.dto.geda.assembler.extension.Cache;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DisposableContainer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.IntHashTable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftReferenceCache<V>
implements Cache<V> {
    private final IntHashTable<SoftReference<V>> cache = new IntHashTable();
    private final ReferenceQueue<V> cacheQueue = new ReferenceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(int key) {
        SoftReference<V> val = this.cache.get(key);
        if (val != null) {
            V obj = val.get();
            if (obj == null) {
                SoftReferenceCache softReferenceCache = this;
                synchronized (softReferenceCache) {
                    this.cache.remove(key);
                }
                return null;
            }
            return obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int key, V value) {
        SoftReferenceCache softReferenceCache = this;
        synchronized (softReferenceCache) {
            SoftReference<V> ref = new SoftReference<V>(value, this.cacheQueue);
            this.cache.put(key, ref);
        }
    }

    @Override
    public boolean configure(String configuration, Object value) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResources() {
        SoftReferenceCache softReferenceCache = this;
        synchronized (softReferenceCache) {
            int[] keys = this.cache.keysArray();
            for (int index = 0; index < keys.length; ++index) {
                int key = keys[index];
                if (key == 0) continue;
                SoftReference<V> ref = this.cache.remove(key);
                V obj = ref.get();
                if (obj instanceof DisposableContainer) {
                    ((DisposableContainer)obj).releaseResources();
                }
                ref.clear();
            }
            while (this.cacheQueue.poll() != null) {
            }
        }
    }
}

