/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler.extension.impl;

import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.AbstractMethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.AbstractPlainTextMethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.BaseDirectoryProvider;
import com.inspiresoftware.lib.dto.geda.assembler.extension.impl.FileClassLoader;
import com.inspiresoftware.lib.dto.geda.exception.GeDAException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import com.sun.tools.javac.Main;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunJavaToolsMethodSynthesizer
extends AbstractPlainTextMethodSynthesizer
implements MethodSynthesizer,
BaseDirectoryProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SunJavaToolsMethodSynthesizer.class);
    private static final String JAVA_SOURCE_VERSION = "1.5";
    private String baseDir = "";

    public SunJavaToolsMethodSynthesizer(ClassLoader classLoader) {
        super(classLoader);
    }

    public SunJavaToolsMethodSynthesizer(ClassLoader classLoader, String baseDir) throws GeDAException {
        this(classLoader);
        this.configure("baseDir", baseDir);
    }

    @Override
    protected String getSynthesizerId() {
        return "suntools";
    }

    protected SoftReference<ClassLoader> initialiseClassLoaderWeakReference(ClassLoader classLoader) {
        return new SoftReference<ClassLoader>(new FileClassLoader(classLoader, this));
    }

    @Override
    public String getBaseDir(String name) {
        return this.baseDir;
    }

    @Override
    public boolean configure(String configuration, Object value) throws GeDAException {
        if ("baseDir".equals(configuration) && value instanceof String) {
            String dir = (String)value;
            this.baseDir = dir.endsWith("/") ? dir : dir + "/";
            LOG.info("Setting class loader base dir to: {}", (Object)this.baseDir);
            return true;
        }
        return super.configure(configuration, value);
    }

    @Override
    protected DataReader makeReaderClass(ClassLoader loader, Method readMethod, String readerClassName, String sourceClassNameFull, String sourceClassGetterMethodName, Type sourceClassGetterMethodReturnType, AbstractMethodSynthesizer.MakeContext ctx) throws UnableToCreateInstanceException {
        try {
            StringBuilder readMethodCode = new StringBuilder();
            StringBuilder getReturnTypeMethodCode = new StringBuilder();
            this.generateReaderMethods(readMethodCode, getReturnTypeMethodCode, readerClassName, sourceClassNameFull, sourceClassGetterMethodName, sourceClassGetterMethodReturnType);
            String source = this.generateReaderSource(readerClassName, readMethodCode, getReturnTypeMethodCode);
            File clazz = this.createSourceFile(readerClassName, source);
            if (SunJavaToolsMethodSynthesizer.compile(clazz) == 0) {
                Class<?> readerClass = this.getClassLoader().loadClass(readerClassName);
                return (DataReader)readerClass.newInstance();
            }
            ctx.next(null, source);
        }
        catch (Exception ite) {
            throw new UnableToCreateInstanceException(readerClassName, "Unable to instantiate class: " + readerClassName, ite);
        }
        return null;
    }

    private String generateReaderSource(String fullClassName, StringBuilder readMethodCode, StringBuilder getReturnTypeMethodCode) {
        int namePos = fullClassName.lastIndexOf(46);
        String packageName = fullClassName.substring(0, namePos);
        String className = fullClassName.substring(namePos + 1);
        StringBuilder source = new StringBuilder();
        source.append("package ").append(packageName).append(";\n").append("import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;\n").append("public class ").append(className).append(" implements DataReader {\n").append((CharSequence)getReturnTypeMethodCode).append((CharSequence)readMethodCode).append("}\n");
        return source.toString();
    }

    @Override
    protected DataWriter makeWriterClass(ClassLoader loader, Method writeMethod, String writerClassName, String sourceClassNameFull, String sourceClassSetterMethodName, Class<?> sourceClassSetterMethodArgumentClass, AbstractMethodSynthesizer.MakeContext ctx) throws UnableToCreateInstanceException {
        try {
            StringBuilder writeMethodCode = new StringBuilder();
            StringBuilder getParameterTypeMethodCode = new StringBuilder();
            this.generateWriterMethods(writeMethodCode, getParameterTypeMethodCode, writerClassName, sourceClassNameFull, sourceClassSetterMethodName, sourceClassSetterMethodArgumentClass);
            String source = this.generateWriterSource(writerClassName, writeMethodCode, getParameterTypeMethodCode);
            File clazz = this.createSourceFile(writerClassName, source);
            if (SunJavaToolsMethodSynthesizer.compile(clazz) == 0) {
                Class<?> writerClass = this.getClassLoader().loadClass(writerClassName);
                return (DataWriter)writerClass.newInstance();
            }
            ctx.next(null, source);
        }
        catch (Exception ite) {
            throw new UnableToCreateInstanceException(writerClassName, "Unable to instantiate class: " + writerClassName, ite);
        }
        return null;
    }

    private String generateWriterSource(String fullClassName, StringBuilder writeMethodCode, StringBuilder getParameterTypeMethodCode) {
        int namePos = fullClassName.lastIndexOf(46);
        String packageName = fullClassName.substring(0, namePos);
        String className = fullClassName.substring(namePos + 1);
        StringBuilder source = new StringBuilder();
        source.append("package ").append(packageName).append(";\n").append("import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;\n").append("public class ").append(className).append(" implements DataWriter {\n").append((CharSequence)getParameterTypeMethodCode).append((CharSequence)writeMethodCode).append("}\n");
        return source.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createSourceFile(String className, String source) throws UnableToCreateInstanceException {
        String readerSimpleName = className.substring(className.lastIndexOf(46) + 1);
        File clazz = new File(this.baseDir + readerSimpleName + ".java");
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempt to create source file: {}", (Object)clazz.getAbsolutePath());
            }
            if (!clazz.exists()) {
                clazz.deleteOnExit();
                clazz.createNewFile();
            }
            LOG.debug("Source: \n{}\n", (Object)source);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(clazz);
                fos.write(source.getBytes());
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully created source file: {}", (Object)clazz.getAbsolutePath());
            }
            return clazz;
        }
        catch (IOException ioe) {
            throw new UnableToCreateInstanceException("DataReader", "Unable to create temporary file for reader source: " + clazz.getAbsolutePath(), ioe);
        }
    }

    private static int compile(File source) {
        return Main.compile(new String[]{"-source", JAVA_SOURCE_VERSION, "-target", JAVA_SOURCE_VERSION, "-verbose", source.getAbsolutePath()});
    }
}

