/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.config;

import com.inspiresoftware.lib.dto.geda.impl.DTOSupportImpl;
import com.inspiresoftware.lib.dto.geda.interceptor.GeDAInterceptor;
import com.inspiresoftware.lib.dto.geda.interceptor.impl.BootstrapAdviceConfigResolverImpl;
import com.inspiresoftware.lib.dto.geda.interceptor.impl.GeDABootstrapAdvicePostProcessor;
import com.inspiresoftware.lib.dto.geda.interceptor.impl.GeDAMethodMatcherPointcut;
import com.inspiresoftware.lib.dto.geda.interceptor.impl.GeDAMethodRegExMatcherPointcut;
import com.inspiresoftware.lib.dto.geda.interceptor.impl.RuntimeAdviceConfigResolverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AnnotationDrivenGeDABeanDefinitionParser
implements BeanDefinitionParser {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationDrivenGeDABeanDefinitionParser.class);
    private static final String XSD_ATTR__DTO_SUPPORT = "dto-support";
    private static final String XSD_ATTR__DTO_FACTORY = "dto-factory";
    private static final String XSD_ATTR__DTO_ADAPTERS_REGISTRAR = "dto-adapters-registrar";
    private static final String XSD_ATTR__DTO_DSL_REGISTRAR = "dto-dsl-registrar";
    private static final String XSD_ATTR__ON_DTO_ASSEMBLY = "on-dto-assembly";
    private static final String XSD_ATTR__ON_DTO_ASSEMBLED = "on-dto-assembled";
    private static final String XSD_ATTR__ON_DTO_FAILED = "on-dto-failed";
    private static final String XSD_ATTR__ON_ENTITY_ASSEMBLY = "on-entity-assembly";
    private static final String XSD_ATTR__ON_ENTITY_ASSEMBLED = "on-entity-assembled";
    private static final String XSD_ATTR__ON_ENTITY_FAILED = "on-entity-failed";
    private static final String XSD_ATTR__USE_PREPROCESSOR = "use-bean-preprocessor";
    private static final String XSD_ATTR__POINTCUT_MATCH_REGEX = "pointcut-match-regex";
    private static final String XSD_ATTR__POINTCUT_NOMATCH_REGEX = "pointcut-nomatch-regex";
    public static final String ADVISOR_BEAN_NAME = AnnotationDrivenGeDABeanDefinitionParser.class.getPackage().getName() + ".internalGeDAAdvisor";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
        if (!parserContext.getRegistry().containsBeanDefinition(ADVISOR_BEAN_NAME)) {
            RuntimeBeanReference defaultInterceptor;
            RuntimeBeanReference pointcut;
            String[] noMatchRegEx;
            String[] matchRegEx;
            RuntimeBeanReference defaultCfgAdvice;
            RuntimeBeanReference dtoSupportDef;
            Boolean usePreprocessor = Boolean.valueOf(element.getAttribute(XSD_ATTR__USE_PREPROCESSOR));
            String dtoSupportBeanName = element.getAttribute(XSD_ATTR__DTO_SUPPORT);
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            Object elementSource = parserContext.extractSource((Object)element);
            if (!registry.containsBeanDefinition(dtoSupportBeanName)) {
                String dtoFactoryBeanName = element.getAttribute(XSD_ATTR__DTO_FACTORY);
                RuntimeBeanReference dtoFactoryRef = new RuntimeBeanReference(dtoFactoryBeanName);
                String dtoVcrBeanName = element.getAttribute(XSD_ATTR__DTO_ADAPTERS_REGISTRAR);
                RuntimeBeanReference dtoVcrRef = StringUtils.hasLength((String)dtoVcrBeanName) ? new RuntimeBeanReference(dtoVcrBeanName) : null;
                String dtoDslBeanName = element.getAttribute(XSD_ATTR__DTO_DSL_REGISTRAR);
                RuntimeBeanReference dtoDslRef = StringUtils.hasLength((String)dtoDslBeanName) ? new RuntimeBeanReference(dtoDslBeanName) : null;
                dtoSupportDef = this.setupDtoSupport(element, dtoSupportBeanName, registry, elementSource, dtoFactoryRef, dtoVcrRef, dtoDslRef);
            } else {
                dtoSupportDef = new RuntimeBeanReference(dtoSupportBeanName);
            }
            if (usePreprocessor.booleanValue()) {
                this.setupBootstapBeanPostprocessor(element, parserContext, elementSource);
                defaultCfgAdvice = this.setupTransferableAdviceConfigResolver(parserContext, elementSource, BootstrapAdviceConfigResolverImpl.class);
                matchRegEx = this.getPointcutRegex(element, XSD_ATTR__POINTCUT_MATCH_REGEX);
                noMatchRegEx = this.getPointcutRegex(element, XSD_ATTR__POINTCUT_NOMATCH_REGEX);
                pointcut = this.setupPointcut(parserContext, elementSource, defaultCfgAdvice, matchRegEx, noMatchRegEx);
                defaultInterceptor = this.setupGeDAInterceptor(parserContext, elementSource, dtoSupportDef, defaultCfgAdvice);
                this.setupPointcutAdvisor(element, parserContext, elementSource, pointcut, defaultInterceptor);
            } else {
                defaultCfgAdvice = this.setupTransferableAdviceConfigResolver(parserContext, elementSource, RuntimeAdviceConfigResolverImpl.class);
                matchRegEx = this.getPointcutRegex(element, XSD_ATTR__POINTCUT_MATCH_REGEX);
                noMatchRegEx = this.getPointcutRegex(element, XSD_ATTR__POINTCUT_NOMATCH_REGEX);
                pointcut = this.setupPointcut(parserContext, elementSource, defaultCfgAdvice, matchRegEx, noMatchRegEx);
                defaultInterceptor = this.setupGeDAInterceptor(parserContext, elementSource, dtoSupportDef, defaultCfgAdvice);
                this.setupPointcutAdvisor(element, parserContext, elementSource, pointcut, defaultInterceptor);
            }
        }
        return null;
    }

    protected RuntimeBeanReference setupDtoSupport(Element element, String dtoSupportBeanName, BeanDefinitionRegistry registry, Object elementSource, RuntimeBeanReference dtoFactoryRef, RuntimeBeanReference dtoVcrRef, RuntimeBeanReference dtoDslRef) {
        RootBeanDefinition dtoSupportDef = new RootBeanDefinition(DTOSupportImpl.class);
        dtoSupportDef.setSource(elementSource);
        dtoSupportDef.setRole(0);
        MutablePropertyValues valuesArgs = dtoSupportDef.getPropertyValues();
        valuesArgs.addPropertyValue("beanFactory", (Object)dtoFactoryRef);
        if (dtoVcrRef != null) {
            valuesArgs.addPropertyValue("adaptersRegistrar", (Object)dtoVcrRef);
        }
        if (dtoDslRef != null) {
            valuesArgs.addPropertyValue("dslRegistrar", (Object)dtoDslRef);
        }
        this.setupListenerProperty(valuesArgs, "onDtoAssembly", element.getAttribute(XSD_ATTR__ON_DTO_ASSEMBLY));
        this.setupListenerProperty(valuesArgs, "onDtoAssembled", element.getAttribute(XSD_ATTR__ON_DTO_ASSEMBLED));
        this.setupListenerProperty(valuesArgs, "onDtoFailed", element.getAttribute(XSD_ATTR__ON_DTO_FAILED));
        this.setupListenerProperty(valuesArgs, "onEntityAssembly", element.getAttribute(XSD_ATTR__ON_ENTITY_ASSEMBLY));
        this.setupListenerProperty(valuesArgs, "onEntityAssembled", element.getAttribute(XSD_ATTR__ON_ENTITY_ASSEMBLED));
        this.setupListenerProperty(valuesArgs, "onEntityFailed", element.getAttribute(XSD_ATTR__ON_ENTITY_FAILED));
        registry.registerBeanDefinition(dtoSupportBeanName, (BeanDefinition)dtoSupportDef);
        return new RuntimeBeanReference(dtoSupportBeanName);
    }

    protected void setupListenerProperty(MutablePropertyValues valuesArgs, String property, String listenerName) {
        if (StringUtils.hasLength((String)listenerName)) {
            valuesArgs.addPropertyValue(property, (Object)new RuntimeBeanReference(listenerName));
        }
    }

    protected RuntimeBeanReference setupTransferableAdviceConfigResolver(ParserContext parserContext, Object elementSource, Class impl) {
        RootBeanDefinition defaultResolver = new RootBeanDefinition(impl);
        defaultResolver.setSource(elementSource);
        defaultResolver.setRole(2);
        XmlReaderContext readerContext = parserContext.getReaderContext();
        String beanName = readerContext.registerWithGeneratedName((BeanDefinition)defaultResolver);
        return new RuntimeBeanReference(beanName);
    }

    protected String[] getPointcutRegex(Element element, String attrName) {
        String matchRegexAttr = element.getAttribute(attrName);
        if (StringUtils.hasText((String)matchRegexAttr)) {
            String[] regex = matchRegexAttr.split(",");
            String[] matchRegex = new String[regex.length];
            for (int i = 0; i < regex.length; ++i) {
                matchRegex[i] = regex[i].trim();
            }
            return matchRegex;
        }
        return new String[0];
    }

    protected RuntimeBeanReference setupPointcut(ParserContext parserContext, Object elementSource, RuntimeBeanReference resolver, String[] pointcutMatchRegex, String[] pointcutNoMatchRegex) {
        ConstructorArgumentValues constructorArgs;
        RootBeanDefinition pointcut;
        if (pointcutMatchRegex.length == 0 && pointcutNoMatchRegex.length == 0) {
            pointcut = new RootBeanDefinition(GeDAMethodMatcherPointcut.class);
            constructorArgs = pointcut.getConstructorArgumentValues();
            constructorArgs.addGenericArgumentValue((Object)resolver);
        } else {
            pointcut = new RootBeanDefinition(GeDAMethodRegExMatcherPointcut.class);
            constructorArgs = pointcut.getConstructorArgumentValues();
            constructorArgs.addGenericArgumentValue((Object)resolver);
            MutablePropertyValues propertyValues = pointcut.getPropertyValues();
            if (pointcutMatchRegex.length > 0) {
                propertyValues.addPropertyValue("patterns", (Object)pointcutMatchRegex);
            }
            if (pointcutNoMatchRegex.length > 0) {
                propertyValues.addPropertyValue("excludedPatterns", (Object)pointcutNoMatchRegex);
            }
        }
        pointcut.setSource(elementSource);
        pointcut.setRole(2);
        XmlReaderContext readerContext = parserContext.getReaderContext();
        String pointcutBeanName = readerContext.registerWithGeneratedName((BeanDefinition)pointcut);
        return new RuntimeBeanReference(pointcutBeanName);
    }

    protected RuntimeBeanReference setupGeDAInterceptor(ParserContext parserContext, Object elementSource, RuntimeBeanReference defaultSupport, RuntimeBeanReference defaultResolver) {
        RootBeanDefinition defaultInterceptor = new RootBeanDefinition(GeDAInterceptor.class);
        defaultInterceptor.setSource(elementSource);
        defaultInterceptor.setRole(2);
        MutablePropertyValues propertyValues = defaultInterceptor.getPropertyValues();
        propertyValues.addPropertyValue("support", (Object)defaultSupport);
        propertyValues.addPropertyValue("resolver", (Object)defaultResolver);
        XmlReaderContext readerContext = parserContext.getReaderContext();
        String beanName = readerContext.registerWithGeneratedName((BeanDefinition)defaultInterceptor);
        return new RuntimeBeanReference(beanName);
    }

    protected RuntimeBeanReference setupPointcutAdvisor(Element element, ParserContext parserContext, Object elementSource, RuntimeBeanReference pointcutBeanReference, RuntimeBeanReference interceptorBeanReference) {
        RootBeanDefinition pointcutAdvisor = new RootBeanDefinition(DefaultBeanFactoryPointcutAdvisor.class);
        pointcutAdvisor.setSource(elementSource);
        pointcutAdvisor.setRole(2);
        MutablePropertyValues propertyValues = pointcutAdvisor.getPropertyValues();
        propertyValues.addPropertyValue("adviceBeanName", (Object)interceptorBeanReference.getBeanName());
        propertyValues.addPropertyValue("pointcut", (Object)pointcutBeanReference);
        if (element.hasAttribute("order")) {
            propertyValues.addPropertyValue("order", (Object)element.getAttribute("order"));
        }
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        registry.registerBeanDefinition(ADVISOR_BEAN_NAME, (BeanDefinition)pointcutAdvisor);
        return new RuntimeBeanReference(ADVISOR_BEAN_NAME);
    }

    protected RuntimeBeanReference setupBootstapBeanPostprocessor(Element element, ParserContext parserContext, Object elementSource) {
        RootBeanDefinition beanPostProcessor = new RootBeanDefinition(GeDABootstrapAdvicePostProcessor.class);
        beanPostProcessor.setSource(elementSource);
        beanPostProcessor.setRole(2);
        XmlReaderContext readerContext = parserContext.getReaderContext();
        String beanName = readerContext.registerWithGeneratedName((BeanDefinition)beanPostProcessor);
        return new RuntimeBeanReference(beanName);
    }
}

