/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.impl;

import com.inspiresoftware.lib.dto.geda.DTOAdaptersRegistrar;
import com.inspiresoftware.lib.dto.geda.DTODSLRegistrar;
import com.inspiresoftware.lib.dto.geda.DTOSupport;
import com.inspiresoftware.lib.dto.geda.adapter.Adapters;
import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.adapter.ExtensibleBeanFactory;
import com.inspiresoftware.lib.dto.geda.adapter.repository.AdaptersRepository;
import com.inspiresoftware.lib.dto.geda.annotations.Dto;
import com.inspiresoftware.lib.dto.geda.assembler.Assembler;
import com.inspiresoftware.lib.dto.geda.assembler.DTOAssembler;
import com.inspiresoftware.lib.dto.geda.dsl.Registries;
import com.inspiresoftware.lib.dto.geda.dsl.Registry;
import com.inspiresoftware.lib.dto.geda.event.DTOEventListener;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTOSupportImpl
implements DTOSupport,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DTOSupportImpl.class);
    private ExtensibleBeanFactory beanFactory = Adapters.beanFactory();
    private DTOAdaptersRegistrar adaptersRegistrar;
    private DTODSLRegistrar dslRegistrar;
    private final AdaptersRepository dtoValueConverters = Adapters.adaptersRepository();
    private Registry dslRegistry = Registries.registry((ExtensibleBeanFactory)this.beanFactory);
    private DTOEventListener onDtoAssembly;
    private DTOEventListener onEntityAssembly;
    private DTOEventListener onDtoAssembled;
    private DTOEventListener onDtoFailed;
    private DTOEventListener onEntityAssembled;
    private DTOEventListener onEntityFailed;
    private final Map<Integer, Boolean> isClassAnnotatedCache = new ConcurrentHashMap<Integer, Boolean>();

    public void setBeanFactory(ExtensibleBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.dslRegistry = Registries.registry((ExtensibleBeanFactory)beanFactory);
    }

    public void setAdaptersRegistrar(DTOAdaptersRegistrar adaptersRegistrar) {
        this.adaptersRegistrar = adaptersRegistrar;
    }

    public void setDslRegistrar(DTODSLRegistrar dslRegistrar) {
        this.dslRegistrar = dslRegistrar;
    }

    public void afterPropertiesSet() throws Exception {
        this.registerCoreAdapters();
        this.registerDSLMappings();
    }

    protected void registerDSLMappings() {
        if (this.dslRegistrar != null) {
            this.dslRegistrar.registerMappings(this, this.dslRegistry);
        }
    }

    protected void registerCoreAdapters() {
        if (this.adaptersRegistrar != null) {
            this.adaptersRegistrar.registerAdapters(this);
        }
    }

    @Override
    public <T> T assembleDto(T dto, Object entity, String context) {
        return this.assembleDto(null, dto, entity, context);
    }

    @Override
    public <T> T assembleDtoByKey(String dtoKey, Object entity, String context) {
        Object dto = this.beanFactory.get(dtoKey);
        if (dto == null) {
            throw new IllegalArgumentException("DTO factory has no class specified for key: " + dtoKey);
        }
        return (T)this.assembleDto(null, dto, entity, context);
    }

    @Override
    public <T> T assembleDto(String dtoFilter, T dto, Object entity, String context) {
        Class dtoClassFilter;
        if (dtoFilter == null) {
            dtoClassFilter = dto.getClass();
        } else {
            dtoClassFilter = this.beanFactory.getClazz(dtoFilter);
            if (dtoClassFilter == null) {
                throw new IllegalArgumentException("DTO factory has no class specified for key: " + dtoFilter);
            }
        }
        try {
            if (this.onDtoAssembly != null) {
                this.onDtoAssembly.onEvent(context, dto, entity);
            }
            if (this.isAnnotatedClass(dtoClassFilter).booleanValue()) {
                DTOAssembler.newAssembler((Class)dtoClassFilter, entity.getClass()).assembleDto(dto, entity, this.dtoValueConverters.getAll(), (BeanFactory)this.beanFactory);
            } else {
                DTOAssembler.newAssembler((Class)dtoClassFilter, entity.getClass(), (Registry)this.dslRegistry).assembleDto(dto, entity, this.dtoValueConverters.getAll(), (BeanFactory)this.beanFactory);
            }
            if (this.onDtoAssembled != null) {
                this.onDtoAssembled.onEvent(context, dto, entity);
            }
            return dto;
        }
        catch (RuntimeException re) {
            if (this.onDtoFailed != null) {
                this.onDtoFailed.onEvent(context, dto, entity, re);
                LOG.error("Exception skipped by event listener", (Throwable)re);
                return null;
            }
            throw re;
        }
    }

    @Override
    public <T> T assembleDtoByKey(String dtoFilter, String dtoKey, Object entity, String context) {
        Object dto = this.beanFactory.get(dtoKey);
        if (dto == null) {
            throw new IllegalArgumentException("DTO factory has no class specified for key: " + dtoKey);
        }
        return (T)this.assembleDto(dtoFilter, dto, entity, context);
    }

    @Override
    public <T> void assembleDtos(String keyDto, Collection<T> dtos, Collection entities, String context) {
        this.assembleDtos(null, keyDto, dtos, entities, context);
    }

    @Override
    public <T> void assembleDtos(String dtoFilter, String keyDto, Collection<T> dtos, Collection entities, String context) {
        if (!CollectionUtils.isEmpty((Collection)entities)) {
            Class dtoClassFilter;
            if (dtoFilter == null) {
                dtoClassFilter = this.beanFactory.getClazz(keyDto);
                if (dtoClassFilter == null) {
                    throw new IllegalArgumentException("DTO factory has no class specified for key: " + keyDto);
                }
            } else {
                dtoClassFilter = this.beanFactory.getClazz(dtoFilter);
                if (dtoClassFilter == null) {
                    throw new IllegalArgumentException("DTO factory has no class specified for key: " + dtoFilter);
                }
            }
            Class<?> entityClass = entities.iterator().next().getClass();
            Assembler asm = this.isAnnotatedClass(dtoClassFilter) != false ? DTOAssembler.newAssembler((Class)dtoClassFilter, entityClass) : DTOAssembler.newAssembler((Class)dtoClassFilter, entityClass, (Registry)this.dslRegistry);
            for (Object entity : entities) {
                Object dto = this.beanFactory.get(keyDto);
                if (dto == null) {
                    throw new IllegalArgumentException("DTO factory has no class specified for key: " + keyDto);
                }
                try {
                    if (this.onDtoAssembly != null) {
                        this.onDtoAssembly.onEvent(context, dto, entity);
                    }
                    asm.assembleDto(dto, entity, this.dtoValueConverters.getAll(), (BeanFactory)this.beanFactory);
                    dtos.add(dto);
                    if (this.onDtoAssembled == null) continue;
                    this.onDtoAssembled.onEvent(context, dto, entity);
                }
                catch (RuntimeException re) {
                    if (this.onDtoFailed != null) {
                        this.onDtoFailed.onEvent(context, dto, entity, re);
                        LOG.error("Exception skipped by event listener", (Throwable)re);
                        continue;
                    }
                    throw re;
                }
            }
        }
    }

    @Override
    public <T> T assembleEntity(Object dto, T entity, String context) {
        return this.assembleEntity(null, dto, entity, context);
    }

    @Override
    public <T> T assembleEntityByKey(Object dto, String entityKey, String context) {
        Object entity = this.beanFactory.get(entityKey);
        if (entity == null) {
            throw new IllegalArgumentException("DTO factory has no class specified for key: " + entityKey);
        }
        return (T)this.assembleEntity(null, dto, entity, context);
    }

    @Override
    public <T> T assembleEntityByKey(String dtoFilter, Object dto, String entityKey, String context) {
        Object entity = this.beanFactory.get(entityKey);
        if (entity == null) {
            throw new IllegalArgumentException("DTO factory has no class specified for key: " + entityKey);
        }
        return (T)this.assembleEntity(dtoFilter, dto, entity, context);
    }

    @Override
    public <T> T assembleEntity(String dtoFilter, Object dto, T entity, String context) {
        Class dtoClassFilter;
        if (dtoFilter == null) {
            dtoClassFilter = dto.getClass();
        } else {
            dtoClassFilter = this.beanFactory.getClazz(dtoFilter);
            if (dtoClassFilter == null) {
                throw new IllegalArgumentException("DTO factory has no class specified for key: " + dtoFilter);
            }
        }
        try {
            if (this.onEntityAssembly != null) {
                this.onEntityAssembly.onEvent(context, dto, entity);
            }
            if (this.isAnnotatedClass(dtoClassFilter).booleanValue()) {
                DTOAssembler.newAssembler((Class)dtoClassFilter, entity.getClass()).assembleEntity(dto, entity, this.dtoValueConverters.getAll(), (BeanFactory)this.beanFactory);
            } else {
                DTOAssembler.newAssembler((Class)dtoClassFilter, entity.getClass(), (Registry)this.dslRegistry).assembleEntity(dto, entity, this.dtoValueConverters.getAll(), (BeanFactory)this.beanFactory);
            }
            if (this.onEntityAssembled != null) {
                this.onEntityAssembled.onEvent(context, dto, entity);
            }
            return entity;
        }
        catch (RuntimeException re) {
            if (this.onEntityFailed != null) {
                this.onEntityFailed.onEvent(context, dto, entity, re);
                LOG.error("Exception skipped by event listener", (Throwable)re);
                return null;
            }
            throw re;
        }
    }

    @Override
    public <T> void assembleEntities(String entityKey, Collection dtos, Collection<T> entities, String context) {
        this.assembleEntities(null, entityKey, dtos, entities, context);
    }

    @Override
    public <T> void assembleEntities(String dtoFilter, String entityKey, Collection dtos, Collection<T> entities, String context) {
        if (!CollectionUtils.isEmpty((Collection)dtos)) {
            Class dtoClassFilter;
            if (dtoFilter == null) {
                dtoClassFilter = dtos.iterator().next().getClass();
            } else {
                dtoClassFilter = this.beanFactory.getClazz(dtoFilter);
                if (dtoClassFilter == null) {
                    throw new IllegalArgumentException("DTO factory has no class specified for key: " + dtoFilter);
                }
            }
            Class entityClass = this.beanFactory.getClazz(entityKey);
            if (entityClass == null) {
                throw new IllegalArgumentException("DTO factory has no class specified for key: " + entityKey);
            }
            Assembler asm = this.isAnnotatedClass(dtoClassFilter) != false ? DTOAssembler.newAssembler((Class)dtoClassFilter, (Class)entityClass) : DTOAssembler.newAssembler((Class)dtoClassFilter, (Class)entityClass, (Registry)this.dslRegistry);
            for (Object dto : dtos) {
                Object entity = this.beanFactory.get(entityKey);
                if (entity == null) {
                    throw new IllegalArgumentException("DTO factory has no class specified for key: " + entityKey);
                }
                try {
                    if (this.onEntityAssembly != null) {
                        this.onEntityAssembly.onEvent(context, dto, entity);
                    }
                    asm.assembleEntity(dto, entity, this.dtoValueConverters.getAll(), (BeanFactory)this.beanFactory);
                    entities.add(entity);
                    if (this.onEntityAssembled == null) continue;
                    this.onEntityAssembled.onEvent(context, dto, entity);
                }
                catch (RuntimeException re) {
                    if (this.onEntityFailed != null) {
                        this.onEntityFailed.onEvent(context, dto, entity, re);
                        LOG.error("Exception skipped by event listener", (Throwable)re);
                        continue;
                    }
                    throw re;
                }
            }
        }
    }

    @Override
    public void registerAdapter(String key, Object converter) {
        LOG.debug("Registering [{}] with key [{}]", converter, (Object)key);
        this.dtoValueConverters.registerAdapter(key, converter);
    }

    public void setOnDtoAssembled(DTOEventListener onDtoAssembled) {
        this.onDtoAssembled = onDtoAssembled;
    }

    public void setOnDtoFailed(DTOEventListener onDtoFailed) {
        this.onDtoFailed = onDtoFailed;
    }

    public void setOnEntityAssembled(DTOEventListener onEntityAssembled) {
        this.onEntityAssembled = onEntityAssembled;
    }

    public void setOnEntityFailed(DTOEventListener onEntityFailed) {
        this.onEntityFailed = onEntityFailed;
    }

    public void setOnDtoAssembly(DTOEventListener onDtoAssembly) {
        this.onDtoAssembly = onDtoAssembly;
    }

    public void setOnEntityAssembly(DTOEventListener onEntityAssembly) {
        this.onEntityAssembly = onEntityAssembly;
    }

    private Boolean isAnnotatedClass(Class clazz) {
        Boolean isAnn;
        Integer classHash = clazz.hashCode();
        if (this.isClassAnnotatedCache.containsKey(classHash)) {
            isAnn = this.isClassAnnotatedCache.get(classHash);
        } else {
            isAnn = clazz.getAnnotation(Dto.class) != null;
            this.isClassAnnotatedCache.put(classHash, isAnn);
        }
        return isAnn;
    }
}

