/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.interceptor;

import com.inspiresoftware.lib.dto.geda.DTOSupport;
import com.inspiresoftware.lib.dto.geda.annotations.Occurrence;
import com.inspiresoftware.lib.dto.geda.config.GeDAInfrastructure;
import com.inspiresoftware.lib.dto.geda.interceptor.AdviceConfig;
import com.inspiresoftware.lib.dto.geda.interceptor.AdviceConfigResolver;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GeDAInterceptor
implements MethodInterceptor,
GeDAInfrastructure {
    private static final Logger LOG = LoggerFactory.getLogger(GeDAInterceptor.class);
    private DTOSupport support;
    private AdviceConfigResolver resolver;

    public void setSupport(DTOSupport support) {
        this.support = support;
    }

    public void setResolver(AdviceConfigResolver resolver) {
        this.resolver = resolver;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> targetClass;
        Method method = invocation.getMethod();
        Map<Occurrence, AdviceConfig> cfg = this.resolver.resolve(method, targetClass = invocation.getThis() != null ? invocation.getThis().getClass() : null);
        if (CollectionUtils.isEmpty(cfg)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skipping method {} because it is not advised", (Object)invocation.getMethod());
            }
            return invocation.proceed();
        }
        Object[] args = invocation.getArguments();
        if (cfg.containsKey((Object)Occurrence.BEFORE_METHOD_INVOCATION)) {
            AdviceConfig configuration = cfg.get((Object)Occurrence.BEFORE_METHOD_INVOCATION);
            if (LOG.isDebugEnabled()) {
                LOG.debug("performing transfer in mode {} before invocation of {} ", (Object)configuration.getDtoSupportMode().name(), (Object)invocation.getMethod());
            }
            this.invokeTransferBefore(args, configuration);
        }
        Object result = invocation.proceed();
        if (cfg.containsKey((Object)Occurrence.AFTER_METHOD_INVOCATION)) {
            AdviceConfig configuration = cfg.get((Object)Occurrence.AFTER_METHOD_INVOCATION);
            if (LOG.isDebugEnabled()) {
                LOG.debug("performing transfer in mode {} after invocation of {}", (Object)configuration.getDtoSupportMode().name(), (Object)invocation.getMethod());
            }
            return this.invokeTransferAfter(args, result, configuration);
        }
        return result;
    }

    protected void invokeTransferBefore(Object[] args, AdviceConfig cfg) {
        AdviceConfig.DTOSupportMode mode = cfg.getDtoSupportMode();
        switch (mode) {
            case DTO_TO_ENTITY: {
                this.support.assembleEntity(args[cfg.getDtoSourceIndex()], args[cfg.getEntityTargetIndex()], cfg.getContext());
                break;
            }
            case DTO_TO_ENTITY_KEY: {
                this.support.assembleEntityByKey(args[cfg.getDtoSourceIndex()], cfg.getEntityKey(), cfg.getContext());
                break;
            }
            case DTO_BY_FILTER_TO_ENTITY: {
                this.support.assembleEntity(cfg.getDtoFilterKey(), args[cfg.getDtoSourceIndex()], args[cfg.getEntityTargetIndex()], cfg.getContext());
                break;
            }
            case DTO_BY_FILTER_TO_ENTITY_KEY: {
                this.support.assembleEntityByKey(cfg.getDtoFilterKey(), args[cfg.getDtoSourceIndex()], cfg.getEntityKey(), cfg.getContext());
                break;
            }
            case DTOS_TO_ENTITIES: {
                this.support.assembleEntities(cfg.getEntityKey(), (Collection)args[cfg.getDtoSourceIndex()], (Collection)args[cfg.getEntityTargetIndex()], cfg.getContext());
                break;
            }
            case DTOS_TO_ENTITIES_BY_FILTER: {
                this.support.assembleEntities(cfg.getDtoFilterKey(), cfg.getEntityKey(), (Collection)args[cfg.getDtoSourceIndex()], (Collection)args[cfg.getEntityTargetIndex()], cfg.getContext());
                break;
            }
            case ENTITY_TO_DTO: {
                this.support.assembleDto(args[cfg.getDtoTargetIndex()], args[cfg.getEntitySourceIndex()], cfg.getContext());
                break;
            }
            case ENTITY_TO_DTO_KEY: {
                this.support.assembleDtoByKey(cfg.getDtoKey(), args[cfg.getEntitySourceIndex()], cfg.getContext());
                break;
            }
            case ENTITY_TO_DTO_BY_FILTER: {
                this.support.assembleDto(cfg.getDtoFilterKey(), args[cfg.getDtoTargetIndex()], args[cfg.getEntitySourceIndex()], cfg.getContext());
                break;
            }
            case ENTITY_TO_DTO_KEY_BY_FILTER: {
                this.support.assembleDtoByKey(cfg.getDtoFilterKey(), cfg.getDtoKey(), args[cfg.getEntitySourceIndex()], cfg.getContext());
                break;
            }
            case ENTITIES_TO_DTOS: {
                this.support.assembleDtos(cfg.getDtoKey(), (Collection)args[cfg.getDtoTargetIndex()], (Collection)args[cfg.getEntitySourceIndex()], cfg.getContext());
                break;
            }
            case ENTITIES_TO_DTOS_BY_FILTER: {
                this.support.assembleDtos(cfg.getDtoFilterKey(), cfg.getDtoKey(), (Collection)args[cfg.getDtoTargetIndex()], (Collection)args[cfg.getEntitySourceIndex()], cfg.getContext());
                break;
            }
            default: {
                LOG.warn("Unknown support mode [{}]", (Object)cfg);
            }
        }
    }

    protected Object invokeTransferAfter(Object[] args, Object result, AdviceConfig cfg) {
        AdviceConfig.DTOSupportMode mode = cfg.getDtoSupportMode();
        switch (mode) {
            case DTO_TO_ENTITY: {
                if (cfg.getEntityTargetIndex() == -1) {
                    return this.support.assembleEntity(args[cfg.getDtoSourceIndex()], result, cfg.getContext());
                }
                this.support.assembleEntity(args[cfg.getDtoSourceIndex()], args[cfg.getEntityTargetIndex()], cfg.getContext());
                return result;
            }
            case DTO_TO_ENTITY_KEY: {
                return this.support.assembleEntityByKey(args[cfg.getDtoSourceIndex()], cfg.getEntityKey(), cfg.getContext());
            }
            case DTO_BY_FILTER_TO_ENTITY: {
                if (cfg.getEntityTargetIndex() == -1) {
                    return this.support.assembleEntity(cfg.getDtoFilterKey(), args[cfg.getDtoSourceIndex()], result, cfg.getContext());
                }
                this.support.assembleEntity(cfg.getDtoFilterKey(), args[cfg.getDtoSourceIndex()], args[cfg.getEntityTargetIndex()], cfg.getContext());
                return result;
            }
            case DTO_BY_FILTER_TO_ENTITY_KEY: {
                return this.support.assembleEntityByKey(cfg.getDtoFilterKey(), args[cfg.getDtoSourceIndex()], cfg.getEntityKey(), cfg.getContext());
            }
            case DTOS_TO_ENTITIES: {
                this.support.assembleEntities(cfg.getEntityKey(), (Collection)args[cfg.getDtoSourceIndex()], (Collection)args[cfg.getEntityTargetIndex()], cfg.getContext());
                return result;
            }
            case DTOS_TO_ENTITIES_BY_FILTER: {
                this.support.assembleEntities(cfg.getDtoFilterKey(), cfg.getEntityKey(), (Collection)args[cfg.getDtoSourceIndex()], (Collection)args[cfg.getEntityTargetIndex()], cfg.getContext());
                return result;
            }
            case ENTITY_TO_DTO: {
                if (cfg.getDtoTargetIndex() == -1) {
                    return this.support.assembleDto(result, args[cfg.getEntitySourceIndex()], cfg.getContext());
                }
                this.support.assembleDto(args[cfg.getDtoTargetIndex()], args[cfg.getEntitySourceIndex()], cfg.getContext());
                return result;
            }
            case ENTITY_TO_DTO_KEY: {
                return this.support.assembleDtoByKey(cfg.getDtoKey(), args[cfg.getEntitySourceIndex()], cfg.getContext());
            }
            case ENTITY_TO_DTO_BY_FILTER: {
                if (cfg.getDtoTargetIndex() == -1) {
                    return this.support.assembleDto(cfg.getDtoFilterKey(), result, args[cfg.getEntitySourceIndex()], cfg.getContext());
                }
                this.support.assembleDto(cfg.getDtoFilterKey(), args[cfg.getDtoTargetIndex()], args[cfg.getEntitySourceIndex()], cfg.getContext());
                return result;
            }
            case ENTITY_TO_DTO_KEY_BY_FILTER: {
                return this.support.assembleDtoByKey(cfg.getDtoFilterKey(), cfg.getDtoKey(), args[cfg.getEntitySourceIndex()], cfg.getContext());
            }
            case ENTITIES_TO_DTOS: {
                this.support.assembleDtos(cfg.getDtoKey(), (Collection)args[cfg.getDtoTargetIndex()], (Collection)args[cfg.getEntitySourceIndex()], cfg.getContext());
                return result;
            }
            case ENTITIES_TO_DTOS_BY_FILTER: {
                this.support.assembleDtos(cfg.getDtoFilterKey(), cfg.getDtoKey(), (Collection)args[cfg.getDtoTargetIndex()], (Collection)args[cfg.getEntitySourceIndex()], cfg.getContext());
                return result;
            }
        }
        LOG.warn("Unknown support mode [{}]", (Object)cfg);
        return result;
    }
}

