/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.interceptor.impl;

import com.inspiresoftware.lib.dto.geda.annotations.Occurrence;
import com.inspiresoftware.lib.dto.geda.interceptor.AdviceConfig;
import com.inspiresoftware.lib.dto.geda.interceptor.AdviceConfigRepository;
import com.inspiresoftware.lib.dto.geda.interceptor.impl.TransferableUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdviceConfigRepositoryImpl
implements AdviceConfigRepository {
    private static final Logger LOG = LoggerFactory.getLogger(AdviceConfigRepositoryImpl.class);
    private final Map<String, Map<Integer, Map<Occurrence, AdviceConfig>>> cache = new ConcurrentHashMap<String, Map<Integer, Map<Occurrence, AdviceConfig>>>();

    @Override
    public void addApplicableMethods(Object bean) {
        Method[] methods;
        for (Method method : methods = bean.getClass().getMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            this.addMethodIfApplicable(method, bean.getClass());
        }
    }

    public void addMethodIfApplicable(Method method, Class<?> targetClass) {
        Integer key;
        Map<Integer, Map<Occurrence, AdviceConfig>> cMap = this.getAdvisableMethodsConfigurations(targetClass);
        if (cMap.isEmpty()) {
            cMap = new ConcurrentHashMap<Integer, Map<Occurrence, AdviceConfig>>();
            this.cache.put(targetClass.getCanonicalName(), cMap);
        }
        if (!cMap.containsKey(key = this.methodCacheKey(method, targetClass))) {
            Map<Occurrence, AdviceConfig> methodCfg = this.resolveConfiguration(method, targetClass);
            if (methodCfg.isEmpty()) {
                return;
            }
            cMap.put(key, methodCfg);
            if (LOG.isInfoEnabled()) {
                int methCount = 0;
                for (Map<Integer, Map<Occurrence, AdviceConfig>> meths : this.cache.values()) {
                    methCount += meths.size();
                }
                LOG.info("Added GeDA configuration for method: {}.{}[p={}]... {} total mappings so far", new Object[]{targetClass.getCanonicalName(), method.getName(), method.getParameterTypes().length, methCount});
            }
        }
    }

    Map<Occurrence, AdviceConfig> resolveConfiguration(Method method, Class<?> targetClass) {
        return TransferableUtils.resolveConfiguration(method, targetClass);
    }

    @Override
    public Map<Integer, Map<Occurrence, AdviceConfig>> getAdvisableMethodsConfigurations(Class<?> targetClass) {
        if (targetClass == null) {
            return Collections.emptyMap();
        }
        Map<Integer, Map<Occurrence, AdviceConfig>> cMap = this.cache.get(targetClass.getCanonicalName());
        if (cMap == null) {
            return Collections.emptyMap();
        }
        return cMap;
    }

    @Override
    public Integer methodCacheKey(Method method, Class<?> targetClass) {
        StringBuilder signature = new StringBuilder(method.getName()).append('(');
        Class<?>[] args = method.getParameterTypes();
        if (args.length > 0) {
            for (Class<?> arg : args) {
                signature.append(arg.getCanonicalName()).append(',');
            }
            signature.deleteCharAt(signature.length() - 1);
        }
        signature.append(')');
        return signature.toString().hashCode();
    }
}

