/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.interceptor.impl;

import com.inspiresoftware.lib.dto.geda.annotations.Occurrence;
import com.inspiresoftware.lib.dto.geda.interceptor.AdviceConfig;
import com.inspiresoftware.lib.dto.geda.interceptor.AdviceConfigResolver;
import com.inspiresoftware.lib.dto.geda.interceptor.impl.TransferableUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeAdviceConfigResolverImpl
implements AdviceConfigResolver {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeAdviceConfigResolverImpl.class);
    private final Map<Integer, Boolean> blacklist = new ConcurrentHashMap<Integer, Boolean>();
    private final Map<Integer, Map<Occurrence, AdviceConfig>> cache = new ConcurrentHashMap<Integer, Map<Occurrence, AdviceConfig>>();

    @Override
    public Map<Occurrence, AdviceConfig> resolve(Method method, Class<?> targetClass) {
        Integer methodCacheKey = this.methodCacheKey(method, targetClass);
        if (this.isBlacklisted(methodCacheKey)) {
            return Collections.emptyMap();
        }
        if (this.isCached(methodCacheKey)) {
            return this.cache.get(methodCacheKey);
        }
        Map<Occurrence, AdviceConfig> cfg = this.resolveConfiguration(method, targetClass);
        if (cfg.isEmpty()) {
            this.blacklist.put(methodCacheKey, Boolean.TRUE);
        } else {
            this.cache.put(methodCacheKey, cfg);
            if (LOG.isInfoEnabled()) {
                LOG.info("Added GeDA configuration for method: {}.{}[p={}]... {} total mappings so far", new Object[]{targetClass == null ? method.getDeclaringClass().getCanonicalName() : targetClass.getCanonicalName(), method.getName(), method.getParameterTypes().length, this.cache.size()});
            }
        }
        return cfg;
    }

    boolean isCached(Integer methodCacheKey) {
        return this.cache.containsKey(methodCacheKey);
    }

    boolean isBlacklisted(Integer methodCacheKey) {
        return this.blacklist.containsKey(methodCacheKey);
    }

    Map<Occurrence, AdviceConfig> resolveConfiguration(Method method, Class<?> targetClass) {
        return TransferableUtils.resolveConfiguration(method, targetClass);
    }

    Integer methodCacheKey(Method method, Class<?> targetClass) {
        int hashKey = targetClass != null ? targetClass.getCanonicalName().hashCode() : method.getDeclaringClass().getCanonicalName().hashCode();
        hashKey = 31 * hashKey + method.getName().hashCode();
        Class<?>[] args = method.getParameterTypes();
        if (args.length > 0) {
            for (Class<?> arg : args) {
                hashKey = 31 * hashKey + arg.hashCode();
            }
        }
        return hashKey;
    }
}

