/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.interceptor.impl;

import com.inspiresoftware.lib.dto.geda.adapter.Adapter;
import com.inspiresoftware.lib.dto.geda.annotations.Direction;
import com.inspiresoftware.lib.dto.geda.annotations.Occurrence;
import com.inspiresoftware.lib.dto.geda.annotations.Transferable;
import com.inspiresoftware.lib.dto.geda.config.GeDAInfrastructure;
import com.inspiresoftware.lib.dto.geda.interceptor.AdviceConfig;
import com.inspiresoftware.lib.dto.geda.interceptor.impl.ImmutableAdviceConfig;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransferableUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TransferableUtils.class);
    static int NO_INDEX = Integer.MAX_VALUE;
    static int RETURN_INDEX = -1;

    public static Map<Occurrence, AdviceConfig> resolveConfiguration(Method method, Class<?> targetClass) {
        if (GeDAInfrastructure.class.isAssignableFrom(targetClass) || Adapter.class.isAssignableFrom(targetClass)) {
            return Collections.emptyMap();
        }
        return TransferableUtils.resolveConfiguration(method, targetClass, true);
    }

    private static Map<Occurrence, AdviceConfig> resolveConfiguration(Method method, Class<?> targetClass, boolean trySpecific) {
        Method specificMethod = method;
        Transferable annotation = specificMethod.getAnnotation(Transferable.class);
        if (annotation == null && trySpecific) {
            specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
            annotation = specificMethod.getAnnotation(Transferable.class);
        }
        if (annotation == null) {
            return Collections.emptyMap();
        }
        HashMap<Occurrence, AdviceConfig> cfg = new HashMap<Occurrence, AdviceConfig>();
        TransferableUtils.resolveConfiguration(cfg, specificMethod.getName(), specificMethod.getParameterTypes(), specificMethod.getReturnType(), annotation);
        return cfg;
    }

    private static void resolveConfiguration(Map<Occurrence, AdviceConfig> cfg, String method, Class[] args, Class retArg, Transferable ann) {
        if (ann.before() == Direction.NONE && ann.after() == Direction.NONE) {
            LOG.warn("Both before and after are set to NONE on method: {}. No transfer shall be performed.", (Object)method);
            return;
        }
        if (ann.before() == Direction.NONE) {
            TransferableUtils.resolveConfigurationAfter(cfg, method, args, retArg, ann);
        } else if (ann.after() == Direction.NONE) {
            TransferableUtils.resolveConfigurationBefore(cfg, method, args, retArg, ann);
        } else {
            TransferableUtils.resolveConfigurationAround(cfg, method, args, retArg, ann);
        }
    }

    private static void resolveConfigurationBefore(Map<Occurrence, AdviceConfig> cfg, String method, Class[] args, Class retArg, Transferable ann) {
        if (args.length >= 2) {
            if (ann.before() == Direction.DTO_TO_ENTITY) {
                boolean filtered = StringUtils.hasLength((String)ann.dtoFilterKey());
                boolean firstArgIsCollection = TransferableUtils.argIsCollection(args[0]);
                boolean secondArgIsCollection = TransferableUtils.argIsCollection(args[1]);
                if (filtered) {
                    if (firstArgIsCollection && secondArgIsCollection) {
                        TransferableUtils.assertKey(method, ann.entityKey(), false);
                        TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), ann.dtoFilterKey(), "", ann.entityKey(), AdviceConfig.DTOSupportMode.DTOS_TO_ENTITIES_BY_FILTER, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                        return;
                    }
                    if (!firstArgIsCollection && !secondArgIsCollection) {
                        TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), ann.dtoFilterKey(), "", "", AdviceConfig.DTOSupportMode.DTO_BY_FILTER_TO_ENTITY, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                        return;
                    }
                } else {
                    if (firstArgIsCollection && secondArgIsCollection) {
                        TransferableUtils.assertKey(method, ann.entityKey(), false);
                        TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), "", "", ann.entityKey(), AdviceConfig.DTOSupportMode.DTOS_TO_ENTITIES, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                        return;
                    }
                    if (!firstArgIsCollection && !secondArgIsCollection) {
                        TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), "", "", "", AdviceConfig.DTOSupportMode.DTO_TO_ENTITY, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                        return;
                    }
                }
            } else if (ann.before() == Direction.ENTITY_TO_DTO) {
                boolean filtered = StringUtils.hasLength((String)ann.dtoFilterKey());
                boolean firstArgIsCollection = TransferableUtils.argIsCollection(args[0]);
                boolean secondArgIsCollection = TransferableUtils.argIsCollection(args[1]);
                if (filtered) {
                    if (firstArgIsCollection && secondArgIsCollection) {
                        TransferableUtils.assertKey(method, ann.dtoKey(), true);
                        TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), ann.dtoFilterKey(), ann.dtoKey(), "", AdviceConfig.DTOSupportMode.ENTITIES_TO_DTOS_BY_FILTER, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                        return;
                    }
                    if (!firstArgIsCollection && !secondArgIsCollection) {
                        TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), ann.dtoFilterKey(), "", "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_BY_FILTER, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                        return;
                    }
                } else {
                    if (firstArgIsCollection && secondArgIsCollection) {
                        TransferableUtils.assertKey(method, ann.dtoKey(), true);
                        TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), "", ann.dtoKey(), "", AdviceConfig.DTOSupportMode.ENTITIES_TO_DTOS, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                        return;
                    }
                    if (!firstArgIsCollection && !secondArgIsCollection) {
                        TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), "", "", "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                        return;
                    }
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported configuration see @Transferable.");
    }

    private static void resolveConfigurationAfter(Map<Occurrence, AdviceConfig> cfg, String method, Class[] args, Class retArg, Transferable ann) {
        if (args.length >= 1) {
            if (ann.after() == Direction.ENTITY_TO_DTO) {
                boolean filtered = StringUtils.hasLength((String)ann.dtoFilterKey());
                if (filtered) {
                    boolean firstArgIsCollection = TransferableUtils.argIsCollection(args[0]);
                    boolean returnIsVoid = TransferableUtils.isReturnVoid(retArg);
                    if (firstArgIsCollection || args.length >= 2) {
                        boolean secondArgIsCollection = TransferableUtils.argIsCollection(args[1]);
                        if (firstArgIsCollection && secondArgIsCollection) {
                            TransferableUtils.assertKey(method, ann.dtoKey(), true);
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), ann.dtoKey(), "", AdviceConfig.DTOSupportMode.ENTITIES_TO_DTOS_BY_FILTER, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                            return;
                        }
                        if (!firstArgIsCollection && !returnIsVoid) {
                            TransferableUtils.assertKey(method, ann.dtoKey(), true);
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), ann.dtoKey(), "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_KEY_BY_FILTER, NO_INDEX, RETURN_INDEX, 0, NO_INDEX, ann.context());
                            return;
                        }
                        if (!firstArgIsCollection && !secondArgIsCollection) {
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), "", "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_BY_FILTER, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                            return;
                        }
                    } else if (args.length == 1 && !returnIsVoid) {
                        TransferableUtils.assertKey(method, ann.dtoKey(), true);
                        TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), ann.dtoKey(), "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_KEY_BY_FILTER, NO_INDEX, RETURN_INDEX, 0, NO_INDEX, ann.context());
                        return;
                    }
                } else {
                    boolean firstArgIsCollection = TransferableUtils.argIsCollection(args[0]);
                    boolean returnIsVoid = TransferableUtils.isReturnVoid(retArg);
                    if (firstArgIsCollection || args.length >= 2) {
                        boolean secondArgIsCollection = TransferableUtils.argIsCollection(args[1]);
                        if (firstArgIsCollection && secondArgIsCollection) {
                            TransferableUtils.assertKey(method, ann.dtoKey(), true);
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", ann.dtoKey(), "", AdviceConfig.DTOSupportMode.ENTITIES_TO_DTOS, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                            return;
                        }
                        if (!firstArgIsCollection && !returnIsVoid) {
                            TransferableUtils.assertKey(method, ann.dtoKey(), true);
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", ann.dtoKey(), "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_KEY, NO_INDEX, RETURN_INDEX, 0, NO_INDEX, ann.context());
                            return;
                        }
                        if (!firstArgIsCollection && !secondArgIsCollection) {
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", "", "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                            return;
                        }
                    } else if (args.length == 1 && !returnIsVoid) {
                        TransferableUtils.assertKey(method, ann.dtoKey(), true);
                        TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", ann.dtoKey(), "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_KEY, NO_INDEX, RETURN_INDEX, 0, NO_INDEX, ann.context());
                        return;
                    }
                }
            } else if (ann.after() == Direction.DTO_TO_ENTITY) {
                boolean filtered = StringUtils.hasLength((String)ann.dtoFilterKey());
                boolean returnIsVoid = TransferableUtils.isReturnVoid(retArg);
                if (filtered) {
                    boolean firstArgIsCollection = TransferableUtils.argIsCollection(args[0]);
                    if (firstArgIsCollection || args.length >= 2) {
                        boolean secondArgIsCollection = TransferableUtils.argIsCollection(args[1]);
                        if (firstArgIsCollection && secondArgIsCollection) {
                            TransferableUtils.assertKey(method, ann.entityKey(), false);
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), "", ann.entityKey(), AdviceConfig.DTOSupportMode.DTOS_TO_ENTITIES_BY_FILTER, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                            return;
                        }
                        if (!firstArgIsCollection && !returnIsVoid) {
                            TransferableUtils.assertKey(method, ann.entityKey(), false);
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), "", ann.entityKey(), AdviceConfig.DTOSupportMode.DTO_BY_FILTER_TO_ENTITY_KEY, 0, NO_INDEX, NO_INDEX, RETURN_INDEX, ann.context());
                            return;
                        }
                        if (!firstArgIsCollection && !secondArgIsCollection) {
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), "", "", AdviceConfig.DTOSupportMode.DTO_BY_FILTER_TO_ENTITY, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                            return;
                        }
                    } else if (args.length == 1 && !returnIsVoid) {
                        TransferableUtils.assertKey(method, ann.entityKey(), false);
                        TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), "", ann.entityKey(), AdviceConfig.DTOSupportMode.DTO_BY_FILTER_TO_ENTITY_KEY, 0, NO_INDEX, NO_INDEX, RETURN_INDEX, ann.context());
                        return;
                    }
                } else {
                    boolean firstArgIsCollection = TransferableUtils.argIsCollection(args[0]);
                    if (firstArgIsCollection || args.length >= 2) {
                        boolean secondArgIsCollection = TransferableUtils.argIsCollection(args[1]);
                        if (firstArgIsCollection && secondArgIsCollection) {
                            TransferableUtils.assertKey(method, ann.entityKey(), false);
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", "", ann.entityKey(), AdviceConfig.DTOSupportMode.DTOS_TO_ENTITIES, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                            return;
                        }
                        if (!firstArgIsCollection && !returnIsVoid) {
                            TransferableUtils.assertKey(method, ann.entityKey(), false);
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", "", ann.entityKey(), AdviceConfig.DTOSupportMode.DTO_TO_ENTITY_KEY, 0, NO_INDEX, NO_INDEX, RETURN_INDEX, ann.context());
                            return;
                        }
                        if (!firstArgIsCollection && !secondArgIsCollection) {
                            TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", "", "", AdviceConfig.DTOSupportMode.DTO_TO_ENTITY, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                            return;
                        }
                    } else if (args.length == 1 && !returnIsVoid) {
                        TransferableUtils.assertKey(method, ann.entityKey(), false);
                        TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", "", ann.entityKey(), AdviceConfig.DTOSupportMode.DTO_TO_ENTITY_KEY, 0, NO_INDEX, NO_INDEX, RETURN_INDEX, ann.context());
                        return;
                    }
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported configuration see @Transferable.");
    }

    private static void resolveConfigurationAround(Map<Occurrence, AdviceConfig> cfg, String method, Class[] args, Class retArg, Transferable ann) {
        if (args.length >= 2) {
            boolean filtered = StringUtils.hasLength((String)ann.dtoFilterKey());
            boolean returnIsVoid = TransferableUtils.isReturnVoid(retArg);
            if (ann.before() == Direction.DTO_TO_ENTITY && ann.after() == Direction.ENTITY_TO_DTO) {
                if (filtered && args.length >= 2) {
                    if (returnIsVoid) {
                        TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), ann.dtoFilterKey(), "", "", AdviceConfig.DTOSupportMode.DTO_BY_FILTER_TO_ENTITY, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                        TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), "", "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_BY_FILTER, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                        return;
                    }
                    TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), ann.dtoFilterKey(), "", "", AdviceConfig.DTOSupportMode.DTO_BY_FILTER_TO_ENTITY, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                    TransferableUtils.assertKey(method, ann.dtoKey(), true);
                    TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), ann.dtoKey(), "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_KEY_BY_FILTER, NO_INDEX, RETURN_INDEX, 1, NO_INDEX, ann.context());
                    return;
                }
                if (returnIsVoid) {
                    TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), "", "", "", AdviceConfig.DTOSupportMode.DTO_TO_ENTITY, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                    TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", "", "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                    return;
                }
                TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), "", "", "", AdviceConfig.DTOSupportMode.DTO_TO_ENTITY, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                TransferableUtils.assertKey(method, ann.dtoKey(), true);
                TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", ann.dtoKey(), "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_KEY, NO_INDEX, RETURN_INDEX, 1, NO_INDEX, ann.context());
                return;
            }
            if (ann.before() == Direction.ENTITY_TO_DTO && ann.after() == Direction.DTO_TO_ENTITY) {
                if (filtered && args.length >= 2) {
                    if (returnIsVoid) {
                        TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), ann.dtoFilterKey(), "", "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_BY_FILTER, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                        TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), "", "", AdviceConfig.DTOSupportMode.DTO_BY_FILTER_TO_ENTITY, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                        return;
                    }
                    TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), ann.dtoFilterKey(), "", "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO_BY_FILTER, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                    TransferableUtils.assertKey(method, ann.entityKey(), false);
                    TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), ann.dtoFilterKey(), "", ann.entityKey(), AdviceConfig.DTOSupportMode.DTO_BY_FILTER_TO_ENTITY_KEY, 0, NO_INDEX, NO_INDEX, RETURN_INDEX, ann.context());
                    return;
                }
                if (returnIsVoid) {
                    TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), "", "", "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                    TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", "", "", AdviceConfig.DTOSupportMode.DTO_TO_ENTITY, 0, NO_INDEX, NO_INDEX, 1, ann.context());
                    return;
                }
                TransferableUtils.addConfiguration(cfg, Occurrence.BEFORE_METHOD_INVOCATION, ann.before(), "", "", "", AdviceConfig.DTOSupportMode.ENTITY_TO_DTO, NO_INDEX, 0, 1, NO_INDEX, ann.context());
                TransferableUtils.assertKey(method, ann.entityKey(), false);
                TransferableUtils.addConfiguration(cfg, Occurrence.AFTER_METHOD_INVOCATION, ann.after(), "", "", ann.entityKey(), AdviceConfig.DTOSupportMode.DTO_TO_ENTITY_KEY, 0, NO_INDEX, NO_INDEX, RETURN_INDEX, ann.context());
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported configuration see @Transferable.");
    }

    private static void addConfiguration(Map<Occurrence, AdviceConfig> cfg, Occurrence occur, Direction direction, String dtoFilterKey, String dtoKey, String entityKey, AdviceConfig.DTOSupportMode mode, int dtoSourceIndex, int dtoTargetIndex, int entitySourceIndex, int entityTargetIndex, String context) {
        ImmutableAdviceConfig bCfg = new ImmutableAdviceConfig(direction, occur, mode, dtoFilterKey, dtoKey, entityKey, dtoSourceIndex, dtoTargetIndex, entitySourceIndex, entityTargetIndex, context);
        cfg.put(occur, bCfg);
    }

    private static void assertKey(String method, String key, boolean isDto) {
        if (!StringUtils.hasLength((String)key)) {
            throw new IllegalArgumentException("Key must be specified for " + (isDto ? "DTO" : "Entity") + " in " + method);
        }
    }

    private static boolean argIsClass(Class arg) {
        return "java.lang.Class".equals(arg.getName());
    }

    private static boolean argIsCollection(Class arg) {
        return Collection.class.isAssignableFrom(arg);
    }

    private static boolean isReturnVoid(Class retArg) {
        return "void".equals(retArg.getName());
    }
}

