/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.component;

import com.intuit.fuzzymatcher.component.DocumentMatch;
import com.intuit.fuzzymatcher.domain.Document;
import com.intuit.fuzzymatcher.domain.Match;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;

public class MatchService {
    public Map<Document, List<Match<Document>>> applyMatch(List<Document> documents) {
        DocumentMatch documentMatch = new DocumentMatch();
        return documentMatch.matchDocuments(documents.stream()).collect(Collectors.groupingBy(Match::getData));
    }

    public Map<Document, List<Match<Document>>> applyMatch(List<Document> documents, List<Document> matchWith) {
        DocumentMatch documentMatch = new DocumentMatch();
        return documentMatch.matchDocuments(Stream.concat(matchWith.stream().map(document -> {
            document.setSource(false);
            return document;
        }), documents.stream().map(document -> {
            document.setSource(true);
            return document;
        }))).collect(Collectors.groupingBy(Match::getData));
    }

    public Map<Document, List<Match<Document>>> applyMatch(Document document, List<Document> matchWith) {
        DocumentMatch documentMatch = new DocumentMatch();
        return this.applyMatch(Arrays.asList(document), matchWith);
    }

    public Map<String, List<Match<Document>>> applyMatchByDocId(Document document, List<Document> matchWith) {
        DocumentMatch documentMatch = new DocumentMatch();
        return this.applyMatchByDocId(Arrays.asList(document), matchWith);
    }

    public Map<String, List<Match<Document>>> applyMatchByDocId(List<Document> documents) {
        DocumentMatch documentMatch = new DocumentMatch();
        return documentMatch.matchDocuments(documents.stream()).collect(Collectors.groupingBy(match -> ((Document)match.getData()).getKey()));
    }

    public Map<String, List<Match<Document>>> applyMatchByDocId(List<Document> documents, List<Document> matchWith) {
        DocumentMatch documentMatch = new DocumentMatch();
        return documentMatch.matchDocuments(Stream.concat(matchWith.stream().map(document -> {
            document.setSource(false);
            return document;
        }), documents.stream().map(document -> {
            document.setSource(true);
            return document;
        }))).collect(Collectors.groupingBy(match -> ((Document)match.getData()).getKey()));
    }

    public Set<Set<Match<Document>>> applyMatchByGroups(List<Document> documents) {
        DocumentMatch documentMatch = new DocumentMatch();
        Map<String, List<Match>> matchByKey = documentMatch.matchDocuments(documents.stream()).collect(Collectors.groupingBy(match -> ((Document)match.getData()).getKey()));
        HashSet<String> docKeys = new HashSet<String>(matchByKey.keySet());
        HashSet<Set<Match<Document>>> result = new HashSet<Set<Match<Document>>>();
        docKeys.forEach(key -> {
            HashSet<Match<Document>> matchGroups = new HashSet<Match<Document>>();
            this.groupSimilar((Map<String, List<Match<Document>>>)matchByKey, (String)key, (Set<Match<Document>>)matchGroups);
            if (CollectionUtils.isNotEmpty(matchGroups)) {
                result.add(matchGroups);
            }
        });
        return result;
    }

    private void groupSimilar(Map<String, List<Match<Document>>> matchMap, String key, Set<Match<Document>> matchGroups) {
        List<Match<Document>> matches = matchMap.get(key);
        if (matches == null) {
            return;
        }
        matchMap.remove(key);
        matches.forEach(match -> {
            if (!this.containsMatch(matchGroups, (Match<Document>)match)) {
                matchGroups.add((Match<Document>)match);
            }
            String matchedWithKey = ((Document)match.getMatchedWith()).getKey();
            this.groupSimilar(matchMap, matchedWithKey, matchGroups);
        });
    }

    private boolean containsMatch(Set<Match<Document>> matchGroups, Match<Document> match) {
        return matchGroups.stream().anyMatch(m -> ((Document)m.getData()).getKey().equals(((Document)match.getMatchedWith()).getKey()) && ((Document)m.getMatchedWith()).getKey().equals(((Document)match.getData()).getKey()));
    }
}

