/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.component;

import com.intuit.fuzzymatcher.domain.Element;
import com.intuit.fuzzymatcher.domain.ElementClassification;
import com.intuit.fuzzymatcher.domain.MatchType;
import com.intuit.fuzzymatcher.domain.Token;
import com.intuit.fuzzymatcher.exception.MatchException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class TokenRepo {
    private Map<ElementClassification, Repo> repoMap = new ConcurrentHashMap<ElementClassification, Repo>();

    public void put(Token token) {
        ElementClassification elementClassification = token.getElement().getElementClassification();
        Repo repo = this.repoMap.get(elementClassification);
        if (repo == null) {
            repo = new Repo(token.getElement().getMatchType());
            this.repoMap.put(elementClassification, repo);
        }
        repo.put(token, token.getElement());
    }

    public Set<Element> get(Token token) {
        Repo repo = this.repoMap.get(token.getElement().getElementClassification());
        if (repo != null) {
            return repo.get(token);
        }
        return null;
    }

    private class TokenRange {
        private final Object lower;
        private final Object higher;

        TokenRange(Token token, double pct, Double pctOf) {
            Object value = token.getValue();
            if (value instanceof Double) {
                this.lower = this.getLower((Double)value, pct, pctOf).doubleValue();
                this.higher = this.getHigher((Double)value, pct, pctOf).doubleValue();
            } else if (value instanceof Integer) {
                this.lower = this.getLower((Integer)value, pct, pctOf).intValue();
                this.higher = this.getHigher((Integer)value, pct, pctOf).intValue();
            } else if (value instanceof Long) {
                this.lower = this.getLower((Long)value, pct, pctOf).longValue();
                this.higher = this.getHigher((Long)value, pct, pctOf).longValue();
            } else if (value instanceof Float) {
                this.lower = Float.valueOf(this.getLower((Float)value, pct, pctOf).floatValue());
                this.higher = Float.valueOf(this.getHigher((Float)value, pct, pctOf).floatValue());
            } else if (value instanceof Date) {
                this.lower = new Date(this.getLower(((Date)value).getTime(), pct, pctOf).longValue());
                this.higher = new Date(this.getHigher(((Date)value).getTime(), pct, pctOf).longValue());
            } else {
                throw new MatchException("Data Type not supported");
            }
        }

        TokenRange(Token token, double pct) {
            this(token, pct, null);
        }

        private Number getLower(Number number, double pct, Double pctOf) {
            Double dnum = number.doubleValue();
            Double dPctOf = pctOf != null ? pctOf : dnum;
            Double pctVal = Math.abs(dPctOf * (1.0 - pct));
            return dnum - pctVal;
        }

        private Number getHigher(Number number, double pct, Double pctOf) {
            Double dnum = number.doubleValue();
            Double dPctOf = pctOf != null ? pctOf : dnum;
            Double pctVal = Math.abs(dPctOf * (1.0 - pct));
            return dnum + pctVal;
        }
    }

    private class Repo {
        MatchType matchType;
        Map<Object, Set<Element>> tokenElementSet;
        TreeSet<Object> tokenBinaryTree;
        private final Double AGE_PCT_OF = 10.0;
        private final Double DATE_PCT_OF = 1.5777E11;

        Repo(MatchType matchType) {
            this.matchType = matchType;
            switch (matchType) {
                case NEAREST_NEIGHBORS: {
                    this.tokenBinaryTree = new TreeSet();
                }
                case EQUALITY: {
                    this.tokenElementSet = new ConcurrentHashMap<Object, Set<Element>>();
                }
            }
        }

        void put(Token token, Element element) {
            switch (this.matchType) {
                case NEAREST_NEIGHBORS: {
                    this.tokenBinaryTree.add(token.getValue());
                }
                case EQUALITY: {
                    Set elements = this.tokenElementSet.getOrDefault(token.getValue(), new HashSet());
                    elements.add(element);
                    this.tokenElementSet.put(token.getValue(), elements);
                }
            }
        }

        Set<Element> get(Token token) {
            switch (this.matchType) {
                case EQUALITY: {
                    return this.tokenElementSet.get(token.getValue());
                }
                case NEAREST_NEIGHBORS: {
                    TokenRange tokenRange;
                    switch (token.getElement().getElementClassification().getElementType()) {
                        case AGE: {
                            tokenRange = new TokenRange(token, token.getElement().getNeighborhoodRange(), this.AGE_PCT_OF);
                            break;
                        }
                        case DATE: {
                            tokenRange = new TokenRange(token, token.getElement().getNeighborhoodRange(), this.DATE_PCT_OF);
                            break;
                        }
                        default: {
                            tokenRange = new TokenRange(token, token.getElement().getNeighborhoodRange());
                        }
                    }
                    return this.tokenBinaryTree.subSet(tokenRange.lower, true, tokenRange.higher, true).stream().flatMap(val -> this.tokenElementSet.get(val).stream()).collect(Collectors.toSet());
                }
            }
            return null;
        }
    }
}

