/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.domain;

import com.intuit.fuzzymatcher.domain.MatchType;
import com.intuit.fuzzymatcher.function.PreProcessFunction;
import com.intuit.fuzzymatcher.function.TokenizerFunction;
import java.util.function.Function;

public enum ElementType {
    NAME,
    TEXT,
    ADDRESS,
    EMAIL,
    PHONE,
    NUMBER,
    DATE,
    AGE;


    protected Function getPreProcessFunction() {
        switch (this) {
            case NAME: {
                return PreProcessFunction.namePreprocessing();
            }
            case TEXT: {
                return PreProcessFunction.removeSpecialChars();
            }
            case ADDRESS: {
                return PreProcessFunction.addressPreprocessing();
            }
            case EMAIL: {
                return PreProcessFunction.removeDomain();
            }
            case PHONE: {
                return PreProcessFunction.usPhoneNormalization();
            }
            case NUMBER: 
            case AGE: {
                return PreProcessFunction.numberPreprocessing();
            }
        }
        return PreProcessFunction.none();
    }

    protected Function getTokenizerFunction() {
        switch (this) {
            case NAME: {
                return TokenizerFunction.wordSoundexEncodeTokenizer();
            }
            case TEXT: {
                return TokenizerFunction.wordTokenizer();
            }
            case ADDRESS: {
                return TokenizerFunction.wordSoundexEncodeTokenizer();
            }
            case EMAIL: {
                return TokenizerFunction.triGramTokenizer();
            }
            case PHONE: {
                return TokenizerFunction.decaGramTokenizer();
            }
        }
        return TokenizerFunction.valueTokenizer();
    }

    protected MatchType getMatchType() {
        switch (this) {
            case NUMBER: 
            case AGE: 
            case DATE: {
                return MatchType.NEAREST_NEIGHBORS;
            }
        }
        return MatchType.EQUALITY;
    }
}

