/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.fuzzymatcher.domain;

import com.intuit.fuzzymatcher.domain.Matchable;
import com.intuit.fuzzymatcher.domain.Score;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class Match<T extends Matchable> {
    private T data;
    private T matchedWith;
    private Score score;

    public Match(T t, T matchedWith) {
        this.data = t;
        this.matchedWith = matchedWith;
    }

    public Match(T t, T matchedWith, List<Score> childScores) {
        this(t, matchedWith);
        List<Score> maxDistinctChildScores = this.getMaxDistinctScores(childScores);
        this.setScore(maxDistinctChildScores);
    }

    public Match(T t, T matchedWith, double result) {
        this(t, matchedWith);
        this.score = new Score(result, this);
    }

    public T getData() {
        return this.data;
    }

    public T getMatchedWith() {
        return this.matchedWith;
    }

    public double getResult() {
        return this.score.getResult();
    }

    public Score getScore() {
        return this.score;
    }

    public void setScore(List<Score> childScores) {
        if (this.score == null) {
            this.score = this.data.getScoringFunction().apply(this, childScores);
        }
    }

    private List<Score> getMaxDistinctScores(List<Score> scoreList) {
        Map<Matchable, Optional<Score>> map = scoreList.stream().collect(Collectors.groupingBy(s -> s.getMatch().getData(), Collectors.maxBy(Comparator.comparingDouble(Score::getResult))));
        return map.entrySet().stream().map(entry -> (Score)((Optional)entry.getValue()).get()).collect(Collectors.toList());
    }

    public double getWeight() {
        return this.getData().getWeight();
    }

    public String toString() {
        return "Match{data=" + this.data + ", matchedWith=" + this.matchedWith + ", score=" + this.score.getResult() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Match match = (Match)o;
        return Objects.equals(this.data, match.data) && Objects.equals(this.matchedWith, match.matchedWith);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.matchedWith);
    }
}

