/*
 * Decompiled with CFR 0.152.
 */
package com.javaetmoi.core.spring.vfs;

import com.javaetmoi.core.spring.vfs.Vfs2Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.VfsResource;
import org.springframework.util.Assert;

public class Vfs2Resource
extends AbstractResource {
    private final Object resource;

    public Vfs2Resource(Object resources) {
        Assert.notNull((Object)resources, (String)"VirtualFile must not be null");
        this.resource = resources;
    }

    public InputStream getInputStream() throws IOException {
        return Vfs2Utils.getInputStream(this.resource);
    }

    public boolean exists() {
        return Vfs2Utils.exists(this.resource);
    }

    public boolean isReadable() {
        return Vfs2Utils.isReadable(this.resource);
    }

    public URL getURL() throws IOException {
        try {
            return Vfs2Utils.getURL(this.resource);
        }
        catch (Exception ex) {
            throw new NestedIOException("Failed to obtain URL for file " + this.resource, (Throwable)ex);
        }
    }

    public URI getURI() throws IOException {
        try {
            return Vfs2Utils.getURI(this.resource);
        }
        catch (Exception ex) {
            throw new NestedIOException("Failed to obtain URI for " + this.resource, (Throwable)ex);
        }
    }

    public File getFile() throws IOException {
        return Vfs2Utils.getFile(this.resource);
    }

    public long contentLength() throws IOException {
        return Vfs2Utils.getSize(this.resource);
    }

    public long lastModified() throws IOException {
        return Vfs2Utils.getLastModified(this.resource);
    }

    public Resource createRelative(String relativePath) throws IOException {
        if (!relativePath.startsWith(".") && relativePath.contains("/")) {
            try {
                return new VfsResource(Vfs2Utils.getChild(this.resource, relativePath));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new VfsResource(Vfs2Utils.getRelative(new URL(this.getURL(), relativePath)));
    }

    public String getFilename() {
        return Vfs2Utils.getName(this.resource);
    }

    public String getDescription() {
        return this.resource.toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof VfsResource && this.resource.equals(((Vfs2Resource)((Object)obj)).resource);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }
}

