/*
 * Decompiled with CFR 0.152.
 */
package com.javaetmoi.core.spring.vfs;

import com.javaetmoi.core.spring.vfs.Vfs2ResourceHttpRequestHandler;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

class Vfs2ResourceHandlerRegistration
extends ResourceHandlerRegistration {
    public Vfs2ResourceHandlerRegistration(ResourceLoader resourceLoader, String ... pathPatterns) {
        super(resourceLoader, pathPatterns);
    }

    protected ResourceHttpRequestHandler getRequestHandler() {
        Field locationsField = ReflectionUtils.findField(ResourceHandlerRegistration.class, (String)"locations");
        ReflectionUtils.makeAccessible((Field)locationsField);
        List locations = (List)ReflectionUtils.getField((Field)locationsField, (Object)((Object)this));
        Field cachePeriodField = ReflectionUtils.findField(ResourceHandlerRegistration.class, (String)"cachePeriod");
        ReflectionUtils.makeAccessible((Field)cachePeriodField);
        Integer cachePeriod = (Integer)ReflectionUtils.getField((Field)cachePeriodField, (Object)((Object)this));
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)locations) ? 1 : 0) != 0, (String)"At least one location is required for resource handling.");
        Vfs2ResourceHttpRequestHandler requestHandler = new Vfs2ResourceHttpRequestHandler();
        requestHandler.setLocations(locations);
        if (cachePeriod != null) {
            requestHandler.setCacheSeconds(cachePeriod);
        }
        return requestHandler;
    }
}

