/*
 * Decompiled with CFR 0.152.
 */
package com.javaetmoi.core.spring.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NestedIOException;
import org.springframework.util.ReflectionUtils;

public abstract class Vfs2Utils {
    private static final Log logger;
    private static final String VFS2_PKG = "org.jboss.virtual.";
    private static final String VFS3_PKG = "org.jboss.vfs.";
    private static final String VFS_NAME = "VFS";
    private static VFS_VER version;
    private static Method VFS_METHOD_GET_ROOT_URL;
    private static Method VFS_METHOD_GET_ROOT_URI;
    private static Method VIRTUAL_FILE_METHOD_EXISTS;
    private static Method VIRTUAL_FILE_METHOD_GET_INPUT_STREAM;
    private static Method VIRTUAL_FILE_METHOD_GET_SIZE;
    private static Method VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED;
    private static Method VIRTUAL_FILE_METHOD_TO_URL;
    private static Method VIRTUAL_FILE_METHOD_TO_URI;
    private static Method VIRTUAL_FILE_METHOD_GET_NAME;
    private static Method VIRTUAL_FILE_METHOD_GET_PATH_NAME;
    private static Method VIRTUAL_FILE_METHOD_GET_CHILD;
    protected static Class<?> VIRTUAL_FILE_VISITOR_INTERFACE;
    protected static Method VIRTUAL_FILE_METHOD_VISIT;
    private static Method VFS_UTILS_METHOD_IS_NESTED_FILE;
    private static Method VFS_UTILS_METHOD_GET_COMPATIBLE_URI;
    private static Field VISITOR_ATTRIBUTES_FIELD_RECURSE;
    private static Method GET_PHYSICAL_FILE;

    protected static Object invokeVfsMethod(Method method, Object target, Object ... args) throws IOException {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof IOException) {
                throw (IOException)targetEx;
            }
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException((Exception)ex);
        }
        throw new IllegalStateException("Invalid code path reached");
    }

    static boolean exists(Object vfsResource) {
        try {
            return (Boolean)Vfs2Utils.invokeVfsMethod(VIRTUAL_FILE_METHOD_EXISTS, vfsResource, new Object[0]);
        }
        catch (IOException ex) {
            return false;
        }
    }

    static boolean isReadable(Object vfsResource) {
        try {
            return (Long)Vfs2Utils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_SIZE, vfsResource, new Object[0]) > 0L;
        }
        catch (IOException ex) {
            return false;
        }
    }

    static long getSize(Object vfsResource) throws IOException {
        return (Long)Vfs2Utils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_SIZE, vfsResource, new Object[0]);
    }

    static long getLastModified(Object vfsResource) throws IOException {
        return (Long)Vfs2Utils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED, vfsResource, new Object[0]);
    }

    static InputStream getInputStream(Object vfsResource) throws IOException {
        return (InputStream)Vfs2Utils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_INPUT_STREAM, vfsResource, new Object[0]);
    }

    static URL getURL(Object vfsResource) throws IOException {
        return (URL)Vfs2Utils.invokeVfsMethod(VIRTUAL_FILE_METHOD_TO_URL, vfsResource, new Object[0]);
    }

    static URI getURI(Object vfsResource) throws IOException {
        return (URI)Vfs2Utils.invokeVfsMethod(VIRTUAL_FILE_METHOD_TO_URI, vfsResource, new Object[0]);
    }

    static String getName(Object vfsResource) {
        try {
            return (String)Vfs2Utils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_NAME, vfsResource, new Object[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot get resource name", ex);
        }
    }

    static Object getRelative(URL url) throws IOException {
        return Vfs2Utils.invokeVfsMethod(VFS_METHOD_GET_ROOT_URL, null, url);
    }

    static Object getChild(Object vfsResource, String path) throws IOException {
        return Vfs2Utils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_CHILD, vfsResource, path);
    }

    static File getFile(Object vfsResource) throws IOException {
        if (VFS_VER.V2.equals((Object)version)) {
            if (((Boolean)Vfs2Utils.invokeVfsMethod(VFS_UTILS_METHOD_IS_NESTED_FILE, null, vfsResource)).booleanValue()) {
                throw new IOException("File resolution not supported for nested resource: " + vfsResource);
            }
            try {
                return new File((URI)Vfs2Utils.invokeVfsMethod(VFS_UTILS_METHOD_GET_COMPATIBLE_URI, null, vfsResource));
            }
            catch (Exception ex) {
                throw new NestedIOException("Failed to obtain File reference for " + vfsResource, (Throwable)ex);
            }
        }
        return (File)Vfs2Utils.invokeVfsMethod(GET_PHYSICAL_FILE, vfsResource, new Object[0]);
    }

    static Object getRoot(URI url) throws IOException {
        return Vfs2Utils.invokeVfsMethod(VFS_METHOD_GET_ROOT_URI, null, url);
    }

    protected static Object getRoot(URL url) throws IOException {
        return Vfs2Utils.invokeVfsMethod(VFS_METHOD_GET_ROOT_URL, null, url);
    }

    protected static Object doGetVisitorAttribute() {
        return ReflectionUtils.getField((Field)VISITOR_ATTRIBUTES_FIELD_RECURSE, null);
    }

    protected static String doGetPath(Object resource) {
        return (String)ReflectionUtils.invokeMethod((Method)VIRTUAL_FILE_METHOD_GET_PATH_NAME, (Object)resource);
    }

    static {
        String pkg;
        Class<?> vfsClass;
        logger = LogFactory.getLog(Vfs2Utils.class);
        VFS_METHOD_GET_ROOT_URL = null;
        VFS_METHOD_GET_ROOT_URI = null;
        VIRTUAL_FILE_METHOD_EXISTS = null;
        VFS_UTILS_METHOD_IS_NESTED_FILE = null;
        VFS_UTILS_METHOD_GET_COMPATIBLE_URI = null;
        VISITOR_ATTRIBUTES_FIELD_RECURSE = null;
        GET_PHYSICAL_FILE = null;
        ClassLoader loader = Vfs2Utils.class.getClassLoader();
        try {
            vfsClass = loader.loadClass("org.jboss.vfs.VFS");
            version = VFS_VER.V3;
            pkg = VFS3_PKG;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"JBoss VFS packages for JBoss AS 6 found");
            }
        }
        catch (ClassNotFoundException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"JBoss VFS packages for JBoss AS 6 not found; falling back to JBoss AS 5 packages");
            }
            try {
                vfsClass = loader.loadClass("org.jboss.virtual.VFS");
                version = VFS_VER.V2;
                pkg = VFS2_PKG;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"JBoss VFS packages for JBoss AS 5 found");
                }
            }
            catch (ClassNotFoundException ex2) {
                logger.error((Object)"JBoss VFS packages (for both JBoss AS 5 and 6) were not found - JBoss VFS support disabled");
                throw new IllegalStateException("Cannot detect JBoss VFS packages", ex2);
            }
        }
        try {
            String methodName = VFS_VER.V3.equals((Object)version) ? "getChild" : "getRoot";
            VFS_METHOD_GET_ROOT_URL = ReflectionUtils.findMethod(vfsClass, (String)methodName, (Class[])new Class[]{URL.class});
            VFS_METHOD_GET_ROOT_URI = ReflectionUtils.findMethod(vfsClass, (String)methodName, (Class[])new Class[]{URI.class});
            Class<?> virtualFile = loader.loadClass(pkg + "VirtualFile");
            VIRTUAL_FILE_METHOD_EXISTS = ReflectionUtils.findMethod(virtualFile, (String)"exists");
            VIRTUAL_FILE_METHOD_GET_INPUT_STREAM = ReflectionUtils.findMethod(virtualFile, (String)"openStream");
            VIRTUAL_FILE_METHOD_GET_SIZE = ReflectionUtils.findMethod(virtualFile, (String)"getSize");
            VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED = ReflectionUtils.findMethod(virtualFile, (String)"getLastModified");
            VIRTUAL_FILE_METHOD_TO_URI = ReflectionUtils.findMethod(virtualFile, (String)"toURI");
            VIRTUAL_FILE_METHOD_TO_URL = ReflectionUtils.findMethod(virtualFile, (String)"toURL");
            VIRTUAL_FILE_METHOD_GET_NAME = ReflectionUtils.findMethod(virtualFile, (String)"getName");
            VIRTUAL_FILE_METHOD_GET_PATH_NAME = ReflectionUtils.findMethod(virtualFile, (String)"getPathName");
            GET_PHYSICAL_FILE = ReflectionUtils.findMethod(virtualFile, (String)"getPhysicalFile");
            methodName = VFS_VER.V3.equals((Object)version) ? "getChild" : "findChild";
            VIRTUAL_FILE_METHOD_GET_CHILD = ReflectionUtils.findMethod(virtualFile, (String)methodName, (Class[])new Class[]{String.class});
            Class<?> utilsClass = loader.loadClass(pkg + "VFSUtils");
            VFS_UTILS_METHOD_GET_COMPATIBLE_URI = ReflectionUtils.findMethod(utilsClass, (String)"getCompatibleURI", (Class[])new Class[]{virtualFile});
            VFS_UTILS_METHOD_IS_NESTED_FILE = ReflectionUtils.findMethod(utilsClass, (String)"isNestedFile", (Class[])new Class[]{virtualFile});
            VIRTUAL_FILE_VISITOR_INTERFACE = loader.loadClass(pkg + "VirtualFileVisitor");
            VIRTUAL_FILE_METHOD_VISIT = ReflectionUtils.findMethod(virtualFile, (String)"visit", (Class[])new Class[]{VIRTUAL_FILE_VISITOR_INTERFACE});
            Class<?> visitorAttributesClass = loader.loadClass(pkg + "VisitorAttributes");
            VISITOR_ATTRIBUTES_FIELD_RECURSE = ReflectionUtils.findField(visitorAttributesClass, (String)"RECURSE");
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Could not detect the JBoss VFS infrastructure", ex);
        }
    }

    private static enum VFS_VER {
        V2,
        V3;

    }
}

