/*
 * Decompiled with CFR 0.152.
 */
package com.javaetmoi.core.spring.vfs;

import com.javaetmoi.core.spring.vfs.Vfs2PatternUtils;
import com.javaetmoi.core.spring.vfs.Vfs2Resource;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.PathMatcher;

public class Vfs2PathMatchingResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    private static final Log LOGGER = LogFactory.getLog(Vfs2PathMatchingResourcePatternResolver.class);

    public Vfs2PathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Resource[] rootDirResources = this.getResources(rootDirPath);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        for (Resource rootDirResource : rootDirResources) {
            if (this.isJarResource(rootDirResource = this.resolveRootDirResource(rootDirResource))) {
                result.addAll(this.doFindPathMatchingJarResources(rootDirResource, subPattern));
                continue;
            }
            if (rootDirResource.getURL().getProtocol().startsWith("vfs")) {
                result.addAll(VfsResourceMatchingDelegate.findMatchingResources(rootDirResource, subPattern, this.getPathMatcher()));
                continue;
            }
            result.addAll(this.doFindPathMatchingFileResources(rootDirResource, subPattern));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Resolved location pattern [" + locationPattern + "] to resources " + result));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected boolean isJarResource(Resource resource) throws IOException {
        String protocol = resource.getURL().getProtocol();
        return "jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol);
    }

    private static class VfsResourceMatchingDelegate {
        private VfsResourceMatchingDelegate() {
        }

        public static Set<Resource> findMatchingResources(Resource rootResource, String locationPattern, PathMatcher pathMatcher) throws IOException {
            Object root = Vfs2PatternUtils.findRoot(rootResource.getURL());
            PatternVirtualFileVisitor visitor = new PatternVirtualFileVisitor(Vfs2PatternUtils.getPath(root), locationPattern, pathMatcher);
            Vfs2PatternUtils.visit(root, visitor);
            return visitor.getResources();
        }

        private static class PatternVirtualFileVisitor
        implements InvocationHandler {
            private final String subPattern;
            private final PathMatcher pathMatcher;
            private final String rootPath;
            private final Set<Resource> resources = new LinkedHashSet<Resource>();

            public PatternVirtualFileVisitor(String rootPath, String subPattern, PathMatcher pathMatcher) {
                this.subPattern = subPattern;
                this.pathMatcher = pathMatcher;
                this.rootPath = rootPath.length() == 0 || rootPath.endsWith("/") ? rootPath : rootPath + "/";
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (Object.class.equals(method.getDeclaringClass())) {
                    if (methodName.equals("equals")) {
                        return proxy == args[0];
                    }
                    if (methodName.equals("hashCode")) {
                        return System.identityHashCode(proxy);
                    }
                } else {
                    if ("getAttributes".equals(methodName)) {
                        return this.getAttributes();
                    }
                    if ("visit".equals(methodName)) {
                        this.visit(args[0]);
                        return null;
                    }
                    if ("toString".equals(methodName)) {
                        return this.toString();
                    }
                }
                throw new IllegalStateException("Unexpected method invocation: " + method);
            }

            public void visit(Object vfsResource) {
                if (this.pathMatcher.match(this.subPattern, Vfs2PatternUtils.getPath(vfsResource).substring(this.rootPath.length()))) {
                    this.resources.add((Resource)new Vfs2Resource(vfsResource));
                }
            }

            public Object getAttributes() {
                return Vfs2PatternUtils.getVisitorAttribute();
            }

            public Set<Resource> getResources() {
                return this.resources;
            }

            public int size() {
                return this.resources.size();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("sub-pattern: ").append(this.subPattern);
                sb.append(", resources: ").append(this.resources);
                return sb.toString();
            }
        }
    }
}

