/*
 * Decompiled with CFR 0.152.
 */
package com.javaetmoi.core.spring.vfs;

import com.javaetmoi.core.spring.vfs.Vfs2Resource;
import com.javaetmoi.core.spring.vfs.Vfs2Utils;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

class Vfs2ResourceHttpRequestHandler
extends ResourceHttpRequestHandler {
    private static final Log logger = LogFactory.getLog(Vfs2ResourceHttpRequestHandler.class);

    Vfs2ResourceHttpRequestHandler() {
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URL url;
        this.checkAndPrepare(request, response, true);
        Object resource = this.getResource(request);
        if (resource == null) {
            logger.debug((Object)"No matching resource found - returning 404");
            response.sendError(404);
            return;
        }
        MediaType mediaType = this.getMediaType((Resource)resource);
        if (mediaType != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Determined media type '" + mediaType + "' for " + resource));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No media type found for " + resource + " - not sending a content-type header"));
        }
        if ((url = resource.getURL()).getProtocol().startsWith("vfs")) {
            resource = new Vfs2Resource(Vfs2Utils.getRoot(url));
        }
        if (new ServletWebRequest(request, response).checkNotModified(resource.lastModified())) {
            logger.debug((Object)"Resource not modified - returning 304");
            return;
        }
        this.setHeaders(response, (Resource)resource, mediaType);
        if ("HEAD".equals(request.getMethod())) {
            logger.trace((Object)"HEAD request - skipping content");
            return;
        }
        this.writeContent(response, (Resource)resource);
    }
}

