/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.crud.builder;

import com.jeesuite.mybatis.crud.GeneralSqlGenerator;
import com.jeesuite.mybatis.crud.helper.ColumnMapper;
import com.jeesuite.mybatis.crud.helper.EntityHelper;
import com.jeesuite.mybatis.crud.helper.EntityMapper;
import com.jeesuite.mybatis.crud.helper.TableMapper;
import com.jeesuite.mybatis.parser.EntityInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.ibatis.jdbc.SqlBuilder;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public class GetByPrimaryKeyBuilder {
    public static void build(Configuration configuration, LanguageDriver languageDriver, EntityInfo entity) {
        String msId = entity.getMapperClass().getName() + "." + GeneralSqlGenerator.methodDefines.selectName();
        EntityMapper entityMapper = EntityHelper.getEntityMapper(entity.getEntityClass());
        String sql = GetByPrimaryKeyBuilder.buildGetByIdSql(entityMapper);
        SqlSource sqlSource = languageDriver.createSqlSource(configuration, sql, entity.getEntityClass());
        MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, msId, sqlSource, SqlCommandType.SELECT);
        MappedStatement statement = statementBuilder.build();
        GetByPrimaryKeyBuilder.setResultType(configuration, statement, entity.getEntityClass());
        configuration.addMappedStatement(statement);
    }

    private static String buildGetByIdSql(EntityMapper entityMapper) {
        TableMapper tableMapper = entityMapper.getTableMapper();
        Set<ColumnMapper> columnsMapper = entityMapper.getColumnsMapper();
        SqlBuilder.BEGIN();
        SqlBuilder.FROM((String)tableMapper.getName());
        for (ColumnMapper columnMapper : columnsMapper) {
            if (columnMapper.isId()) {
                SqlBuilder.WHERE((String)(columnMapper.getColumn() + "=#{" + columnMapper.getProperty() + "}"));
            }
            SqlBuilder.SELECT((String)columnMapper.getColumn());
        }
        return String.format("<script>%s</script>", SqlBuilder.SQL());
    }

    private static void setResultType(Configuration configuration, MappedStatement ms, Class<?> entityClass) {
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        resultMaps.add(GetByPrimaryKeyBuilder.getResultMap(configuration, entityClass));
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        metaObject.setValue("resultMaps", Collections.unmodifiableList(resultMaps));
    }

    public static ResultMap getResultMap(Configuration configuration, Class<?> entityClass) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        Set<ColumnMapper> entityClassColumns = EntityHelper.getEntityMapper(entityClass).getColumnsMapper();
        for (ColumnMapper entityColumn : entityClassColumns) {
            ResultMapping.Builder builder = new ResultMapping.Builder(configuration, entityColumn.getProperty(), entityColumn.getColumn(), entityColumn.getJavaType());
            if (entityColumn.getJdbcType() != null) {
                builder.jdbcType(entityColumn.getJdbcType());
            }
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (entityColumn.isId()) {
                flags.add(ResultFlag.ID);
            }
            builder.flags(flags);
            builder.lazy(false);
            resultMappings.add(builder.build());
        }
        ResultMap.Builder builder = new ResultMap.Builder(configuration, "BaseResultMap", entityClass, resultMappings, Boolean.valueOf(true));
        return builder.build();
    }
}

