/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.crud.builder;

import com.jeesuite.mybatis.crud.GeneralSqlGenerator;
import com.jeesuite.mybatis.crud.builder.SqlTemplate;
import com.jeesuite.mybatis.crud.helper.ColumnMapper;
import com.jeesuite.mybatis.crud.helper.EntityHelper;
import com.jeesuite.mybatis.crud.helper.EntityMapper;
import com.jeesuite.mybatis.crud.helper.TableMapper;
import com.jeesuite.mybatis.parser.EntityInfo;
import java.util.Set;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public class InsertBuilder {
    public static void build(Configuration configuration, LanguageDriver languageDriver, EntityInfo entity) {
        String[] names;
        for (String name : names = GeneralSqlGenerator.methodDefines.insertName().split(",")) {
            String msId = entity.getMapperClass().getName() + "." + name;
            EntityMapper entityMapper = EntityHelper.getEntityMapper(entity.getEntityClass());
            String sql = InsertBuilder.buildInsertSql(entityMapper, name.endsWith("Selective"));
            SqlSource sqlSource = languageDriver.createSqlSource(configuration, sql, entity.getEntityClass());
            MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, msId, sqlSource, SqlCommandType.INSERT);
            Jdbc3KeyGenerator keyGenerator = entityMapper.autoId() ? new Jdbc3KeyGenerator() : new NoKeyGenerator();
            statementBuilder.keyGenerator((KeyGenerator)keyGenerator).keyProperty(entityMapper.getIdColumn().getProperty()).keyColumn(entityMapper.getIdColumn().getColumn());
            MappedStatement statement = statementBuilder.build();
            configuration.addMappedStatement(statement);
        }
    }

    public static String buildInsertSql(EntityMapper entityMapper, boolean selective) {
        TableMapper table = entityMapper.getTableMapper();
        Set<ColumnMapper> columns = entityMapper.getColumnsMapper();
        StringBuilder fieldBuilder = new StringBuilder("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        StringBuilder prppertyBuilder = new StringBuilder("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        if (!entityMapper.autoId()) {
            fieldBuilder.append(entityMapper.getIdColumn().getColumn()).append(",");
            prppertyBuilder.append("#{").append(entityMapper.getIdColumn().getProperty()).append("},");
        }
        for (ColumnMapper column : columns) {
            if (column.isId() || !column.isInsertable()) continue;
            String fieldExpr = SqlTemplate.wrapIfTag(column.getProperty(), column.getColumn(), !selective);
            String propertyExpr = SqlTemplate.wrapIfTag(column.getProperty(), "#{" + column.getProperty() + "}", !selective);
            fieldBuilder.append(fieldExpr);
            fieldBuilder.append(selective ? "\n" : ",");
            prppertyBuilder.append(propertyExpr);
            prppertyBuilder.append(selective ? "\n" : ",");
        }
        if (!selective) {
            fieldBuilder.deleteCharAt(fieldBuilder.length() - 1);
            prppertyBuilder.deleteCharAt(prppertyBuilder.length() - 1);
        }
        fieldBuilder.append("</trim>");
        prppertyBuilder.append("</trim>");
        String sql = String.format("INSERT INTO %s \n %s \n VALUES \n %s", table.getName(), fieldBuilder.toString(), prppertyBuilder.toString());
        return String.format("<script>%s</script>", sql);
    }

    public static void main(String[] args) {
        String str = "<if test=\"password != null\">password</if>, <if test=\"type != null\">type</if>, <if test=\"email != null\">email</if>";
        System.out.println(str.replaceAll(">,", ">"));
    }
}

