/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.crud.builder;

import com.jeesuite.mybatis.crud.GeneralSqlGenerator;
import com.jeesuite.mybatis.crud.builder.SqlTemplate;
import com.jeesuite.mybatis.crud.helper.ColumnMapper;
import com.jeesuite.mybatis.crud.helper.EntityHelper;
import com.jeesuite.mybatis.crud.helper.EntityMapper;
import com.jeesuite.mybatis.crud.helper.TableMapper;
import com.jeesuite.mybatis.parser.EntityInfo;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public class UpdateBuilder {
    public static void build(Configuration configuration, LanguageDriver languageDriver, EntityInfo entity) {
        String[] names;
        for (String name : names = GeneralSqlGenerator.methodDefines.updateName().split(",")) {
            String msId = entity.getMapperClass().getName() + "." + name;
            EntityMapper entityMapper = EntityHelper.getEntityMapper(entity.getEntityClass());
            String sql = UpdateBuilder.buildUpdateSql(entityMapper, name.endsWith("Selective"));
            SqlSource sqlSource = languageDriver.createSqlSource(configuration, sql, entity.getEntityClass());
            MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, msId, sqlSource, SqlCommandType.UPDATE);
            MappedStatement statement = statementBuilder.build();
            configuration.addMappedStatement(statement);
        }
    }

    public static String buildUpdateSql(EntityMapper entityMapper, boolean selective) {
        TableMapper tableMapper = entityMapper.getTableMapper();
        Set<ColumnMapper> columnMappers = entityMapper.getColumnsMapper();
        String idColumn = null;
        String idProperty = null;
        StringBuilder set = new StringBuilder();
        set.append("<trim prefix=\"SET\" suffixOverrides=\",\">");
        for (ColumnMapper column : columnMappers) {
            if (!column.isUpdatable()) continue;
            if (column.isId()) {
                idColumn = column.getColumn();
                idProperty = column.getProperty();
            }
            String expr = SqlTemplate.wrapIfTag(column.getProperty(), column.getColumn() + "=#{" + column.getProperty() + "}", !selective);
            set.append(expr);
            if (selective) continue;
            set.append(",");
        }
        if (!selective) {
            set.deleteCharAt(set.length() - 1);
        }
        set.append("</trim>");
        String sql = String.format("UPDATE %s %s \n WHERE %s = #{%s}", tableMapper.getName(), set.toString(), idColumn, idProperty);
        return String.format("<script>%s</script>", sql);
    }
}

