/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.crud.helper;

import com.jeesuite.mybatis.core.BaseEntity;
import com.jeesuite.mybatis.crud.helper.ColumnMapper;
import com.jeesuite.mybatis.crud.helper.EntityMapper;
import com.jeesuite.mybatis.crud.helper.TableMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

public class EntityHelper {
    private static final Map<Class<?>, EntityMapper> tableMapperCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityMapper getEntityMapper(Class<?> entityClass) {
        Class<?> clazz = entityClass;
        synchronized (clazz) {
            EntityMapper entityMapper = tableMapperCache.get(entityClass);
            if (entityMapper != null) {
                return entityMapper;
            }
            TableMapper tableMapper = EntityHelper.getTableMapper(entityClass);
            Class<?> idClass = EntityHelper.getIdClass(entityClass);
            List<Field> fields = EntityHelper.getAllField(entityClass);
            HashSet<ColumnMapper> columnMapperSet = new HashSet<ColumnMapper>();
            ColumnMapper idColumn = null;
            GenerationType idStrategy = null;
            for (Field field : fields) {
                if (field.isAnnotationPresent(Transient.class)) continue;
                ColumnMapper columnMapper = new ColumnMapper();
                String columnName = null;
                if (field.isAnnotationPresent(Column.class)) {
                    Column column = field.getAnnotation(Column.class);
                    columnName = column.name();
                    columnMapper.setInsertable(column.insertable());
                    columnMapper.setUpdatable(column.updatable());
                }
                if (columnName == null || columnName.equals("")) {
                    columnName = EntityHelper.camelhumpToUnderline(field.getName());
                }
                columnMapper.setProperty(field.getName());
                columnMapper.setColumn(columnName);
                columnMapper.setJavaType(field.getType());
                if (field.isAnnotationPresent(Id.class)) {
                    columnMapper.setId(true);
                    if (field.isAnnotationPresent(GeneratedValue.class)) {
                        idStrategy = field.getAnnotation(GeneratedValue.class).strategy();
                    }
                    idColumn = columnMapper;
                }
                columnMapperSet.add(columnMapper);
            }
            if (columnMapperSet.size() <= 0) {
                throw new RuntimeException("\u5b9e\u4f53" + entityClass.getName() + "\u4e0d\u5b58\u5728\u6620\u5c04\u5b57\u6bb5");
            }
            if (idColumn == null) {
                throw new RuntimeException("\u5b9e\u4f53" + entityClass.getName() + "\u4e0d\u5b58\u5728\u4e3b\u952e\u6216\u8005");
            }
            entityMapper = new EntityMapper();
            entityMapper.setTableMapper(tableMapper);
            entityMapper.setColumnsMapper(columnMapperSet);
            entityMapper.setIdClass(idClass);
            entityMapper.setIdColumn(idColumn);
            entityMapper.setIdStrategy(idStrategy);
            tableMapperCache.put(entityClass, entityMapper);
            return entityMapper;
        }
    }

    private static Class<?> getIdClass(Class<?> entityClass) {
        Type[] genTypes = entityClass.getGenericInterfaces();
        for (int i = 0; i < genTypes.length; ++i) {
            String s2;
            Type genType = genTypes[i];
            String s1 = genType.getClass().getName();
            if (!s1.startsWith(s2 = BaseEntity.class.getName())) continue;
            Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
            Class mapperClass = (Class)params[0];
            return mapperClass;
        }
        return null;
    }

    private static TableMapper getTableMapper(Class<?> entityClass) {
        TableMapper tableMapper = new TableMapper();
        String tableName = null;
        if (entityClass.isAnnotationPresent(Table.class)) {
            Table table = entityClass.getAnnotation(Table.class);
            tableName = !table.name().equals("") ? table.name() : EntityHelper.camelhumpToUnderline(entityClass.getSimpleName());
        }
        if (tableName == null || tableName.equals("")) {
            throw new RuntimeException("\u5b9e\u4f53" + entityClass.getName() + "\u4e0d\u5b58\u5728'Table'\u6ce8\u89e3");
        }
        tableMapper.setName(tableName);
        return tableMapper;
    }

    private static String camelhumpToUnderline(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
        for (int i = 0; i < size; ++i) {
            char c = chars[i];
            if (EntityHelper.isUppercaseAlpha(c)) {
                sb.append('_').append(c);
                continue;
            }
            sb.append(EntityHelper.toUpperAscii(c));
        }
        String result = sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
        return result.toLowerCase();
    }

    private static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static char toUpperAscii(char c) {
        if (EntityHelper.isUppercaseAlpha(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    private static List<Field> getAllField(Class<?> entityClass) {
        return EntityHelper.getAllField(entityClass, null);
    }

    private static List<Field> getAllField(Class<?> entityClass, List<Field> fieldList) {
        Field[] fields;
        if (fieldList == null) {
            fieldList = new ArrayList<Field>();
        }
        if (entityClass.equals(Object.class)) {
            return fieldList;
        }
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldList.add(field);
        }
        Class<?> superClass = entityClass.getSuperclass();
        if (!(superClass == null || superClass.equals(Object.class) || Map.class.isAssignableFrom(superClass) || Collection.class.isAssignableFrom(superClass))) {
            return EntityHelper.getAllField(entityClass.getSuperclass(), fieldList);
        }
        return fieldList;
    }
}

