/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.datasource;

import com.jeesuite.mybatis.plugin.JeesuiteMybatisInterceptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceContextHolder {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceContextHolder.class);
    private static final AtomicLong counter = new AtomicLong(10L);
    private static final Map<String, String> masters = new HashMap<String, String>();
    private static final Map<String, List<String>> slaves = new HashMap<String, List<String>>();
    private final ThreadLocal<DataSourceContextVals> contextVals = new ThreadLocal();
    private static volatile DataSourceContextHolder holder = new DataSourceContextHolder();

    private DataSourceContextHolder() {
    }

    public static DataSourceContextHolder get() {
        return holder;
    }

    protected void registerDataSourceKey(String dsKey) {
        String dbIndex = "0";
        if (dsKey.startsWith("group")) {
            dbIndex = dsKey.split("\\_")[0].replace("group", "");
        }
        if (dsKey.contains("master")) {
            masters.put(dbIndex, dsKey);
        } else {
            List<Object> sameDbSlaves = null;
            if (slaves.containsKey(dbIndex)) {
                sameDbSlaves = slaves.get(dbIndex);
            } else {
                sameDbSlaves = new ArrayList();
                slaves.put(dbIndex, sameDbSlaves);
            }
            sameDbSlaves.add(dsKey);
        }
    }

    public void setDbIndex(int dbIndex) {
        DataSourceContextVals vals = this.contextVals.get();
        if (vals == null) {
            vals = new DataSourceContextVals();
        }
        vals.dbIndex = dbIndex;
        this.contextVals.set(vals);
    }

    public DataSourceContextHolder useSlave(boolean useSlave) {
        DataSourceContextVals vals = this.contextVals.get();
        if (vals == null) {
            vals = new DataSourceContextVals();
        }
        vals.userSlave = useSlave;
        this.contextVals.set(vals);
        return this;
    }

    protected String getDataSourceKey() {
        if (!JeesuiteMybatisInterceptor.isRwRouteEnabled() && !JeesuiteMybatisInterceptor.isDbShardEnabled()) {
            return masters.get(0);
        }
        DataSourceContextVals vals = this.contextVals.get();
        if (vals == null) {
            vals = new DataSourceContextVals();
            this.contextVals.set(vals);
            return masters.get(0);
        }
        int dbGoupId = vals.dbIndex;
        String dsKey = null;
        if (vals.forceMaster || !vals.userSlave) {
            if (dbGoupId > 0 && masters.size() <= dbGoupId + 1) {
                throw new RuntimeException("expect db group number is :" + dbGoupId + ",actaul:" + (dbGoupId + 1));
            }
            dsKey = masters.get(String.valueOf(dbGoupId));
        } else {
            if (dbGoupId > 0 && slaves.size() <= dbGoupId + 1) {
                throw new RuntimeException("expect db group number is :" + dbGoupId + ",actaul:" + (dbGoupId + 1));
            }
            dsKey = DataSourceContextHolder.selectSlave(Integer.valueOf(dbGoupId));
        }
        vals.dsKey = dsKey;
        logger.debug("current route rule is:userSlave[{}]|forceMaster[{}], use dataSource key is [{}]!", new Object[]{vals.userSlave, vals.forceMaster, vals.dsKey});
        return dsKey;
    }

    public void forceMaster() {
        DataSourceContextVals vals = this.contextVals.get();
        if (vals == null) {
            vals = new DataSourceContextVals();
            vals.forceMaster = true;
            this.contextVals.set(vals);
        }
    }

    public boolean isForceUseMaster() {
        DataSourceContextVals vals = this.contextVals.get();
        if (vals == null) {
            return false;
        }
        return vals.forceMaster;
    }

    private static String selectSlave(Serializable dbIndex) {
        List<String> sameDbSlaves = slaves.get(dbIndex.toString());
        if (sameDbSlaves == null || sameDbSlaves.isEmpty()) {
            String masterKey = masters.get(dbIndex.toString());
            logger.debug("current no slave found ,default use [{}]!", (Object)masterKey);
            return masterKey;
        }
        if (sameDbSlaves.size() == 1) {
            return sameDbSlaves.get(0);
        }
        int selectIndex = (int)(counter.getAndIncrement() % (long)sameDbSlaves.size());
        String slaveKey = sameDbSlaves.get(selectIndex);
        return slaveKey;
    }

    public void clear() {
        this.contextVals.remove();
    }

    private class DataSourceContextVals {
        public int dbIndex;
        public boolean userSlave;
        public boolean forceMaster;
        public String dsKey;

        private DataSourceContextVals() {
        }
    }
}

