/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.jeesuite.common.util.ResourceUtils;
import com.jeesuite.mybatis.datasource.DataSourceContextHolder;
import com.jeesuite.spring.InstanceFactory;
import com.jeesuite.spring.SpringInstanceProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;

public class MutiRouteDataSource
extends AbstractDataSource
implements ApplicationContextAware,
InitializingBean,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(MutiRouteDataSource.class);
    private static final String MASTER_KEY = "master";
    private ApplicationContext context;
    private Map<Object, DataSource> targetDataSources;
    private DataSource defaultDataSource;
    private int dbGroupNums = 1;
    private Environment environment;
    private DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();

    public void addTargetDataSources(Map<Object, DataSource> targetDataSources) {
        if (this.targetDataSources == null) {
            this.targetDataSources = targetDataSources;
        } else {
            this.targetDataSources.putAll(targetDataSources);
        }
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        this.dataSourceLookup = dataSourceLookup != null ? dataSourceLookup : new JndiDataSourceLookup();
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() {
        Map<String, DataSourceInfo> map = this.parseDataSourceConfFromProperties();
        if (map.isEmpty()) {
            throw new RuntimeException("Db config Not found..");
        }
        this.registerDataSources(map);
        if (this.targetDataSources == null || this.targetDataSources.isEmpty()) {
            throw new IllegalArgumentException("Property 'targetDataSources' is required");
        }
        if (this.defaultDataSource == null) {
            throw new IllegalArgumentException("Property 'defaultDataSource' is required");
        }
    }

    protected Object resolveSpecifiedLookupKey(Object lookupKey) {
        return lookupKey;
    }

    protected DataSource resolveSpecifiedDataSource(Object dataSource) throws IllegalArgumentException {
        if (dataSource instanceof DataSource) {
            return (DataSource)dataSource;
        }
        if (dataSource instanceof String) {
            return this.dataSourceLookup.getDataSource((String)dataSource);
        }
        throw new IllegalArgumentException("Illegal data source value - only [javax.sql.DataSource] and String supported: " + dataSource);
    }

    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineTargetDataSource().getConnection(username, password);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        return this.determineTargetDataSource().unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance((Object)this) || this.determineTargetDataSource().isWrapperFor(iface);
    }

    protected DataSource determineTargetDataSource() {
        Object lookupKey = this.determineCurrentLookupKey();
        if (lookupKey == null) {
            return this.defaultDataSource;
        }
        DataSource dataSource = this.targetDataSources.get(lookupKey);
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    protected Object determineCurrentLookupKey() {
        return DataSourceContextHolder.get().getDataSourceKey();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        InstanceFactory.setInstanceProvider((SpringInstanceProvider)new SpringInstanceProvider(this.context));
    }

    private void registerDataSources(Map<String, DataSourceInfo> mapCustom) {
        DefaultListableBeanFactory acf = (DefaultListableBeanFactory)this.context.getAutowireCapableBeanFactory();
        Iterator<String> iter = mapCustom.keySet().iterator();
        HashMap<Object, DataSource> targetDataSources = new HashMap<Object, DataSource>();
        while (iter.hasNext()) {
            String dsKey = iter.next();
            DataSourceInfo dataSourceInfo = mapCustom.get(dsKey);
            logger.info(">>>>>begin to initialize datasource\uff1a" + dsKey + "\n================\n" + dataSourceInfo.toString() + "\n==============");
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DruidDataSource.class);
            beanDefinitionBuilder.addPropertyValue("driverClassName", (Object)dataSourceInfo.driveClassName);
            beanDefinitionBuilder.addPropertyValue("url", (Object)dataSourceInfo.connUrl);
            beanDefinitionBuilder.addPropertyValue("username", (Object)dataSourceInfo.userName);
            beanDefinitionBuilder.addPropertyValue("password", (Object)dataSourceInfo.password);
            beanDefinitionBuilder.addPropertyValue("testWhileIdle", (Object)true);
            beanDefinitionBuilder.addPropertyValue("validationQuery", (Object)"SELECT 'x'");
            if (dataSourceInfo.initialSize > 0) {
                beanDefinitionBuilder.addPropertyValue("initialSize", (Object)dataSourceInfo.initialSize);
            }
            if (dataSourceInfo.maxActive > 0) {
                beanDefinitionBuilder.addPropertyValue("maxActive", (Object)dataSourceInfo.maxActive);
            }
            if (dataSourceInfo.maxIdle > 0) {
                beanDefinitionBuilder.addPropertyValue("maxIdle", (Object)dataSourceInfo.maxIdle);
            }
            if (dataSourceInfo.minIdle > 0) {
                beanDefinitionBuilder.addPropertyValue("minIdle", (Object)dataSourceInfo.minIdle);
            }
            if (dataSourceInfo.maxWait > 0L) {
                beanDefinitionBuilder.addPropertyValue("maxWait", (Object)dataSourceInfo.maxWait);
            }
            if (dataSourceInfo.minEvictableIdleTimeMillis > 0L) {
                beanDefinitionBuilder.addPropertyValue("minEvictableIdleTimeMillis", (Object)dataSourceInfo.minEvictableIdleTimeMillis);
            }
            if (dataSourceInfo.timeBetweenEvictionRunsMillis > 0L) {
                beanDefinitionBuilder.addPropertyValue("timeBetweenEvictionRunsMillis", (Object)dataSourceInfo.timeBetweenEvictionRunsMillis);
            }
            if (dataSourceInfo.maxWait > 0L) {
                beanDefinitionBuilder.addPropertyValue("maxWait", (Object)dataSourceInfo.maxWait);
            }
            beanDefinitionBuilder.addPropertyValue("testOnBorrow", (Object)dataSourceInfo.testOnBorrow);
            beanDefinitionBuilder.addPropertyValue("testOnReturn", (Object)dataSourceInfo.testOnReturn);
            acf.registerBeanDefinition(dsKey, (BeanDefinition)beanDefinitionBuilder.getRawBeanDefinition());
            DruidDataSource ds = (DruidDataSource)this.context.getBean(dsKey);
            targetDataSources.put(dsKey, (DataSource)ds);
            if (dataSourceInfo.dbGroupIndex == this.dbGroupNums - 1) {
                this.defaultDataSource = ds;
            }
            logger.info("bean[" + dsKey + "] has initialized! lookupKey:" + dsKey);
            DataSourceContextHolder.get().registerDataSourceKey(dsKey);
        }
        this.addTargetDataSources(targetDataSources);
    }

    private Map<String, DataSourceInfo> parseDataSourceConfFromProperties() {
        HashMap<String, DataSourceInfo> mapDataSource = new HashMap<String, DataSourceInfo>();
        this.dbGroupNums = Integer.parseInt(this.getProperty("db.group.size", "1"));
        logger.info(">>>>>>dbGroupNums:" + this.dbGroupNums);
        for (int i = 0; i < this.dbGroupNums; ++i) {
            String groupPrefix = i == 0 ? "" : "group" + i;
            String datasourceKey = (StringUtils.isNotBlank((CharSequence)groupPrefix) ? groupPrefix + "." : "") + MASTER_KEY;
            DataSourceInfo sourceInfo = new DataSourceInfo(i, datasourceKey);
            mapDataSource.put(datasourceKey, sourceInfo);
            int index = 1;
            while (this.containsProperty((datasourceKey = (StringUtils.isNotBlank((CharSequence)groupPrefix) ? groupPrefix + "." : "") + "slave" + index) + ".db.url")) {
                sourceInfo = new DataSourceInfo(i, datasourceKey);
                mapDataSource.put(datasourceKey, sourceInfo);
                ++index;
            }
        }
        return mapDataSource;
    }

    private String getProperty(String key, String ... defs) {
        String value = null;
        String defValue = defs != null && defs.length > 0 && defs[0] != null ? defs[0] : null;
        value = this.environment.getProperty(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = ResourceUtils.getProperty((String)key);
        }
        return StringUtils.isBlank((CharSequence)value) ? defValue : value;
    }

    private boolean containsProperty(String key) {
        return this.environment.containsProperty(key) || StringUtils.isNotBlank((CharSequence)ResourceUtils.getProperty((String)key));
    }

    private class DataSourceInfo {
        public int dbGroupIndex;
        public String driveClassName;
        public String connUrl;
        public String userName;
        public String password;
        public boolean master;
        protected int initialSize;
        protected int maxActive;
        protected int minIdle;
        protected int maxIdle;
        protected long maxWait;
        public long minEvictableIdleTimeMillis;
        public long timeBetweenEvictionRunsMillis;
        public boolean testOnBorrow;
        public boolean testOnReturn;

        public DataSourceInfo(int groupIndex, String keyPrefix) {
            String tmpVal = null;
            this.dbGroupIndex = groupIndex;
            this.driveClassName = MutiRouteDataSource.this.getProperty("db.driverClass", new String[0]);
            this.initialSize = Integer.parseInt(MutiRouteDataSource.this.getProperty("db.initialSize", new String[]{"1"}));
            this.minIdle = Integer.parseInt(MutiRouteDataSource.this.getProperty("db.minIdle", new String[]{"1"}));
            this.maxActive = Integer.parseInt(MutiRouteDataSource.this.getProperty("db.maxActive", new String[]{"10"}));
            this.maxWait = Integer.parseInt(MutiRouteDataSource.this.getProperty("db.maxWait", new String[]{"60000"}));
            this.minEvictableIdleTimeMillis = Integer.parseInt(MutiRouteDataSource.this.getProperty("db.minEvictableIdleTimeMillis", new String[]{"300000"}));
            this.timeBetweenEvictionRunsMillis = Integer.parseInt(MutiRouteDataSource.this.getProperty("db.timeBetweenEvictionRunsMillis", new String[]{"60000"}));
            this.testOnBorrow = Boolean.parseBoolean(MutiRouteDataSource.this.getProperty("db.testOnBorrow", new String[]{"false"}));
            this.testOnReturn = Boolean.parseBoolean(MutiRouteDataSource.this.getProperty("db.testOnReturn", new String[]{"false"}));
            this.master = keyPrefix.contains(MutiRouteDataSource.MASTER_KEY);
            this.connUrl = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.url", new String[0]);
            Validate.notBlank((CharSequence)this.connUrl, (String)"Config [%s.db.url] is required", (Object[])new Object[]{keyPrefix});
            this.userName = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.username", new String[0]);
            Validate.notBlank((CharSequence)this.userName, (String)"Config [%s.db.username] is required", (Object[])new Object[]{keyPrefix});
            this.password = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.password", new String[0]);
            Validate.notBlank((CharSequence)this.password, (String)"Config [%s.db.password] is required", (Object[])new Object[]{keyPrefix});
            tmpVal = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.initialSize", new String[0]);
            if (tmpVal != null) {
                this.initialSize = Integer.parseInt(tmpVal);
            }
            if ((tmpVal = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.minIdle", new String[0])) != null) {
                this.minIdle = Integer.parseInt(tmpVal);
            }
            if ((tmpVal = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.maxActive", new String[0])) != null) {
                this.maxActive = Integer.parseInt(tmpVal);
            }
            if ((tmpVal = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.minEvictableIdleTimeMillis", new String[0])) != null) {
                this.minEvictableIdleTimeMillis = Integer.parseInt(tmpVal);
            }
            if ((tmpVal = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.minEvictableIdleTimeMillis", new String[0])) != null) {
                this.minEvictableIdleTimeMillis = Integer.parseInt(tmpVal);
            }
            if ((tmpVal = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.timeBetweenEvictionRunsMillis", new String[0])) != null) {
                this.timeBetweenEvictionRunsMillis = Integer.parseInt(tmpVal);
            }
            if ((tmpVal = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.testOnBorrow", new String[0])) != null) {
                this.testOnBorrow = Boolean.parseBoolean(tmpVal);
            }
            if ((tmpVal = MutiRouteDataSource.this.getProperty(keyPrefix + ".db.testOnReturn", new String[0])) != null) {
                this.testOnReturn = Boolean.parseBoolean(tmpVal);
            }
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append("dbGroupIndex").append(" = ").append(this.dbGroupIndex).append("\n");
            str.append("role").append(" = ").append(this.master ? MutiRouteDataSource.MASTER_KEY : "slave").append("\n");
            str.append("driveClassName").append(" = ").append(this.driveClassName).append("\n");
            str.append("connUrl").append(" = ").append(this.connUrl).append("\n");
            str.append("userName").append(" = ").append(this.userName);
            return str.toString();
        }
    }
}

